/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.shared_core.partitioner.ITokenScanner;
import org.python.pydev.ui.ColorAndStyleCache;

public abstract class AbstractTokenScanner
implements ITokenScanner {
    protected final ColorAndStyleCache colorCache;
    protected char[] fChars;
    protected int fInitialOffset;
    protected int fCurrentTokenIndexStartRelativeToInitialOffset;
    protected int fCurrentIndexRelativeToInitialOffset;

    public AbstractTokenScanner(ColorAndStyleCache colorCache) {
        this.colorCache = colorCache;
        this.updateColorAndStyle();
    }

    protected abstract void updateColorAndStyle();

    public void setRange(IDocument document, int offset, int length) {
        Assert.isLegal((document != null ? 1 : 0) != 0);
        int documentLength = document.getLength();
        this.checkRange(offset, length, documentLength);
        this.fInitialOffset = offset;
        this.fCurrentTokenIndexStartRelativeToInitialOffset = 0;
        this.fCurrentIndexRelativeToInitialOffset = 0;
        try {
            this.fChars = document.get(offset, length).toCharArray();
        }
        catch (BadLocationException e) {
            throw new RuntimeException(e);
        }
    }

    private void checkRange(int offset, int length, int documentLength) {
        Assert.isLegal((offset > -1 ? 1 : 0) != 0);
        Assert.isLegal((length > -1 ? 1 : 0) != 0);
        Assert.isLegal((offset + length <= documentLength ? 1 : 0) != 0);
    }

    public int getTokenOffset() {
        return this.fInitialOffset + this.fCurrentTokenIndexStartRelativeToInitialOffset;
    }

    public int getTokenLength() {
        return this.fCurrentIndexRelativeToInitialOffset - this.fCurrentTokenIndexStartRelativeToInitialOffset;
    }

    protected int read() {
        if (this.fCurrentIndexRelativeToInitialOffset >= this.fChars.length) {
            ++this.fCurrentIndexRelativeToInitialOffset;
            return -1;
        }
        char c = this.fChars[this.fCurrentIndexRelativeToInitialOffset];
        ++this.fCurrentIndexRelativeToInitialOffset;
        return c;
    }

    protected void unread() {
        --this.fCurrentIndexRelativeToInitialOffset;
    }
}

