/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextOperationTargetExtension;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorExtension5;
import org.eclipse.ui.texteditor.TextEditorAction;

public class MacroModeStateHandler {
    private static final String CONTENT_ASSIST_ENABLED = "contentAssistEnabled";
    private static final String QUICK_ASSIST_ENABLED = "quickAssistEnabled";
    private IEditorPart fEditorPart;
    private Map<String, Boolean> fMemento = new HashMap<String, Boolean>();

    public MacroModeStateHandler(IEditorPart editorPart) {
        this.fEditorPart = editorPart;
    }

    public void enterMacroMode() {
        ITextOperationTarget textOperationTarget;
        ITextEditorExtension5 iTextEditorExtension5;
        if (this.fEditorPart instanceof ITextEditorExtension5 && (iTextEditorExtension5 = (ITextEditorExtension5)this.fEditorPart).isBlockSelectionModeEnabled()) {
            iTextEditorExtension5.setBlockSelectionMode(false);
        }
        if (this.fEditorPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)this.fEditorPart;
            this.disable(textEditor, "ContentAssistProposal");
            this.disable(textEditor, "QuickAssist");
            this.disable(textEditor, "BlockSelectionMode");
        }
        if (this.fEditorPart != null && (textOperationTarget = (ITextOperationTarget)this.fEditorPart.getAdapter(ITextOperationTarget.class)) instanceof ITextOperationTargetExtension) {
            ITextOperationTargetExtension targetExtension = (ITextOperationTargetExtension)textOperationTarget;
            this.disable(textOperationTarget, targetExtension, 13, CONTENT_ASSIST_ENABLED);
            this.disable(textOperationTarget, targetExtension, 22, QUICK_ASSIST_ENABLED);
        }
    }

    public void leaveMacroMode() {
        if (this.fEditorPart != null) {
            ITextOperationTarget textOperationTarget = (ITextOperationTarget)this.fEditorPart.getAdapter(ITextOperationTarget.class);
            if (textOperationTarget instanceof ITextOperationTargetExtension) {
                ITextOperationTargetExtension targetExtension = (ITextOperationTargetExtension)textOperationTarget;
                if (textOperationTarget instanceof ITextOperationTargetExtension) {
                    this.restore(targetExtension, 13, CONTENT_ASSIST_ENABLED);
                    this.restore(targetExtension, 22, QUICK_ASSIST_ENABLED);
                }
            }
            if (this.fEditorPart instanceof ITextEditor) {
                ITextEditor textEditor = (ITextEditor)this.fEditorPart;
                this.restore(textEditor, "ContentAssistProposal");
                this.restore(textEditor, "QuickAssist");
                this.restore(textEditor, "BlockSelectionMode");
            }
        }
    }

    private void restore(ITextOperationTargetExtension targetExtension, int operation, String preference) {
        Boolean contentAssistProposalsBeforMacroMode = this.fMemento.get(preference);
        if (contentAssistProposalsBeforMacroMode != null) {
            if (contentAssistProposalsBeforMacroMode.booleanValue()) {
                targetExtension.enableOperation(operation, true);
            } else {
                targetExtension.enableOperation(operation, false);
            }
        }
    }

    private void restore(ITextEditor textEditor, String actionId) {
        IAction action;
        Control control;
        Boolean b = this.fMemento.get(actionId);
        if (b != null && b.booleanValue() && (control = (Control)textEditor.getAdapter(Control.class)) != null && !control.isDisposed() && (action = textEditor.getAction(actionId)) instanceof TextEditorAction) {
            TextEditorAction textEditorAction = (TextEditorAction)action;
            textEditorAction.setEditor(textEditor);
            textEditorAction.update();
        }
    }

    private void disable(ITextOperationTarget textOperationTarget, ITextOperationTargetExtension targetExtension, int operation, String preference) {
        if (textOperationTarget.canDoOperation(operation)) {
            this.fMemento.put(preference, true);
            targetExtension.enableOperation(operation, false);
        }
    }

    private void disable(ITextEditor textEditor, String actionId) {
        IAction action = textEditor.getAction(actionId);
        if (action != null && action instanceof TextEditorAction) {
            TextEditorAction textEditorAction = (TextEditorAction)action;
            this.fMemento.put(actionId, true);
            textEditorAction.setEditor(null);
            textEditorAction.update();
        }
    }
}

