/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.structure.Tuple;

public abstract class AbstractBlockCommentAction
extends PyAction {
    protected boolean alignRight = true;
    protected int defaultCols = 80;

    public AbstractBlockCommentAction() {
    }

    protected AbstractBlockCommentAction(int defaultCols, boolean alignLeft) {
        this.defaultCols = defaultCols;
        this.alignRight = alignLeft;
    }

    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PySelection ps = PySelectionFromEditor.createPySelectionFromEditor(this.getTextEditor());
            Tuple<Integer, Integer> toSelect = this.perform(ps);
            if (toSelect != null) {
                this.getTextEditor().selectAndReveal(((Integer)toSelect.o1).intValue(), ((Integer)toSelect.o2).intValue());
            } else {
                this.revealSelEndLine(ps);
            }
        }
        catch (Exception e) {
            AbstractBlockCommentAction.beep((Exception)e);
        }
    }

    public abstract Tuple<Integer, Integer> perform(PySelection var1);

    public Tuple<Integer, Character> getColsAndChar(IAdaptable projectAdaptable) {
        int cols = this.defaultCols;
        char c = '-';
        if (!SharedCorePlugin.inTestMode()) {
            IPreferenceStore chainedPrefStore = PyDevUiPrefs.getChainedPrefStore();
            cols = chainedPrefStore.getInt("printMarginColumn");
            String s = PyScopedPreferences.getString((String)this.getPreferencesNameForChar(), (IAdaptable)projectAdaptable);
            if (s != null && s.length() > 0) {
                c = s.charAt(0);
            }
        }
        return new Tuple((Object)cols, (Object)Character.valueOf(c));
    }

    public int getEditorTabWidth() {
        if (SharedCorePlugin.inTestMode()) {
            return 4;
        }
        IPreferenceStore chainedPrefStore = PyDevUiPrefs.getChainedPrefStore();
        return chainedPrefStore.getInt("tabWidth");
    }

    protected abstract String getPreferencesNameForChar();

    protected int getLenOfStrConsideringTabEditorLen(String str) {
        int ret = 0;
        int tabWidth = this.getEditorTabWidth();
        int i = 0;
        while (i < str.length()) {
            ret = str.charAt(i) == '\t' ? (ret += tabWidth) : ++ret;
            ++i;
        }
        return ret;
    }
}

