/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.formatter.PyFormatterPreferences;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.editor.actions.AbstractBlockCommentAction;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.Tuple;

public class PyAddBlockComment
extends AbstractBlockCommentAction {
    private boolean defaultClassNameBehaviour;
    private boolean defaultFunctionNameBehaviour;
    private FormatStd std;

    public PyAddBlockComment(FormatStd std) {
        this.std = std;
    }

    public PyAddBlockComment() {
        this(null);
    }

    PyAddBlockComment(FormatStd std, int defaultCols, boolean alignLeft, boolean classNameBehaviour, boolean functionNameBehaviour) {
        super(defaultCols, alignLeft);
        this.std = std;
        this.defaultClassNameBehaviour = classNameBehaviour;
        this.defaultFunctionNameBehaviour = functionNameBehaviour;
    }

    @Override
    protected void revealSelEndLine(PySelection ps) {
        this.getTextEditor().selectAndReveal(ps.getEndLine().getOffset(), 0);
    }

    protected boolean getUseClassNameBehaviour(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return this.defaultClassNameBehaviour;
        }
        return PyScopedPreferences.getBoolean((String)"MULTI_BLOCK_COMMENT_SHOW_ONLY_CLASS_NAME", (IAdaptable)projectAdaptable);
    }

    protected boolean getUseFunctionNameBehaviour(IAdaptable projectAdaptable) {
        if (SharedCorePlugin.inTestMode()) {
            return this.defaultFunctionNameBehaviour;
        }
        return PyScopedPreferences.getBoolean((String)"MULTI_BLOCK_COMMENT_SHOW_ONLY_FUNCTION_NAME", (IAdaptable)projectAdaptable);
    }

    @Override
    public Tuple<Integer, Integer> perform(PySelection ps) {
        FastStringBuffer strbuf = new FastStringBuffer();
        FastStringBuffer tempBuffer = new FastStringBuffer();
        ps.selectCompleteLine();
        try {
            String endLineDelim = ps.getEndLineDelim();
            int startLineIndex = ps.getStartLineIndex();
            int endLineIndex = ps.getEndLineIndex();
            ITextEditor projectAdaptable = this.getTextEditor();
            boolean classBehaviour = false;
            if (startLineIndex == endLineIndex && this.getUseClassNameBehaviour((IAdaptable)projectAdaptable) && ps.isInClassLine()) {
                classBehaviour = true;
            }
            boolean functionBehaviour = false;
            if (startLineIndex == endLineIndex && this.getUseFunctionNameBehaviour((IAdaptable)projectAdaptable) && ps.isInFunctionLine(false)) {
                functionBehaviour = true;
            }
            if (classBehaviour || functionBehaviour) {
                int tokLen;
                int classIndex;
                String line = ps.getLine(startLineIndex);
                if (classBehaviour) {
                    classIndex = line.indexOf("class ");
                    tokLen = 6;
                } else {
                    classIndex = line.indexOf("def ");
                    tokLen = 4;
                }
                String fullCommentLine = this.getFullCommentLine(classIndex, tempBuffer, (IAdaptable)this.getTextEditor());
                String spacesBefore = classIndex > 0 ? line.substring(0, classIndex) : "";
                strbuf.append(spacesBefore + "#").append(fullCommentLine).append(endLineDelim);
                String initialLine = line;
                line = line.substring(classIndex + tokLen);
                FastStringBuffer className = new FastStringBuffer();
                int i = 0;
                while (i < line.length()) {
                    char cN = line.charAt(i);
                    if (!Character.isJavaIdentifierPart(cN)) break;
                    className.append(cN);
                    ++i;
                }
                strbuf.append(spacesBefore);
                strbuf.append("# ");
                strbuf.append(className);
                strbuf.append(endLineDelim);
                strbuf.append(spacesBefore);
                strbuf.append("#").append(fullCommentLine);
                strbuf.append(endLineDelim);
                strbuf.append(initialLine);
            } else {
                FormatStd std;
                ArrayList<String> lines = new ArrayList<String>();
                int minCharsBefore = Integer.MAX_VALUE;
                int i = startLineIndex;
                while (i <= endLineIndex) {
                    String line = ps.getLine(i);
                    minCharsBefore = Math.min(minCharsBefore, PySelection.getFirstCharPosition((String)line));
                    lines.add(line);
                    ++i;
                }
                String firstLine = (String)lines.get(0);
                String lastLine = (String)lines.get(lines.size() - 1);
                String strBefore = firstLine.substring(0, minCharsBefore);
                String fullCommentLine = this.getFullCommentLine(this.getLenOfStrConsideringTabEditorLen(strBefore), tempBuffer.clear(), (IAdaptable)this.getTextEditor());
                strbuf.append(strBefore).append("#").append(fullCommentLine).append(endLineDelim);
                String spacesInStartComment = null;
                FormatStd formatStd = std = this.std != null ? this.std : PyFormatterPreferences.getFormatStd((IAdaptable)this.getPyEdit());
                if (std.spacesInStartComment != 0) {
                    spacesInStartComment = std.spacesInStartComment < 0 ? StringUtils.createSpaceString((int)1) : StringUtils.createSpaceString((int)std.spacesInStartComment);
                }
                int i2 = startLineIndex;
                while (i2 <= endLineIndex) {
                    String line = ps.getLine(i2);
                    strbuf.append(line.substring(0, minCharsBefore));
                    strbuf.append("#");
                    line = line.substring(minCharsBefore);
                    strbuf.append(spacesInStartComment);
                    strbuf.append(line);
                    strbuf.append(endLineDelim);
                    ++i2;
                }
                String strAfter = firstLine.substring(0, minCharsBefore);
                fullCommentLine = this.getFullCommentLine(this.getLenOfStrConsideringTabEditorLen(strAfter), tempBuffer.clear(), (IAdaptable)this.getTextEditor());
                strbuf.append(lastLine.substring(0, minCharsBefore)).append("#").append(fullCommentLine);
            }
            int startOffset = ps.getStartLine().getOffset();
            String str = strbuf.toString();
            ps.getDoc().replace(startOffset, ps.getSelLength(), str);
            return new Tuple((Object)(startOffset + str.length()), (Object)0);
        }
        catch (Exception e) {
            e.printStackTrace();
            PyAddBlockComment.beep((Exception)e);
            return null;
        }
    }

    @Override
    protected String getPreferencesNameForChar() {
        return "MULTI_BLOCK_COMMENT_CHAR";
    }

    protected String getFullCommentLine(int subtract, FastStringBuffer buffer, IAdaptable projectAdaptable) {
        Tuple<Integer, Character> colsAndChar = this.getColsAndChar(projectAdaptable);
        int cols = (Integer)colsAndChar.o1 - subtract;
        char c = ((Character)colsAndChar.o2).charValue();
        buffer.clear();
        int i = 0;
        while (i < cols - 1) {
            buffer.append(c);
            ++i;
        }
        return buffer.toString();
    }
}

