/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PyScopedPreferences;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.commentblocks.CommentBlocksPreferences;
import org.python.pydev.shared_core.actions.LineCommentAction;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.EditorUtils;

public class PyComment
extends PyAction {
    protected FormatStd std;

    public PyComment(FormatStd std) {
        this.std = std;
    }

    public PyComment() {
        this(null);
    }

    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            PyEdit pyEdit = this.getPyEdit();
            this.std = pyEdit.getFormatStd();
            TextSelectionUtils ps = EditorUtils.createTextSelectionUtils((ITextEditor)pyEdit);
            ITextEditor projectAdaptable = this.getTextEditor();
            String commentOption = PyScopedPreferences.getString((String)"ADD_COMMENTS_OPTION", (IAdaptable)projectAdaptable);
            Tuple<Integer, Integer> repRegion = this.perform(ps, commentOption);
            pyEdit.selectAndReveal((Integer)repRegion.o1, (Integer)repRegion.o2);
        }
        catch (Exception e) {
            PyComment.beep((Exception)e);
        }
    }

    public Tuple<Integer, Integer> perform(TextSelectionUtils ps, String addCommentsOption) throws BadLocationException {
        return this.performComment(ps, addCommentsOption);
    }

    protected Tuple<Integer, Integer> performComment(TextSelectionUtils ps, String addCommentsOption) throws BadLocationException {
        if (addCommentsOption == null || !CommentBlocksPreferences.getValuesForAddCommentsOption().contains(addCommentsOption)) {
            Log.log((String)("Unexpected option to add comments: " + addCommentsOption));
            addCommentsOption = "ADD_COMMENTS_INDENT";
        }
        int spacesInStart = this.std.spacesInStartComment;
        LineCommentAction lineCommentAction = new LineCommentAction(ps, "#", spacesInStart, addCommentsOption);
        return lineCommentAction.execute();
    }
}

