/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.autoedit.DefaultIndentPrefs;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_ui.EditorUtils;

public class PyConvertSpaceToTab
extends PyAction {
    private PySelection ps;

    public void run(IAction action) {
        try {
            if (!this.canModifyEditor()) {
                return;
            }
            ITextEditor textEditor = this.getTextEditor();
            this.ps = PySelectionFromEditor.createPySelectionFromEditor(textEditor);
            this.ps.selectAll(false);
            PyConvertSpaceToTab.perform(this.ps, textEditor);
            textEditor.selectAndReveal(this.ps.getLineOffset(), 0);
        }
        catch (Exception e) {
            PyConvertSpaceToTab.beep((Exception)e);
        }
    }

    public static boolean perform(PySelection ps, ITextEditor textEditor) {
        String tabSpace;
        FastStringBuffer strbuf;
        block4: {
            strbuf = new FastStringBuffer();
            ps.selectCompleteLine();
            tabSpace = PyConvertSpaceToTab.getTabSpace(textEditor);
            if (tabSpace != null) break block4;
            return false;
        }
        try {
            IDocument doc = ps.getDoc();
            int endLineIndex = ps.getEndLineIndex();
            String endLineDelim = ps.getEndLineDelim();
            int i = ps.getStartLineIndex();
            while (i <= endLineIndex) {
                IRegion lineInformation = doc.getLineInformation(i);
                String line = doc.get(lineInformation.getOffset(), lineInformation.getLength());
                strbuf.append(line.replaceAll(tabSpace, "\t")).append(i < endLineIndex ? endLineDelim : "");
                ++i;
            }
            doc.replace(ps.getStartLine().getOffset(), ps.getSelLength(), strbuf.toString());
            return true;
        }
        catch (Exception e) {
            PyConvertSpaceToTab.beep((Exception)e);
            return false;
        }
    }

    protected static String getTabSpace(ITextEditor textEditor) {
        class NumberValidator
        implements IInputValidator {
            NumberValidator() {
            }

            public String isValid(String input) {
                if (input == null || input.length() == 0) {
                    return " ";
                }
                try {
                    int i = Integer.parseInt(input);
                    if (i <= 0) {
                        return "Must be more than 0.";
                    }
                }
                catch (NumberFormatException x) {
                    return x.getMessage();
                }
                return null;
            }
        }
        InputDialog inputDialog = new InputDialog(EditorUtils.getShell(), "Tab length", "How many spaces should be considered for each tab?", "" + DefaultIndentPrefs.get((IAdaptable)textEditor).getTabWidth(), (IInputValidator)new NumberValidator());
        if (inputDialog.open() != 0) {
            return null;
        }
        int tabWidth = Integer.parseInt(inputDialog.getValue());
        return new FastStringBuffer(tabWidth).appendN(' ', tabWidth).toString();
    }
}

