/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import java.io.File;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.PySelectionFromEditor;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.parser.fastparser.FastParser;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_ui.EditorUtils;

public class PyCopyQualifiedName
extends PyAction {
    public void run(IAction action) {
        FastStringBuffer buf = new FastStringBuffer();
        try {
            PyEdit pyEdit = this.getPyEdit();
            PySelection pySelection = PySelectionFromEditor.createPySelectionFromEditor((ITextEditor)pyEdit);
            IPythonNature nature = pyEdit.getPythonNature();
            File editorFile = pyEdit.getEditorFile();
            if (editorFile != null) {
                if (nature != null) {
                    String mod = nature.resolveModule(editorFile);
                    if (mod != null) {
                        buf.append(mod);
                    } else {
                        buf.append(FullRepIterable.getFirstPart((String)editorFile.getName()));
                    }
                } else {
                    buf.append(FullRepIterable.getFirstPart((String)editorFile.getName()));
                }
            }
            List path = FastParser.parseToKnowGloballyAccessiblePath((IDocument)pySelection.getDoc(), (int)pySelection.getStartLineIndex());
            for (stmtType stmtType2 : path) {
                if (buf.length() > 0) {
                    buf.append('.');
                }
                buf.append(NodeUtils.getRepresentationString((ISimpleNode)stmtType2));
            }
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
            return;
        }
        Transfer[] dataTypes = new Transfer[]{TextTransfer.getInstance()};
        Object[] data = new Object[]{buf.toString()};
        Clipboard clipboard = new Clipboard(EditorUtils.getShell().getDisplay());
        try {
            try {
                clipboard.setContents(data, dataTypes);
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                MessageDialog.openError((Shell)EditorUtils.getShell(), (String)"Error copying to clipboard.", (String)e.getMessage());
                clipboard.dispose();
            }
        }
        finally {
            clipboard.dispose();
        }
    }
}

