/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codefolding.IPyCalltipsContextInformation;

public class PyContextInformationValidator
implements IContextInformationValidator,
IContextInformationPresenter {
    public IPyCalltipsContextInformation fInformation;
    public IDocument doc;
    public boolean returnedFalseOnce;
    private int fPosition;

    public void install(IContextInformation info, IDocument doc, int offset) {
        this.returnedFalseOnce = false;
        this.fInformation = (IPyCalltipsContextInformation)info;
        this.doc = doc;
        this.fPosition = this.fInformation.getShowCalltipsOffset();
    }

    public void install(IContextInformation info, ITextViewer viewer, int offset) {
        this.install(info, viewer.getDocument(), offset);
    }

    public boolean isContextInformationValid(int position) {
        IDocument document;
        block8: {
            block7: {
                if (this.doc == null) {
                    this.returnedFalseOnce = true;
                    return false;
                }
                if (position >= this.fPosition) break block7;
                this.returnedFalseOnce = true;
                return false;
            }
            document = this.doc;
            IRegion line = document.getLineInformationOfOffset(this.fPosition);
            if (position >= line.getOffset() && position < document.getLength()) break block8;
            this.returnedFalseOnce = true;
            return false;
        }
        try {
            boolean ret;
            boolean bl = ret = this.getCurrentParameter(document, this.fPosition, position, "(", ")", false) >= 0;
            if (!ret) {
                this.returnedFalseOnce = true;
            }
            return ret;
        }
        catch (BadLocationException x) {
            this.returnedFalseOnce = true;
            return false;
        }
        catch (Exception x) {
            this.returnedFalseOnce = true;
            Log.log((Throwable)x);
            return false;
        }
    }

    public boolean updatePresentation(int position, TextPresentation presentation) {
        return false;
    }

    public int getCurrentParameter(IDocument document, int start, int end, String increments, String decrements, boolean considerNesting) throws BadLocationException, SyntaxErrorException {
        Assert.isTrue(((increments.length() != 0 || decrements.length() != 0) && !increments.equals(decrements) ? 1 : 0) != 0);
        boolean NONE = false;
        boolean BRACKET = true;
        int BRACE = 2;
        int PAREN = 3;
        int ANGLE = 4;
        int nestingMode = 0;
        int nestingLevel = 0;
        int charCount = 0;
        int offset = start;
        ParsingUtils parsingUtils = ParsingUtils.create((Object)document);
        block10: while (offset < end) {
            char curr = document.getChar(offset++);
            switch (curr) {
                case '#': {
                    if (offset >= end) continue block10;
                    offset = end;
                    break;
                }
                case '\"': 
                case '\'': {
                    int eaten = parsingUtils.eatLiterals(null, offset - 1) + 1;
                    if (eaten <= offset) continue block10;
                    offset = eaten;
                    break;
                }
                case '[': {
                    if (considerNesting) {
                        if (nestingMode != 1 && nestingMode != 0) continue block10;
                        nestingMode = 1;
                        ++nestingLevel;
                        break;
                    }
                }
                case ']': {
                    if (considerNesting) {
                        if (nestingMode != true || --nestingLevel != 0) continue block10;
                        nestingMode = 0;
                        break;
                    }
                }
                case '(': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 3;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 3 && nestingMode != 0) continue block10;
                        nestingMode = 3;
                        ++nestingLevel;
                        break;
                    }
                }
                case ')': {
                    if (considerNesting) {
                        if (nestingMode != 3 || --nestingLevel != 0) continue block10;
                        nestingMode = 0;
                        break;
                    }
                }
                case '{': {
                    if (considerNesting) {
                        if (nestingMode == 4) {
                            nestingMode = 2;
                            nestingLevel = 1;
                        }
                        if (nestingMode != 2 && nestingMode != 0) continue block10;
                        nestingMode = 2;
                        ++nestingLevel;
                        break;
                    }
                }
                case '}': {
                    if (considerNesting) {
                        if (nestingMode != 2 || --nestingLevel != 0) continue block10;
                        nestingMode = 0;
                        break;
                    }
                }
                default: {
                    if (nestingLevel != 0) continue block10;
                    if (increments.indexOf(curr) >= 0) {
                        ++charCount;
                    }
                    if (decrements.indexOf(curr) < 0) continue block10;
                    --charCount;
                }
            }
        }
        return charCount;
    }
}

