/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.proposals;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.custom.StyledText;
import org.python.pydev.editor.codecompletion.proposals.PyCompletionProposal;
import org.python.pydev.shared_core.code_completion.IPyCompletionProposal;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.log.Log;
import org.python.pydev.shared_ui.proposals.PyCompletionPresentationUpdater;

public abstract class AbstractCompletionProposalExtension
extends PyCompletionProposal
implements ICompletionProposalExtension2,
ICompletionProposalExtension {
    private PyCompletionPresentationUpdater presentationUpdater;
    public int fLen;
    public boolean fLastIsPar;

    public AbstractCompletionProposalExtension(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, int priority, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, null, null, null, null, priority, compareContext);
    }

    public AbstractCompletionProposalExtension(String replacementString, int replacementOffset, int replacementLength, int cursorPosition, IImageHandle image, String displayString, IContextInformation contextInformation, String additionalProposalInfo, int priority, int onApplyAction, String args, IPyCompletionProposal.ICompareContext compareContext) {
        super(replacementString, replacementOffset, replacementLength, cursorPosition, image, displayString, contextInformation, additionalProposalInfo, priority, onApplyAction, args, compareContext);
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
        if (smartToggle) {
            StyledText text = viewer.getTextWidget();
            if (text == null || text.isDisposed()) {
                return;
            }
            int widgetCaret = text.getCaretOffset();
            IDocument document = viewer.getDocument();
            int finalOffset = widgetCaret;
            try {
                char c;
                if (finalOffset >= document.getLength()) {
                    this.unselected(viewer);
                    return;
                }
                while (this.isValidChar(c = document.getChar(finalOffset)) && ++finalOffset < document.getLength()) {
                }
                this.fLastIsPar = c == '(';
                if (!this.isValidChar(c)) {
                    --finalOffset;
                }
                this.fLen = finalOffset - widgetCaret;
                this.getPresentationUpdater().selected(viewer, widgetCaret, this.fLen);
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
        } else {
            this.unselected(viewer);
        }
    }

    private boolean isValidChar(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    public void unselected(ITextViewer viewer) {
        this.getPresentationUpdater().unselected(viewer);
    }

    public abstract boolean validate(IDocument var1, int var2, DocumentEvent var3);

    public void apply(IDocument document, char trigger, int offset) {
        throw new RuntimeException("Not implemented");
    }

    public int getContextInformationPosition() {
        return this.fCursorPosition;
    }

    public boolean isValidFor(IDocument document, int offset) {
        return this.validate(document, offset, null);
    }

    protected boolean getApplyCompletionOnDot() {
        return false;
    }

    protected boolean triggerCharAppliesCurrentCompletion(char trigger, IDocument doc, int offset) {
        if (trigger == '.' && !this.getApplyCompletionOnDot()) {
            try {
                doc.replace(offset, 0, ".");
            }
            catch (BadLocationException e) {
                Log.log((Throwable)e);
            }
            return false;
        }
        return true;
    }

    protected PyCompletionPresentationUpdater getPresentationUpdater() {
        if (this.presentationUpdater == null) {
            this.presentationUpdater = new PyCompletionPresentationUpdater();
        }
        return this.presentationUpdater;
    }
}

