/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.proposals;

import com.python.pydev.analysis.refactoring.quick_fixes.AddTokenAndImportStatement;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.python.pydev.ast.refactoring.AbstractPyRefactoring;
import org.python.pydev.ast.refactoring.IPyRefactoring2;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codefolding.PySourceViewer;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.TextSelectionUtils;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.ImageCache;

public class PyMoveImportsToLocalCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension2,
ICompletionProposalHandle {
    private String displayString;
    private IImageHandle iImageHandle;
    private RefactoringRequest refactoringRequest;
    private String fReplacementString;
    private boolean appliedWithTrigger;
    private int importLen;
    private ImportHandle.ImportHandleInfo importHandleInfo;
    private String importedToken;
    private boolean forceReparseOnApply = true;

    public PyMoveImportsToLocalCompletionProposal(RefactoringRequest refactoringRequest, String importedToken, ImportHandle.ImportHandleInfo importHandleInfo, IImageHandle iImageHandle, String displayString) {
        this.importedToken = importedToken;
        this.displayString = displayString;
        this.importHandleInfo = importHandleInfo;
        this.iImageHandle = iImageHandle;
        this.refactoringRequest = refactoringRequest;
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.displayString;
    }

    public void apply(IDocument doc) {
        RefactoringRequest req = this.refactoringRequest;
        IPyRefactoring2 r = (IPyRefactoring2)AbstractPyRefactoring.getPyRefactoring();
        if (req.qualifier != null && req.qualifier.trim().length() > 0) {
            try {
                Map occurrences = r.findAllOccurrences(req);
                Set entrySet = occurrences.entrySet();
                MultiTextEdit multiTextEdit = new MultiTextEdit();
                IDocument document = req.getDoc();
                HashSet<Integer> appliedContextLines = new HashSet<Integer>();
                for (Map.Entry o : entrySet) {
                    HashSet entries = (HashSet)o.getValue();
                    ASTEntry[] ordered = entries.toArray(new ASTEntry[0]);
                    Arrays.sort(ordered, (entry0, entry1) -> Integer.compare(entry1.node.beginLine, entry0.node.beginLine));
                    for (ASTEntry entry : entries) {
                        String currLine;
                        int beginLine;
                        int useLine;
                        if (entry.node == null || (useLine = (beginLine = entry.node.beginLine) - 1) >= this.importHandleInfo.getStartLine() && useLine <= this.importHandleInfo.getEndLine() || !(currLine = TextSelectionUtils.getLine((IDocument)document, (int)useLine)).isEmpty() && !Character.isWhitespace(currLine.charAt(0))) continue;
                        int i = useLine;
                        while (i < document.getNumberOfLines()) {
                            String line = TextSelectionUtils.getLine((IDocument)document, (int)i);
                            if (!line.trim().isEmpty() && Character.isWhitespace(line.charAt(0))) {
                                useLine = i;
                                break;
                            }
                            ++i;
                        }
                        boolean addLocalImport = true;
                        boolean addLocalImportsOnTopOfMethod = true;
                        boolean groupImports = false;
                        int offset = new PySelection(req.ps.getDoc(), useLine, 0).getAbsoluteCursorOffset();
                        int maxCols = 200;
                        char trigger = ' ';
                        String fromImportStr = this.importHandleInfo.getFromImportStr();
                        String realImportRep = fromImportStr == null || fromImportStr.isEmpty() ? "import " + this.importedToken : "from " + fromImportStr + " import " + this.importedToken;
                        int fReplacementOffset = offset;
                        int fLen = 0;
                        String indentString = "               ";
                        this.fReplacementString = "";
                        AddTokenAndImportStatement.ComputedInfo computedInfo = new AddTokenAndImportStatement.ComputedInfo(realImportRep, fReplacementOffset, fLen, indentString, this.fReplacementString, this.appliedWithTrigger, this.importLen, document);
                        this.appliedWithTrigger = computedInfo.appliedWithTrigger;
                        this.importLen = computedInfo.importLen;
                        AddTokenAndImportStatement t = new AddTokenAndImportStatement(document, trigger, offset, addLocalImport, addLocalImportsOnTopOfMethod, groupImports, maxCols);
                        PySelection.LineStartingScope previousLineThatStartsScope = t.getPreviousLineThatStartsScope();
                        if (previousLineThatStartsScope == null || appliedContextLines.contains(previousLineThatStartsScope.iLineStartingScope)) continue;
                        appliedContextLines.add(previousLineThatStartsScope.iLineStartingScope);
                        t.createTextEdit(computedInfo);
                        for (ReplaceEdit edit : computedInfo.replaceEdit) {
                            multiTextEdit.addChild((TextEdit)edit);
                        }
                    }
                }
                try {
                    multiTextEdit.apply(document);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
            }
            catch (CoreException | OperationCanceledException e) {
                Log.log((Throwable)e);
            }
        }
    }

    public Point getSelection(IDocument document) {
        return new Point(this.refactoringRequest.ps.getAbsoluteCursorOffset(), 0);
    }

    public Image getImage() {
        return ImageCache.asImage((IImageHandle)this.iImageHandle);
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        PySourceViewer sourceViewer;
        PyEdit edit;
        IDocument doc = viewer.getDocument();
        this.apply(doc);
        if (this.forceReparseOnApply && viewer instanceof PySourceViewer && (edit = (sourceViewer = (PySourceViewer)viewer).getEdit()) != null) {
            edit.getParser().forceReparse(new Object[]{new Tuple((Object)"AnalysisParserObserver:force", (Object)true)});
        }
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }
}

