/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.python.pydev.ast.refactoring.RefactoringRequest;
import org.python.pydev.core.IAssistProps;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.PyImportsIterator;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.structure.Tuple;

public class AssistImportToLocal
implements IAssistProps {
    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, File f, IPythonNature nature, IPyEdit edit, int offset) throws BadLocationException, MisconfigurationException {
        boolean addOnlyGlobalImports = true;
        boolean allowBadInput = false;
        Tuple currToken = ps.getCurrToken();
        ArrayList<ICompletionProposalHandle> ret = new ArrayList<ICompletionProposalHandle>();
        if (currToken.o1 != null && ((String)currToken.o1).length() > 0) {
            int startOfImportLine = ps.getStartOfImportLine();
            if (startOfImportLine == -1) {
                return ret;
            }
            int startOffset = ps.getLineOffset(startOfImportLine);
            PyImportsIterator pyImportsIterator = new PyImportsIterator(ps.getDoc(), addOnlyGlobalImports, allowBadInput, startOffset);
            block0: while (pyImportsIterator.hasNext()) {
                ImportHandle handle = pyImportsIterator.next();
                List importInfo = handle.getImportInfo();
                for (ImportHandle.ImportHandleInfo importHandleInfo : importInfo) {
                    List importedStr = importHandleInfo.getImportedStr();
                    int startLine = importHandleInfo.getStartLine();
                    int endLine = importHandleInfo.getEndLine();
                    if (ps.getLineOfOffset() < startLine) continue;
                    if (ps.getLineOfOffset() > endLine) break block0;
                    for (String s : importedStr) {
                        if (!s.equals(currToken.o1)) continue;
                        NullProgressMonitor monitor = new NullProgressMonitor();
                        RefactoringRequest req = PyRefactorAction.createRefactoringRequest((IProgressMonitor)monitor, (PyEdit)edit, ps);
                        req.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)false);
                        req.setAdditionalInfo("findReferencesOnlyOnLocalScope", (Object)true);
                        req.fillActivationTokenAndQualifier();
                        ret.add(CompletionProposalFactory.get().createMoveImportsToLocalCompletionProposal((Object)req, s, importHandleInfo, imageCache.get("icons/correction_move.gif"), "Move import to local scope(s)"));
                    }
                }
            }
        }
        return ret;
    }

    public boolean isValid(PySelection ps, String sel, IPyEdit edit, int offset) {
        return true;
    }
}

