/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.heuristics;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.python.pydev.ast.codecompletion.AbstractTemplateCodeCompletion;
import org.python.pydev.ast.codecompletion.CompletionRequest;
import org.python.pydev.core.IAssistProps;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.TokensOrProposalsList;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.editor.correctionassist.heuristics.PercentToBraceConverter;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;

public class AssistPercentToFormat
extends AbstractTemplateCodeCompletion
implements IAssistProps {
    private static final boolean DEBUG = false;

    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, File f, IPythonNature nature, IPyEdit edit, int offset) throws BadLocationException {
        ArrayList<ICompletionProposalHandle> l = new ArrayList<ICompletionProposalHandle>();
        String curSelection = ps.getSelectedText();
        if (curSelection == null) {
            return l;
        }
        curSelection = new String(curSelection);
        boolean endsWithLineDelim = false;
        int unchangedLength = curSelection.length();
        if (curSelection.substring(unchangedLength - 1, unchangedLength).matches("\\r|\\n") || curSelection.substring(unchangedLength - 2, unchangedLength).matches("\\r\\n")) {
            endsWithLineDelim = true;
        }
        PercentToBraceConverter ptbc = new PercentToBraceConverter(curSelection);
        Object replacementString = ptbc.convert();
        if (endsWithLineDelim) {
            replacementString = (String)replacementString + ps.getEndLineDelim();
        }
        int lenConverted = ptbc.getLength();
        int replacementOffset = offset;
        int replacementLength = unchangedLength;
        int cursorPos = replacementOffset + lenConverted;
        IRegion region = ps.getRegion();
        TemplateContext context = this.createContext(region, ps.getDoc());
        Template t = new Template("Convert", "% to .format()", "", (String)replacementString, false);
        l.add(CompletionProposalFactory.get().createPyTemplateProposal(t, context, region, imageCache.get("icons/template.gif"), 5));
        return l;
    }

    public boolean isValid(PySelection ps, String sel, IPyEdit edit, int offset) {
        try {
            return PercentToBraceConverter.isValidPercentFormatString(ps.getSelectedText(), true);
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public TokensOrProposalsList getCodeCompletionProposals(CompletionRequest request) throws CoreException, BadLocationException {
        throw new RuntimeException("Not implemented: completions should be gotten from the IAssistProps interface.");
    }
}

