/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.util.List;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.navigator.LabelAndImage;
import org.python.pydev.navigator.ZipStructure;
import org.python.pydev.navigator.elements.ISortedElement;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.structure.TreeNode;
import org.python.pydev.shared_ui.SharedUiPlugin;

public class PythonpathZipChildTreeNode
extends TreeNode<LabelAndImage>
implements ISortedElement {
    private boolean calculated = false;
    public final boolean isDir;
    public final ZipStructure zipStructure;
    public final String zipPath;
    private boolean isPackage;
    private List<String> dirContents;

    public PythonpathZipChildTreeNode(TreeNode<LabelAndImage> parent, ZipStructure zipStructure, String zipPath, IImageHandle icon, boolean isPythonpathRoot) {
        super(parent, null);
        try {
            this.zipStructure = zipStructure;
            this.zipPath = zipPath;
            this.isDir = StringUtils.endsWith((String)zipPath, (char)'/');
            if (this.isDir) {
                this.dirContents = zipStructure.contents(zipPath);
                if (isPythonpathRoot) {
                    this.isPackage = true;
                } else if (parent instanceof PythonpathZipChildTreeNode && ((PythonpathZipChildTreeNode)parent).isPackage) {
                    this.isPackage = true;
                }
            }
            if (icon == null) {
                IImageCache imageCache = SharedUiPlugin.getImageCache();
                icon = this.isDir ? (this.isPackage ? imageCache.get("icons/package_obj.gif") : imageCache.get("icons/folder.gif")) : (PythonPathHelper.isValidSourceFile((String)zipPath) ? imageCache.get("icons/python_file.gif") : imageCache.get("icons/file.gif"));
            }
        }
        finally {
            this.setData(new LabelAndImage(PythonpathZipChildTreeNode.getLabel(zipPath), icon));
        }
    }

    private static String getLabel(String zipPath) {
        int lastIndexOf;
        if (StringUtils.endsWith((String)zipPath, (char)'/')) {
            zipPath = zipPath.substring(0, zipPath.length() - 1);
        }
        if ((lastIndexOf = zipPath.lastIndexOf(47)) == -1) {
            return zipPath;
        }
        return zipPath.substring(lastIndexOf + 1);
    }

    public boolean hasChildren() {
        return this.isDir && this.dirContents != null && this.dirContents.size() > 0;
    }

    @Override
    public int getRank() {
        return this.isDir ? ISortedElement.RANK_PYTHON_FOLDER : ISortedElement.RANK_PYTHON_FILE;
    }

    public synchronized List<TreeNode> getChildren() {
        if (!this.calculated) {
            this.calculated = true;
            if (this.isDir && this.dirContents != null) {
                for (String childPath : this.dirContents) {
                    new PythonpathZipChildTreeNode(this, this.zipStructure, childPath, null, false);
                }
            }
        }
        return super.getChildren();
    }
}

