/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.string.StringUtils;

public class ZipStructure {
    private Map<Integer, TreeSet<String>> levelToContents = new HashMap<Integer, TreeSet<String>>();
    public final File file;

    ZipStructure() {
        this.file = null;
    }

    public ZipStructure(File file, ZipFile zipFile) {
        this.file = file;
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            Object name;
            try {
                ZipEntry element = entries.nextElement();
                name = element.getName();
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                continue;
            }
            List split = StringUtils.split((String)name, (char)'/');
            int size = split.size();
            int level = size - 1;
            TreeSet<String> treeSet = this.levelToContents.get(level);
            if (treeSet == null) {
                treeSet = new TreeSet();
                this.levelToContents.put(level, treeSet);
            }
            treeSet.add((String)name);
            if (size == 1) continue;
            String[] array = split.toArray(new String[size]);
            int i = 0;
            while (i < size - 1) {
                name = StringUtils.join((String)"/", (String[])array, (int)0, (int)(i + 1)) + "/";
                level = i;
                treeSet = this.levelToContents.get(level);
                if (treeSet == null) {
                    treeSet = new TreeSet();
                    this.levelToContents.put(level, treeSet);
                }
                treeSet.add((String)name);
                ++i;
            }
        }
    }

    Map<Integer, TreeSet<String>> getLevelToContents() {
        return this.levelToContents;
    }

    public List<String> contents(String name) {
        int level;
        ArrayList<String> ret = new ArrayList<String>();
        int length = name.length();
        if (length == 0) {
            level = 0;
        } else {
            Assert.isTrue((boolean)StringUtils.endsWith((String)name, (char)'/'));
            level = StringUtils.count((String)name, (char)'/');
        }
        TreeSet<String> treeSet = this.levelToContents.get(level);
        if (treeSet != null) {
            if (length == 0) {
                ret.addAll(treeSet);
            } else {
                for (String s : treeSet.tailSet(name)) {
                    if (!s.startsWith(name)) continue;
                    ret.add(s);
                }
            }
        }
        return ret;
    }
}

