/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator.actions;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.navigator.InterpreterInfoTreeNodeRoot;
import org.python.pydev.navigator.PythonpathTreeNode;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.shared_core.structure.TreeNode;

public class PythonLinkHelper
implements ILinkHelper {
    private WeakReference<CommonViewer> commonViewer;

    public void setCommonViewer(CommonViewer commonViewer) {
        this.commonViewer = new WeakReference<CommonViewer>(commonViewer);
    }

    public IStructuredSelection findSelection(IEditorInput anInput) {
        Object adapter;
        if (anInput instanceof IFileEditorInput) {
            return new StructuredSelection((Object)((IFileEditorInput)anInput).getFile());
        }
        if (anInput instanceof IAdaptable && (adapter = anInput.getAdapter(IFile.class)) != null) {
            return new StructuredSelection(adapter);
        }
        return StructuredSelection.EMPTY;
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        Object firstElement = aSelection.getFirstElement();
        if (firstElement instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)firstElement;
            firstElement = resource.getActualObject();
        }
        if (firstElement instanceof IFile) {
            IEditorInput editorInput;
            IFile currFile;
            IEditorPart activeEditor = aPage.getActiveEditor();
            if (activeEditor != null && (currFile = (IFile)(editorInput = activeEditor.getEditorInput()).getAdapter(IFile.class)) != null && currFile.equals(firstElement)) {
                return;
            }
            IEditorPart editor = null;
            FileEditorInput fileInput = new FileEditorInput((IFile)firstElement);
            editor = aPage.findEditor((IEditorInput)fileInput);
            if (editor != null) {
                aPage.bringToTop((IWorkbenchPart)editor);
            }
        }
    }

    public IStructuredSelection findExternalFileSelection(File f) {
        Object[] expandedElements;
        if (this.commonViewer == null) {
            return null;
        }
        CommonViewer commonViewer = (CommonViewer)this.commonViewer.get();
        if (commonViewer == null) {
            return null;
        }
        ISelection treeSelection = commonViewer.getSelection();
        HashSet<IInterpreterInfo> infosSearched = new HashSet<IInterpreterInfo>();
        IContentProvider contentProvider = commonViewer.getContentProvider();
        if (!(contentProvider instanceof ITreeContentProvider)) {
            Log.log((String)("On tryToRevealExternalFile, the common viewer content provider is not an ITreeContentProvider. Found: " + String.valueOf(contentProvider)));
            return null;
        }
        ITreeContentProvider treeContentProvider = (ITreeContentProvider)contentProvider;
        if (treeSelection instanceof IStructuredSelection && !treeSelection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)treeSelection;
            for (Object next : structuredSelection) {
                IStructuredSelection sel = this.findExternalFileSelectionGivenTreeSelection(f, commonViewer, treeContentProvider, infosSearched, next);
                if (sel == null || sel.isEmpty()) continue;
                return sel;
            }
        }
        Object[] objectArray = expandedElements = commonViewer.getVisibleExpandedElements();
        int sel = expandedElements.length;
        int next = 0;
        while (next < sel) {
            Object expandedElement = objectArray[next];
            IStructuredSelection sel2 = this.findExternalFileSelectionGivenTreeSelection(f, commonViewer, treeContentProvider, infosSearched, expandedElement);
            if (sel2 != null && !sel2.isEmpty()) {
                return sel2;
            }
            ++next;
        }
        Set<IFile> openFiles = PyAction.getOpenFiles();
        for (IFile iFile : openFiles) {
            IStructuredSelection sel3 = this.findExternalFileSelectionGivenTreeSelection(f, commonViewer, treeContentProvider, infosSearched, iFile);
            if (sel3 == null || sel3.isEmpty()) continue;
            return sel3;
        }
        Object input = commonViewer.getInput();
        Object[] objectArray2 = treeContentProvider.getChildren(input);
        int n = objectArray2.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray2[n2];
            IStructuredSelection sel4 = this.findExternalFileSelectionGivenTreeSelection(f, commonViewer, treeContentProvider, infosSearched, child);
            if (sel4 != null && !sel4.isEmpty()) {
                return sel4;
            }
            ++n2;
        }
        return null;
    }

    private IStructuredSelection findExternalFileSelectionGivenTreeSelection(File f, CommonViewer commonViewer, ITreeContentProvider treeContentProvider, Set<IInterpreterInfo> infosSearched, Object next) {
        IProject project;
        IAdaptable adaptable;
        IResource resource;
        if (next instanceof IAdaptable && (resource = (IResource)(adaptable = (IAdaptable)next).getAdapter(IResource.class)) != null && (project = resource.getProject()) != null) {
            Object[] children;
            Object[] objectArray = children = treeContentProvider.getChildren((Object)project);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStructuredSelection sel;
                Object object = objectArray[n2];
                if (object instanceof InterpreterInfoTreeNodeRoot && (sel = this.findMatchInTreeNodeRoot(f, commonViewer, (InterpreterInfoTreeNodeRoot)object, infosSearched)) != null) {
                    return sel;
                }
                ++n2;
            }
            return null;
        }
        if (next instanceof TreeNode) {
            TreeNode treeNode = (TreeNode)next;
            while (true) {
                Object parent;
                if (treeNode instanceof InterpreterInfoTreeNodeRoot) {
                    IStructuredSelection sel = this.findMatchInTreeNodeRoot(f, commonViewer, (InterpreterInfoTreeNodeRoot)treeNode, infosSearched);
                    if (sel != null) {
                        return sel;
                    }
                    return null;
                }
                if (treeNode instanceof PythonpathTreeNode) {
                    PythonpathTreeNode pythonpathTreeNode = (PythonpathTreeNode)treeNode;
                    if (f.equals(pythonpathTreeNode.file)) {
                        return new StructuredSelection((Object)treeNode);
                    }
                }
                if (!((parent = treeNode.getParent()) instanceof TreeNode)) break;
                treeNode = (TreeNode)parent;
            }
            Log.log((String)("Couldn't find a proper InterpreterInfoTreeNodeRoot already having TreeNode: " + String.valueOf(next)));
            return null;
        }
        Object parent = next;
        int i = 200;
        while (i > 0) {
            IProject project2;
            IAdaptable adaptable2;
            IResource resource2;
            if (--i == 0) {
                Log.log((String)("Found a recursion for the element: " + String.valueOf(next) + " when searching parents. Please report this a a bug!"));
            }
            if (parent == null || parent instanceof IWorkspaceRoot || parent instanceof IWorkingSet) break;
            if (parent instanceof TreeNode && parent != next) {
                return this.findExternalFileSelectionGivenTreeSelection(f, commonViewer, treeContentProvider, infosSearched, parent);
            }
            if (parent instanceof IAdaptable && (resource2 = (IResource)(adaptable2 = (IAdaptable)parent).getAdapter(IResource.class)) != null && (project2 = resource2.getProject()) != null && project2 != next) {
                return this.findExternalFileSelectionGivenTreeSelection(f, commonViewer, treeContentProvider, infosSearched, project2);
            }
            parent = treeContentProvider.getParent(parent);
        }
        return null;
    }

    private IStructuredSelection findMatchInTreeNodeRoot(File element, CommonViewer commonViewer, InterpreterInfoTreeNodeRoot treeNodeRoot, Set<IInterpreterInfo> infosSearched) {
        if (infosSearched.contains(treeNodeRoot.interpreterInfo)) {
            return null;
        }
        infosSearched.add(treeNodeRoot.interpreterInfo);
        List<TreeNode> nodesOrderedForFileSearch = treeNodeRoot.getNodesOrderedForFileSearch();
        for (TreeNode node : nodesOrderedForFileSearch) {
            PythonpathTreeNode match = this.findMatch(node, element);
            if (match == null) continue;
            return new StructuredSelection((Object)match);
        }
        return null;
    }

    private PythonpathTreeNode findMatch(TreeNode treeNode, Object element) {
        if (treeNode instanceof PythonpathTreeNode) {
            PythonpathTreeNode pythonpathTreeNode = (PythonpathTreeNode)treeNode;
            if (element.equals(pythonpathTreeNode.file)) {
                return pythonpathTreeNode;
            }
        }
        List children = treeNode.getChildren();
        for (TreeNode object : children) {
            PythonpathTreeNode m = this.findMatch(object, element);
            if (m == null) continue;
            return m;
        }
        return null;
    }
}

