/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.model.ISimpleNode;
import org.python.pydev.shared_ui.outline.AbstractOutlineFilterAction;
import org.python.pydev.shared_ui.outline.BaseOutlinePage;

public class OutlineHideNonPublicMembersAction
extends AbstractOutlineFilterAction {
    private static final String PREF_HIDE_NONPUBLICMEMBERS = "org.python.pydev.OUTLINE_HIDE_NONPUBLICMEMBERS";

    public OutlineHideNonPublicMembersAction(PyOutlinePage page, IImageCache imageCache) {
        super("Hide Non-Public Members", (BaseOutlinePage)page, imageCache, PREF_HIDE_NONPUBLICMEMBERS, "icons/new/attrpub_obj.gif");
    }

    protected ViewerFilter createFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ParsedItem) {
                    ParsedItem item = (ParsedItem)((Object)element);
                    if (item == null) {
                        return true;
                    }
                    ASTEntryWithChildren astThis = item.getAstThis();
                    if (astThis == null) {
                        return true;
                    }
                    SimpleNode token = astThis.node;
                    if (token == null) {
                        return true;
                    }
                    String name = NodeUtils.getRepresentationString((ISimpleNode)token);
                    if (name != null) {
                        return !name.startsWith("_") || name.startsWith("__") && name.endsWith("__");
                    }
                }
                return true;
            }
        };
    }
}

