/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.StatusInfo;
import org.python.pydev.plugin.preferences.ColorEditor;
import org.python.pydev.plugin.preferences.OverlayPreferenceStore;

public abstract class AbstractPydevPrefs
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected final String[][] fAppearanceColorListModel;
    protected final String[][] fAppearanceFontListModel;
    protected OverlayPreferenceStore fOverlayStore;
    protected Map<Button, String> fCheckBoxes;
    protected SelectionListener fCheckBoxListener;
    protected Map<Text, String> fTextFields;
    protected ModifyListener fTextFieldListener;
    protected List<Text> fNumberFields;
    protected ModifyListener fNumberFieldListener;
    protected org.eclipse.swt.widgets.List fAppearanceColorList;
    protected ColorEditor fAppearanceColorEditor;
    protected Button fAppearanceColorDefault;
    protected Button fFontBoldCheckBox;
    protected Button fFontItalicCheckBox;
    protected SelectionListener fStyleCheckBoxListener;
    protected boolean fFieldsInitialized;
    protected List<SelectionListener> fMasterSlaveListeners;

    public AbstractPydevPrefs() {
        String[][] stringArrayArray = new String[15][];
        String[] stringArray = new String[3];
        stringArray[0] = "Code";
        stringArray[1] = "CODE_COLOR";
        stringArrayArray[0] = stringArray;
        String[] stringArray2 = new String[3];
        stringArray2[0] = "Decorators";
        stringArray2[1] = "DECORATOR_COLOR";
        stringArrayArray[1] = stringArray2;
        String[] stringArray3 = new String[3];
        stringArray3[0] = "Numbers";
        stringArray3[1] = "NUMBER_COLOR";
        stringArrayArray[2] = stringArray3;
        String[] stringArray4 = new String[3];
        stringArray4[0] = "Matching brackets";
        stringArray4[1] = "EDITOR_MATCHING_BRACKETS_COLOR";
        stringArrayArray[3] = stringArray4;
        String[] stringArray5 = new String[3];
        stringArray5[0] = "Keywords";
        stringArray5[1] = "KEYWORD_COLOR";
        stringArrayArray[4] = stringArray5;
        String[] stringArray6 = new String[3];
        stringArray6[0] = "self";
        stringArray6[1] = "SELF_COLOR";
        stringArrayArray[5] = stringArray6;
        String[] stringArray7 = new String[3];
        stringArray7[0] = "Bytes";
        stringArray7[1] = "STRING_COLOR";
        stringArrayArray[6] = stringArray7;
        String[] stringArray8 = new String[3];
        stringArray8[0] = "Unicode";
        stringArray8[1] = "UNICODE_COLOR";
        stringArrayArray[7] = stringArray8;
        String[] stringArray9 = new String[3];
        stringArray9[0] = "Docstring markup";
        stringArray9[1] = "DOCSTRING_MARKUP_COLOR";
        stringArrayArray[8] = stringArray9;
        String[] stringArray10 = new String[3];
        stringArray10[0] = "Comments";
        stringArray10[1] = "COMMENT_COLOR";
        stringArrayArray[9] = stringArray10;
        String[] stringArray11 = new String[3];
        stringArray11[0] = "Backquotes";
        stringArray11[1] = "BACKQUOTES_COLOR";
        stringArrayArray[10] = stringArray11;
        String[] stringArray12 = new String[3];
        stringArray12[0] = "Class Name";
        stringArray12[1] = "CLASS_NAME_COLOR";
        stringArrayArray[11] = stringArray12;
        String[] stringArray13 = new String[3];
        stringArray13[0] = "Function Name";
        stringArray13[1] = "FUNC_NAME_COLOR";
        stringArrayArray[12] = stringArray13;
        String[] stringArray14 = new String[3];
        stringArray14[0] = "(), [], {}";
        stringArray14[1] = "PARENS_COLOR";
        stringArrayArray[13] = stringArray14;
        String[] stringArray15 = new String[3];
        stringArray15[0] = "Operators (+,-,*,...)";
        stringArray15[1] = "OPERATORS_COLOR";
        stringArrayArray[14] = stringArray15;
        this.fAppearanceColorListModel = stringArrayArray;
        String[][] stringArrayArray2 = new String[15][];
        String[] stringArray16 = new String[3];
        stringArray16[0] = "Code";
        stringArray16[1] = "CODE_STYLE";
        stringArrayArray2[0] = stringArray16;
        String[] stringArray17 = new String[3];
        stringArray17[0] = "Decorators";
        stringArray17[1] = "DECORATOR_STYLE";
        stringArrayArray2[1] = stringArray17;
        String[] stringArray18 = new String[3];
        stringArray18[0] = "Numbers";
        stringArray18[1] = "NUMBER_STYLE";
        stringArrayArray2[2] = stringArray18;
        String[] stringArray19 = new String[3];
        stringArray19[0] = "Matching brackets";
        stringArray19[1] = "EDITOR_MATCHING_BRACKETS_STYLE";
        stringArrayArray2[3] = stringArray19;
        String[] stringArray20 = new String[3];
        stringArray20[0] = "Keywords";
        stringArray20[1] = "KEYWORD_STYLE";
        stringArrayArray2[4] = stringArray20;
        String[] stringArray21 = new String[3];
        stringArray21[0] = "self";
        stringArray21[1] = "SELF_STYLE";
        stringArrayArray2[5] = stringArray21;
        String[] stringArray22 = new String[3];
        stringArray22[0] = "Bytes";
        stringArray22[1] = "STRING_STYLE";
        stringArrayArray2[6] = stringArray22;
        String[] stringArray23 = new String[3];
        stringArray23[0] = "Unicode";
        stringArray23[1] = "UNICODE_STYLE";
        stringArrayArray2[7] = stringArray23;
        String[] stringArray24 = new String[3];
        stringArray24[0] = "Docstring markup";
        stringArray24[1] = "DOCSTRING_MARKUP_STYLE";
        stringArrayArray2[8] = stringArray24;
        String[] stringArray25 = new String[3];
        stringArray25[0] = "Comments";
        stringArray25[1] = "COMMENT_STYLE";
        stringArrayArray2[9] = stringArray25;
        String[] stringArray26 = new String[3];
        stringArray26[0] = "Backquotes";
        stringArray26[1] = "BACKQUOTES_STYLE";
        stringArrayArray2[10] = stringArray26;
        String[] stringArray27 = new String[3];
        stringArray27[0] = "Class Name";
        stringArray27[1] = "CLASS_NAME_STYLE";
        stringArrayArray2[11] = stringArray27;
        String[] stringArray28 = new String[3];
        stringArray28[0] = "Function Name";
        stringArray28[1] = "FUNC_NAME_STYLE";
        stringArrayArray2[12] = stringArray28;
        String[] stringArray29 = new String[3];
        stringArray29[0] = "(), [], {}";
        stringArray29[1] = "PARENS_STYLE";
        stringArrayArray2[13] = stringArray29;
        String[] stringArray30 = new String[3];
        stringArray30[0] = "Operators (+,-,*,...)";
        stringArray30[1] = "OPERATORS_STYLE";
        stringArrayArray2[14] = stringArray30;
        this.fAppearanceFontListModel = stringArrayArray2;
        this.fCheckBoxes = new HashMap<Button, String>();
        this.fCheckBoxListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                AbstractPydevPrefs.this.fOverlayStore.setValue(AbstractPydevPrefs.this.fCheckBoxes.get(button), button.getSelection());
            }
        };
        this.fTextFields = new HashMap<Text, String>();
        this.fTextFieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                AbstractPydevPrefs.this.fOverlayStore.setValue(AbstractPydevPrefs.this.fTextFields.get(text), text.getText());
            }
        };
        this.fNumberFields = new ArrayList<Text>();
        this.fNumberFieldListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPydevPrefs.this.numberFieldChanged((Text)e.widget);
            }
        };
        this.fStyleCheckBoxListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int i = AbstractPydevPrefs.this.fAppearanceColorList.getSelectionIndex();
                int style = 0;
                String styleKey = AbstractPydevPrefs.this.fAppearanceFontListModel[i][1];
                if (AbstractPydevPrefs.this.fFontBoldCheckBox.getSelection()) {
                    style |= 1;
                }
                if (AbstractPydevPrefs.this.fFontItalicCheckBox.getSelection()) {
                    style |= 2;
                }
                AbstractPydevPrefs.this.fOverlayStore.setValue(styleKey, style);
                AbstractPydevPrefs.this.onAppearanceRelatedPreferenceChanged();
            }
        };
        this.fFieldsInitialized = false;
        this.fMasterSlaveListeners = new ArrayList<SelectionListener>();
    }

    protected OverlayPreferenceStore createOverlayStore() {
        ArrayList<OverlayPreferenceStore.OverlayKey> overlayKeys = new ArrayList<OverlayPreferenceStore.OverlayKey>();
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "WORD_NAVIGATION_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.BOOLEAN, "USE_MATCHING_BRACKETS"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "EDITOR_MATCHING_BRACKETS_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "CODE_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "NUMBER_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "DECORATOR_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "KEYWORD_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "SELF_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "STRING_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "UNICODE_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "COMMENT_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "BACKQUOTES_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "CLASS_NAME_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "FUNC_NAME_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "PARENS_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "OPERATORS_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.STRING, "DOCSTRING_MARKUP_COLOR"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "CODE_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "NUMBER_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "DECORATOR_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "KEYWORD_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "SELF_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "STRING_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "UNICODE_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "COMMENT_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "BACKQUOTES_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "CLASS_NAME_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "FUNC_NAME_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "PARENS_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "OPERATORS_STYLE"));
        overlayKeys.add(new OverlayPreferenceStore.OverlayKey(OverlayPreferenceStore.INT, "DOCSTRING_MARKUP_STYLE"));
        OverlayPreferenceStore.OverlayKey[] keys = new OverlayPreferenceStore.OverlayKey[overlayKeys.size()];
        overlayKeys.toArray(keys);
        return new OverlayPreferenceStore(this.getPreferenceStore(), keys);
    }

    protected void onAppearanceRelatedPreferenceChanged() {
    }

    public void init(IWorkbench workbench) {
    }

    protected Button addStyleCheckBox(Composite parent, String text) {
        Button result = new Button(parent, 32);
        result.setText(text);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        result.setLayoutData((Object)gd);
        result.addSelectionListener(this.fStyleCheckBoxListener);
        return result;
    }

    protected Control createContents(Composite parent) {
        this.initializeDefaultColors();
        this.fOverlayStore.load();
        this.fOverlayStore.start();
        Control control = this.createAppearancePage(parent);
        this.initialize();
        Dialog.applyDialogFont((Control)control);
        return control;
    }

    protected abstract Control createAppearancePage(Composite var1);

    protected void initialize() {
        this.initializeFields();
        if (this.fAppearanceColorList != null) {
            int i = 0;
            while (i < this.fAppearanceColorListModel.length) {
                this.fAppearanceColorList.add(this.fAppearanceColorListModel[i][0]);
                ++i;
            }
            this.fAppearanceColorList.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (AbstractPydevPrefs.this.fAppearanceColorList != null && !AbstractPydevPrefs.this.fAppearanceColorList.isDisposed()) {
                        AbstractPydevPrefs.this.fAppearanceColorList.select(0);
                        AbstractPydevPrefs.this.handleAppearanceColorListSelection();
                    }
                }
            });
        }
    }

    protected void initializeFields() {
        String key;
        for (Button b : this.fCheckBoxes.keySet()) {
            key = this.fCheckBoxes.get(b);
            b.setSelection(this.fOverlayStore.getBoolean(key));
        }
        for (Text t : this.fTextFields.keySet()) {
            key = this.fTextFields.get(t);
            t.setText(this.fOverlayStore.getString(key));
        }
        this.fFieldsInitialized = true;
        this.updateStatus(this.validatePositiveNumber("0"));
        for (SelectionListener listener : this.fMasterSlaveListeners) {
            listener.widgetSelected(null);
        }
    }

    protected void initializeDefaultColors() {
        RGB rgb;
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionBackground")) {
            rgb = this.getControl().getDisplay().getSystemColor(26).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionBackground", (RGB)rgb);
        }
        if (!this.getPreferenceStore().contains("AbstractTextEditor.Color.SelectionForeground")) {
            rgb = this.getControl().getDisplay().getSystemColor(27).getRGB();
            PreferenceConverter.setDefault((IPreferenceStore)this.fOverlayStore, (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
            PreferenceConverter.setDefault((IPreferenceStore)this.getPreferenceStore(), (String)"AbstractTextEditor.Color.SelectionForeground", (RGB)rgb);
        }
    }

    public boolean performOk() {
        this.fOverlayStore.propagate();
        PydevPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void performDefaults() {
        this.fOverlayStore.loadDefaults();
        this.initializeFields();
        this.handleAppearanceColorListSelection();
        super.performDefaults();
        this.onAppearanceRelatedPreferenceChanged();
    }

    public void dispose() {
        if (this.fOverlayStore != null) {
            this.fOverlayStore.stop();
            this.fOverlayStore = null;
        }
        super.dispose();
    }

    protected Button addCheckBox(Composite parent, String label, String key, int indentation) {
        Button checkBox = new Button(parent, 32);
        checkBox.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        checkBox.setLayoutData((Object)gd);
        checkBox.addSelectionListener(this.fCheckBoxListener);
        this.fCheckBoxes.put(checkBox, key);
        return checkBox;
    }

    protected Label addLabel(Composite parent, String label, int indentation) {
        Label labelWidget = new Label(parent, 0);
        labelWidget.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        gd.horizontalSpan = 2;
        labelWidget.setLayoutData((Object)gd);
        return labelWidget;
    }

    protected Control addTextField(Composite composite, String label, String key, int textLimit, int indentation, boolean isNumber) {
        Label labelControl = new Label(composite, 0);
        labelControl.setText(label);
        GridData gd = new GridData(32);
        gd.horizontalIndent = indentation;
        labelControl.setLayoutData((Object)gd);
        Text textControl = new Text(composite, 2052);
        gd = new GridData(32);
        gd.widthHint = this.convertWidthInCharsToPixels(textLimit + 1);
        textControl.setLayoutData((Object)gd);
        textControl.setTextLimit(textLimit);
        this.fTextFields.put(textControl, key);
        if (isNumber) {
            this.fNumberFields.add(textControl);
            textControl.addModifyListener(this.fNumberFieldListener);
        } else {
            textControl.addModifyListener(this.fTextFieldListener);
        }
        return textControl;
    }

    protected void createInverseDependency(Button master, String masterKey, Control slave) {
        this.doCreateDependency(master, masterKey, slave, false);
    }

    protected void createDependency(Button master, String masterKey, Control slave) {
        this.doCreateDependency(master, masterKey, slave, true);
    }

    private void doCreateDependency(final Button master, String masterKey, final Control slave, final boolean enableIf) {
        AbstractPydevPrefs.indent(slave);
        boolean masterState = this.fOverlayStore.getBoolean(masterKey);
        slave.setEnabled(masterState == enableIf);
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                slave.setEnabled(master.getSelection() == enableIf);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        master.addSelectionListener(listener);
        this.fMasterSlaveListeners.add(listener);
    }

    protected static void indent(Control control) {
        GridData gridData = new GridData();
        gridData.horizontalIndent = 20;
        control.setLayoutData((Object)gridData);
    }

    protected void numberFieldChanged(Text textControl) {
        String number = textControl.getText();
        IStatus status = this.validatePositiveNumber(number);
        if (!status.matches(4)) {
            this.fOverlayStore.setValue(this.fTextFields.get(textControl), number);
        }
        this.updateStatus(status);
    }

    protected IStatus validatePositiveNumber(String number) {
        StatusInfo status = new StatusInfo();
        if (number.length() == 0) {
            status.setError("empty_input??");
        } else {
            try {
                int value = Integer.parseInt(number);
                if (value < 0) {
                    status.setError("invalid_input??");
                }
            }
            catch (NumberFormatException e) {
                status.setError("invalid_input??");
            }
        }
        return status;
    }

    void updateStatus(IStatus status) {
        if (!this.fFieldsInitialized) {
            return;
        }
        if (!status.matches(4)) {
            int i = 0;
            while (i < this.fNumberFields.size()) {
                Text text = this.fNumberFields.get(i);
                IStatus s = this.validatePositiveNumber(text.getText());
                status = s.getSeverity() > status.getSeverity() ? s : status;
                ++i;
            }
        }
        this.setValid(!status.matches(4));
        this.applyToStatusLine((DialogPage)this, status);
    }

    public void applyToStatusLine(DialogPage page, IStatus status) {
        String message = status.getMessage();
        switch (status.getSeverity()) {
            case 0: {
                page.setMessage(message, 0);
                page.setErrorMessage(null);
                break;
            }
            case 2: {
                page.setMessage(message, 2);
                page.setErrorMessage(null);
                break;
            }
            case 1: {
                page.setMessage(message, 1);
                page.setErrorMessage(null);
                break;
            }
            default: {
                if (message.length() == 0) {
                    message = null;
                }
                page.setMessage(null);
                page.setErrorMessage(message);
            }
        }
    }

    protected void handleAppearanceColorListSelection() {
        int i = this.fAppearanceColorList.getSelectionIndex();
        String key = this.fAppearanceColorListModel[i][1];
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fOverlayStore, (String)key);
        this.fAppearanceColorEditor.setColorValue(rgb);
        String styleKey = this.fAppearanceFontListModel[i][1];
        int styleValue = this.fOverlayStore.getInt(styleKey);
        if ((styleValue & 1) == 0) {
            this.fFontBoldCheckBox.setSelection(false);
        } else {
            this.fFontBoldCheckBox.setSelection(true);
        }
        if ((styleValue & 2) == 0) {
            this.fFontItalicCheckBox.setSelection(false);
        } else {
            this.fFontItalicCheckBox.setSelection(true);
        }
        this.updateAppearanceColorWidgets(this.fAppearanceColorListModel[i][2]);
    }

    protected void updateAppearanceColorWidgets(String systemDefaultKey) {
        if (systemDefaultKey == null) {
            this.fAppearanceColorDefault.setSelection(false);
            this.fAppearanceColorDefault.setVisible(false);
            this.fAppearanceColorEditor.getButton().setEnabled(true);
        } else {
            boolean systemDefault = this.fOverlayStore.getBoolean(systemDefaultKey);
            this.fAppearanceColorDefault.setSelection(systemDefault);
            this.fAppearanceColorDefault.setVisible(true);
            this.fAppearanceColorEditor.getButton().setEnabled(!systemDefault);
        }
    }
}

