/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevRootPrefs;
import org.python.pydev.shared_ui.dialogs.DialogMemento;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class CheckDefaultPreferencesDialog
extends TrayDialog {
    private Button okButton;
    private Button cancelButton;
    private DialogMemento memento;
    private final CheckInfo[] missing;
    List<Button> checkBoxes;
    public static volatile boolean showing = false;

    CheckDefaultPreferencesDialog(Shell shell, CheckInfo[] missing) {
        super(shell);
        this.setHelpAvailable(false);
        this.setShellStyle(0xC70 | CheckDefaultPreferencesDialog.getDefaultOrientation());
        this.setBlockOnOpen(true);
        this.memento = new DialogMemento(shell, "org.python.pydev.core.preferences.CheckDefaultPreferencesDialog");
        this.missing = missing;
        this.checkBoxes = new ArrayList<Button>(missing.length + 2);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.cancelButton = this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public boolean close() {
        this.memento.writeSettings(this.getShell());
        return super.close();
    }

    protected Point getInitialSize() {
        return this.memento.getInitialSize(super.getInitialSize(), this.getShell());
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.memento.getInitialLocation(initialSize, super.getInitialLocation(initialSize), this.getShell());
    }

    protected Control createDialogArea(Composite parent) {
        this.memento.readSettings();
        Composite area = (Composite)super.createDialogArea(parent);
        this.createLabel(area, "Uncheck settings that should not be changed.\n");
        CheckInfo[] checkInfoArray = this.missing;
        int n = this.missing.length;
        int n2 = 0;
        while (n2 < n) {
            CheckInfo c = checkInfoArray[n2];
            Button bt = this.addCheckBox(area, c.msg, c.description);
            bt.setData((Object)c);
            ++n2;
        }
        this.createLabel(area, "\n");
        Button bt = this.addCheckBox(area, "Re-check whenever a PyDev editor is opened?", "");
        bt.setSelection(PydevRootPrefs.getCheckPreferredPydevSettings());
        bt.setData((Object)"CHECK_PREFERRED_PYDEV_SETTINGS");
        return area;
    }

    private void createLabel(Composite area, String text) {
        Label label = new Label(area, 0);
        label.setText(text);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        label.setLayoutData((Object)data);
    }

    private Button addCheckBox(Composite area, String msg, String desc) {
        Button bt = new Button(area, 32);
        bt.setText(msg);
        bt.setSelection(true);
        GridData data = new GridData(768);
        data.grabExcessHorizontalSpace = true;
        bt.setLayoutData((Object)data);
        this.checkBoxes.add(bt);
        if (desc.length() > 0) {
            Label label = new Label(area, 0);
            label.setText(desc);
            data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            label.setLayoutData((Object)data);
        }
        return bt;
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Default Eclipse preferences for PyDev");
    }

    protected void okPressed() {
        this.applyChanges();
        super.okPressed();
    }

    private void applyChanges() {
        for (Button bt : this.checkBoxes) {
            Object data = bt.getData();
            if (data instanceof CheckInfo) {
                if (!bt.getSelection()) continue;
                CheckInfo checkInfo = (CheckInfo)data;
                checkInfo.apply();
                continue;
            }
            if (data.equals("CHECK_PREFERRED_PYDEV_SETTINGS")) {
                PydevRootPrefs.setCheckPreferredPydevSettings(bt.getSelection());
                continue;
            }
            Log.log((String)("Unexpected data: " + String.valueOf(data)));
        }
    }

    public static void askAboutSettings() {
        IPreferenceStore preferenceStore = PydevPlugin.getDefault().getPreferenceStore();
        boolean checkPreferredSettings = preferenceStore.getBoolean("CHECK_PREFERRED_PYDEV_SETTINGS");
        if (checkPreferredSettings) {
            final CheckInfo[] missing = CheckInfo.getMissing();
            if (missing.length == 0) {
                return;
            }
            boolean runNowIfInUiThread = false;
            RunInUiThread.async((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (showing) {
                        return;
                    }
                    Display disp = Display.getCurrent();
                    Shell shell = disp.getActiveShell();
                    if (shell == null) {
                        shell = new Shell(disp);
                    }
                    CheckDefaultPreferencesDialog dialog = new CheckDefaultPreferencesDialog(shell, missing);
                    showing = true;
                    try {
                        dialog.open();
                    }
                    finally {
                        showing = false;
                    }
                }
            }, (boolean)runNowIfInUiThread);
        }
    }

    public static class CheckInfo {
        public final String description;
        public final String plugin;
        public final String pref;
        public final String value;
        public final String msg;

        private CheckInfo(String plugin, String pref, String value, String msg, String description) {
            this.plugin = plugin;
            this.pref = pref;
            this.value = value;
            this.msg = msg;
            this.description = description;
        }

        public static CheckInfo[] getMissing() {
            String buildDesc = "\tReason: To launch a file in PyDev a build is not required.\n\n\tNote that JDT/CDT may require a build to compile before launching,\n\tso, leave it unchecked if you use one of those plugins and want to\n\tautomatically build before launching.";
            CheckInfo[] infos = new CheckInfo[]{new CheckInfo("org.eclipse.debug.ui", "org.eclipse.debug.ui.wait_for_build", "never", "Wait for ongoing build before launching: never", buildDesc), new CheckInfo("org.eclipse.debug.ui", "org.eclipse.debug.ui.build_before_launch", "false", "Build (if required) before launching: no", buildDesc), new CheckInfo("org.eclipse.debug.ui", "org.eclipse.debug.ui.UseContextualLaunch", "", "Launch operation: always launch the previously selected application.", "\tReason: On PyDev, F9 launches the current selection (and Ctrl+F9 launches unit-tests),\n\tso it's recommended that Ctrl+F11 is set to re-launch the last launch and\n\tF11 to debug the last launch.")};
            ArrayList<CheckInfo> lst = new ArrayList<CheckInfo>(infos.length);
            CheckInfo[] checkInfoArray = infos;
            int n = infos.length;
            int n2 = 0;
            while (n2 < n) {
                CheckInfo c = checkInfoArray[n2];
                IEclipsePreferences node = InstanceScope.INSTANCE.getNode(c.plugin);
                if (!c.value.equals(node.get(c.pref, ""))) {
                    lst.add(c);
                }
                ++n2;
            }
            return lst.toArray(new CheckInfo[lst.size()]);
        }

        public void apply() {
            IEclipsePreferences node = InstanceScope.INSTANCE.getNode(this.plugin);
            node.put(this.pref, this.value);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                Log.log((Throwable)e);
            }
        }
    }
}

