/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.python.pydev.core.formatter.FormatStd;
import org.python.pydev.editor.StyledTextForShowingCodeFactory;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.preferences.IScopedPreferences;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.field_editors.BooleanFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.ComboFieldEditor;
import org.python.pydev.shared_ui.field_editors.CustomStringFieldEditor;
import org.python.pydev.shared_ui.field_editors.FileFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;
import org.python.pydev.shared_ui.utils.RunInUiThread;

public class PyCodeFormatterPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private StyledText labelExample;
    private BooleanFieldEditorCustom spaceAfterComma;
    private BooleanFieldEditorCustom onlyChangedLines;
    private BooleanFieldEditorCustom spaceForParentesis;
    private BooleanFieldEditorCustom assignWithSpaceInsideParentesis;
    private BooleanFieldEditorCustom operatorsWithSpace;
    private BooleanFieldEditorCustom rightTrimLines;
    private BooleanFieldEditorCustom rightTrimMultilineLiterals;
    private BooleanFieldEditorCustom addNewLineAtEndOfFile;
    private StyledTextForShowingCodeFactory formatAndStyleRangeHelper;
    private ComboFieldEditor spacesBeforeComment;
    private ComboFieldEditor spacesInStartComment;
    private ComboFieldEditor formatterStyle;
    private Composite fieldParent;
    private CustomStringFieldEditor autopep8Parameters;
    private CustomStringFieldEditor blackParameters;
    private CustomStringFieldEditor ruffParameters;
    private LinkFieldEditor interpreterLink;
    private boolean disposed = false;
    private TabFolder tabFolder;
    private static final String[][] ENTRIES_AND_VALUES_FOR_SPACES = new String[][]{{"Don't change manual formatting", Integer.toString(-1)}, {"No spaces", "0"}, {"1 space", "1"}, {"2 spaces", "2"}, {"3 spaces", "3"}, {"4 spaces", "4"}};
    private static final String[][] ENTRIES_AND_VALUES_FOR_SPACES2 = new String[][]{{"Don't change manual formatting", Integer.toString(-1)}, {"At least 1 space", "1"}, {"At least 2 spaces", "2"}, {"At least 3 spaces", "3"}, {"At least 4 spaces", "4"}};
    private static final String[][] ENTRIES_AND_VALUES_FOR_FORMATTER = new String[][]{{"PyDev.Formatter", FormatStd.FormatterEnum.PYDEVF.toString()}, {"autopep8", FormatStd.FormatterEnum.AUTOPEP8.toString()}, {"Black", FormatStd.FormatterEnum.BLACK.toString()}, {"ruff", FormatStd.FormatterEnum.RUFF.toString()}};
    private TabItem tabItemSpacing;
    private TabItem tabItemBlankLines;
    private Composite blankLinesParent;
    private Composite spacingParent;
    private TabItem tabItemComments;
    private Composite commentsParent;
    private BooleanFieldEditorCustom manageBlankLines;
    private IntegerFieldEditor blankLinesTopLevel;
    private IntegerFieldEditor blankLinesInner;
    private RadioGroupFieldEditor blackFormatterLocation;
    private FileFieldEditorCustom blackFileField;
    private RadioGroupFieldEditor ruffFormatterLocation;
    private FileFieldEditorCustom ruffFileField;
    public static final String[][] SEARCH_FORMATTER_LOCATION_OPTIONS = new String[][]{{"Search in interpreter", "LOCATION_SEARCH"}, {"Specify Location", "LOCATION_SPECIFY"}};
    private Runnable currentRunnable;

    public PyCodeFormatterPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void createFieldEditors() {
        Button b;
        Composite p;
        this.fieldParent = p = this.getFieldEditorParent();
        this.addField((FieldEditor)new LinkFieldEditor("link_saveactions", "Note: view <a>save actions</a> to auto-format on save.", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.python.pydev.editor.saveactions.PydevSaveActionsPrefPage";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)PyCodeFormatterPage.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.formatterStyle = new ComboFieldEditor("FORMATTER_STYLE", "Formatter style?", ENTRIES_AND_VALUES_FOR_FORMATTER, p);
        this.addField((FieldEditor)this.formatterStyle);
        this.blackFormatterLocation = new RadioGroupFieldEditor("BLACK_FORMATTER_LOCATION_OPTION", "Black executable", 2, SEARCH_FORMATTER_LOCATION_OPTIONS, p);
        Button[] buttonArray = this.blackFormatterLocation.getRadioButtons();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PyCodeFormatterPage.this.updateState();
                }
            });
            ++n2;
        }
        this.addField((FieldEditor)this.blackFormatterLocation);
        this.blackFileField = new FileFieldEditorCustom("BLACK_FORMATTER_FILE_LOCATION", "Location of the black executable:", p, 1);
        this.addField((FieldEditor)this.blackFileField);
        this.ruffFormatterLocation = new RadioGroupFieldEditor("RUFF_FORMATTER_LOCATION_OPTION", "Ruff executable", 2, SEARCH_FORMATTER_LOCATION_OPTIONS, p);
        buttonArray = this.ruffFormatterLocation.getRadioButtons();
        n = buttonArray.length;
        n2 = 0;
        while (n2 < n) {
            b = buttonArray[n2];
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PyCodeFormatterPage.this.updateState();
                }
            });
            ++n2;
        }
        this.addField((FieldEditor)this.ruffFormatterLocation);
        this.ruffFileField = new FileFieldEditorCustom("RUFF_FORMATTER_FILE_LOCATION", "Location of the ruff executable:", p, 1);
        this.addField((FieldEditor)this.ruffFileField);
        this.interpreterLink = new LinkFieldEditor("link_autopep8_interpreter", "Note: the default configured <a>Python Interpreter</a> will be used to execute autopep8.py/black/ruff", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPagePython";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)PyCodeFormatterPage.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addField((FieldEditor)this.interpreterLink);
        this.autopep8Parameters = new CustomStringFieldEditor("AUTOPEP8_PARAMETERS", "Parameters for autopep8 (i.e.: -a for aggressive, --ignore E24)", p);
        this.addField((FieldEditor)this.autopep8Parameters);
        this.blackParameters = new CustomStringFieldEditor("BLACK_PARAMETERS", "Parameters for black (i.e.: -S don't convert single to double quotes)", p);
        this.addField((FieldEditor)this.blackParameters);
        this.ruffParameters = new CustomStringFieldEditor("RUFF_PARAMETERS", "Parameters for ruff format", p);
        this.addField((FieldEditor)this.ruffParameters);
        this.onlyChangedLines = this.createBooleanFieldEditorCustom("FORMAT_ONLY_CHANGED_LINES", "On save, only apply formatting in changed lines?", p);
        this.addField((FieldEditor)this.onlyChangedLines);
        this.createTabs(p);
        this.spaceAfterComma = this.createBooleanFieldEditorCustom("USE_SPACE_AFTER_COMMA", "Use space after commas?", this.spacingParent);
        this.addField((FieldEditor)this.spaceAfterComma);
        this.spaceForParentesis = this.createBooleanFieldEditorCustom("USE_SPACE_FOR_PARENTESIS", "Use space before and after parenthesis?", this.spacingParent);
        this.addField((FieldEditor)this.spaceForParentesis);
        this.assignWithSpaceInsideParentesis = this.createBooleanFieldEditorCustom("USE_ASSIGN_WITH_PACES_INSIDER_PARENTESIS", "Use space before and after assign for keyword arguments?", this.spacingParent);
        this.addField((FieldEditor)this.assignWithSpaceInsideParentesis);
        this.operatorsWithSpace = this.createBooleanFieldEditorCustom("USE_OPERATORS_WITH_SPACE", "Use space before and after operators? (+, -, /, *, //, **, etc.)", this.spacingParent);
        this.addField((FieldEditor)this.operatorsWithSpace);
        this.rightTrimLines = this.createBooleanFieldEditorCustom("TRIM_EMPTY_LINES", "Right trim lines?", this.spacingParent);
        this.addField((FieldEditor)this.rightTrimLines);
        this.rightTrimMultilineLiterals = this.createBooleanFieldEditorCustom("TRIM_MULTILINE_LITERALS", "Right trim multi-line string literals?", this.spacingParent);
        this.addField((FieldEditor)this.rightTrimMultilineLiterals);
        this.spacesBeforeComment = new ComboFieldEditor("SPACES_BEFORE_COMMENT", "Spaces before a comment?", ENTRIES_AND_VALUES_FOR_SPACES, this.commentsParent);
        this.addField((FieldEditor)this.spacesBeforeComment);
        this.spacesInStartComment = new ComboFieldEditor("SPACES_IN_START_COMMENT", "Spaces in comment start?", ENTRIES_AND_VALUES_FOR_SPACES2, this.commentsParent);
        this.addField((FieldEditor)this.spacesInStartComment);
        this.addNewLineAtEndOfFile = this.createBooleanFieldEditorCustom("ADD_NEW_LINE_AT_END_OF_FILE", "Add new line at end of file?", this.blankLinesParent);
        this.addField((FieldEditor)this.addNewLineAtEndOfFile);
        this.manageBlankLines = this.createBooleanFieldEditorCustom("MANAGE_BLANK_LINES", "Manage blank lines?\n(will convert 2+ subsequent blank lines to 1)", this.blankLinesParent);
        this.addField((FieldEditor)this.manageBlankLines);
        this.blankLinesTopLevel = new IntegerFieldEditor("BLANK_LINES_TOP_LEVEL", "Blank lines before/after top level class/method?", this.blankLinesParent);
        this.addField((FieldEditor)this.blankLinesTopLevel);
        this.blankLinesInner = new IntegerFieldEditor("BLANK_LINES_INNER", "Blank lines before/after non top level class/method?", this.blankLinesParent);
        this.addField((FieldEditor)this.blankLinesInner);
        this.formatAndStyleRangeHelper = new StyledTextForShowingCodeFactory();
        this.labelExample = this.formatAndStyleRangeHelper.createStyledTextForCodePresentation(p);
        GridData layoutData = new GridData(4, 4, true, true, 2, 1);
        this.labelExample.setLayoutData((Object)layoutData);
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(p, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
        RunInUiThread.async((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!PyCodeFormatterPage.this.disposed) {
                    PyCodeFormatterPage.this.updateState();
                }
            }
        }, (boolean)false);
    }

    public void loadFromProjectSettings(IScopedPreferences iScopedPreferences, IProject project) {
        super.loadFromProjectSettings(iScopedPreferences, project);
        this.updateState();
    }

    public void loadFromUserSettings(IScopedPreferences iScopedPreferences) {
        super.loadFromUserSettings(iScopedPreferences);
        this.updateState();
    }

    public void loadFromWorkspace() {
        super.loadFromWorkspace();
        this.updateState();
    }

    private void createTabs(Composite p) {
        this.tabFolder = new TabFolder(p, 0);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 1;
        gd.grabExcessVerticalSpace = false;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.tabFolder.setLayoutData((Object)gd);
        this.tabItemSpacing = new TabItem(this.tabFolder, 0);
        this.tabItemSpacing.setText("Spacing");
        this.spacingParent = new Composite((Composite)this.tabFolder, 0);
        this.tabItemSpacing.setControl((Control)this.spacingParent);
        this.tabItemBlankLines = new TabItem(this.tabFolder, 0);
        this.tabItemBlankLines.setText("Blank lines");
        this.blankLinesParent = new Composite((Composite)this.tabFolder, 0);
        this.tabItemBlankLines.setControl((Control)this.blankLinesParent);
        this.tabItemComments = new TabItem(this.tabFolder, 0);
        this.tabItemComments.setText("Comments");
        this.commentsParent = new Composite((Composite)this.tabFolder, 0);
        this.tabItemComments.setControl((Control)this.commentsParent);
    }

    protected void initialize() {
        super.initialize();
        SelectionListener listener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PyCodeFormatterPage.this.updateState();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.formatterStyle.getCombo().addSelectionListener(listener);
        this.manageBlankLines.getCheckBox(this.blankLinesParent).addSelectionListener(listener);
        this.updateState();
        this.updateLabelExampleNow(this.getFormatFromEditorContents());
    }

    private FormatStd.FormatterEnum getComboFormatterStyle() {
        String comboValue = this.formatterStyle.getComboValue();
        return FormatStd.getFormatterEnumFromStr((String)comboValue);
    }

    private void updateState() {
        FormatStd.FormatterEnum currFormatterStyle = this.getComboFormatterStyle();
        this.autopep8Parameters.setVisible(currFormatterStyle == FormatStd.FormatterEnum.AUTOPEP8, this.fieldParent);
        this.blackParameters.setVisible(currFormatterStyle == FormatStd.FormatterEnum.BLACK, this.fieldParent);
        this.ruffParameters.setVisible(currFormatterStyle == FormatStd.FormatterEnum.RUFF, this.fieldParent);
        switch (currFormatterStyle) {
            case AUTOPEP8: 
            case BLACK: 
            case RUFF: {
                this.blackFormatterLocation.setVisible(currFormatterStyle == FormatStd.FormatterEnum.BLACK, this.fieldParent);
                this.ruffFormatterLocation.setVisible(currFormatterStyle == FormatStd.FormatterEnum.RUFF, this.fieldParent);
                boolean showFileBlack = currFormatterStyle == FormatStd.FormatterEnum.BLACK && "LOCATION_SPECIFY".equals(this.blackFormatterLocation.getRadioValue());
                boolean showFileRuff = currFormatterStyle == FormatStd.FormatterEnum.RUFF && "LOCATION_SPECIFY".equals(this.ruffFormatterLocation.getRadioValue());
                this.blackFileField.setVisible(showFileBlack);
                this.ruffFileField.setVisible(showFileRuff);
                this.interpreterLink.setVisible(!showFileBlack && !showFileRuff);
                this.assignWithSpaceInsideParentesis.setVisible(false, this.spacingParent);
                this.operatorsWithSpace.setVisible(false, this.spacingParent);
                this.spaceForParentesis.setVisible(false, this.spacingParent);
                this.spaceAfterComma.setVisible(false, this.spacingParent);
                this.rightTrimLines.setVisible(false, this.spacingParent);
                this.rightTrimMultilineLiterals.setVisible(false, this.spacingParent);
                this.addNewLineAtEndOfFile.setVisible(false, this.blankLinesParent);
                this.manageBlankLines.setVisible(false, this.blankLinesParent);
                this.blankLinesTopLevel.setEnabled(false, this.blankLinesParent);
                this.blankLinesInner.setEnabled(false, this.blankLinesParent);
                this.spacesBeforeComment.setEnabled(false, this.commentsParent);
                this.spacesInStartComment.setEnabled(false, this.commentsParent);
                this.onlyChangedLines.setVisible(false, this.fieldParent);
                this.setVisible((Control)this.tabFolder, false);
                break;
            }
            default: {
                this.blackFormatterLocation.setVisible(false, this.fieldParent);
                this.ruffFormatterLocation.setVisible(false, this.fieldParent);
                this.blackFileField.setVisible(false);
                this.ruffFileField.setVisible(false);
                this.interpreterLink.setVisible(false);
                this.assignWithSpaceInsideParentesis.setVisible(true, this.spacingParent);
                this.operatorsWithSpace.setVisible(true, this.spacingParent);
                this.spaceForParentesis.setVisible(true, this.spacingParent);
                this.spaceAfterComma.setVisible(true, this.spacingParent);
                this.rightTrimLines.setVisible(true, this.spacingParent);
                this.rightTrimMultilineLiterals.setVisible(true, this.spacingParent);
                this.addNewLineAtEndOfFile.setVisible(true, this.blankLinesParent);
                this.manageBlankLines.setVisible(true, this.blankLinesParent);
                if (this.manageBlankLines.getBooleanValue()) {
                    this.blankLinesTopLevel.setEnabled(true, this.blankLinesParent);
                    this.blankLinesInner.setEnabled(true, this.blankLinesParent);
                } else {
                    this.blankLinesTopLevel.setEnabled(false, this.blankLinesParent);
                    this.blankLinesInner.setEnabled(false, this.blankLinesParent);
                }
                this.spacesBeforeComment.setEnabled(true, this.commentsParent);
                this.spacesInStartComment.setEnabled(true, this.commentsParent);
                this.onlyChangedLines.setVisible(true, this.fieldParent);
                this.setVisible((Control)this.tabFolder, true);
            }
        }
        this.fieldParent.layout(true);
    }

    private void setVisible(Control control, boolean visible) {
        control.setVisible(visible);
        GridData layoutData = (GridData)control.getLayoutData();
        layoutData.exclude = !visible;
    }

    private BooleanFieldEditorCustom createBooleanFieldEditorCustom(String name, String label, Composite parent) {
        return new BooleanFieldEditorCustom(name, label, 1, parent);
    }

    private void updateLabelExample(final FormatStd formatStd) {
        if (!this.disposed) {
            Runnable runnable;
            this.currentRunnable = runnable = new Runnable(){

                @Override
                public void run() {
                    if (PyCodeFormatterPage.this.disposed) {
                        PyCodeFormatterPage.this.currentRunnable = null;
                        return;
                    }
                    if (PyCodeFormatterPage.this.currentRunnable == this) {
                        PyCodeFormatterPage.this.updateLabelExampleNow(formatStd);
                        PyCodeFormatterPage.this.currentRunnable = null;
                    }
                }
            };
            Display.getCurrent().timerExec(400, runnable);
        }
    }

    private void updateLabelExampleNow(FormatStd formatStd) {
        String str = "                                   \n                                   \n                                   \n                                   \nclass Example(object):             \n                                   \n    def Call(self, param1=None):   \n        '''docstring'''            \n        return param1 + 10 * 10    \n                                   \n                                   \n                                   \n    def Call2(self): #Comment      \n        #Comment                   \n        return self.Call(param1=10)";
        Tuple<String, StyleRange[]> result = this.formatAndStyleRangeHelper.formatAndGetStyleRanges(formatStd, str, PyDevUiPrefs.getChainedPrefStore(), true);
        this.labelExample.setText((String)result.o1);
        this.labelExample.setStyleRanges((StyleRange[])result.o2);
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        this.updateLabelExample(this.getFormatFromEditorContents());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateLabelExample(this.getFormatFromEditorContents());
        this.updateState();
    }

    private FormatStd getFormatFromEditorContents() {
        FormatStd formatStd = new FormatStd();
        formatStd.assignWithSpaceInsideParens = this.assignWithSpaceInsideParentesis.getBooleanValue();
        formatStd.operatorsWithSpace = this.operatorsWithSpace.getBooleanValue();
        formatStd.parametersWithSpace = this.spaceForParentesis.getBooleanValue();
        formatStd.spaceAfterComma = this.spaceAfterComma.getBooleanValue();
        formatStd.addNewLineAtEndOfFile = this.addNewLineAtEndOfFile.getBooleanValue();
        formatStd.manageBlankLines = this.manageBlankLines.getBooleanValue();
        try {
            formatStd.blankLinesTopLevel = this.blankLinesTopLevel.getIntValue();
        }
        catch (NumberFormatException e1) {
            formatStd.blankLinesTopLevel = 2;
        }
        try {
            formatStd.blankLinesInner = this.blankLinesInner.getIntValue();
        }
        catch (NumberFormatException e) {
            formatStd.blankLinesInner = 1;
        }
        formatStd.trimLines = this.rightTrimLines.getBooleanValue();
        formatStd.trimMultilineLiterals = this.rightTrimMultilineLiterals.getBooleanValue();
        formatStd.spacesBeforeComment = Integer.parseInt(this.spacesBeforeComment.getComboValue());
        formatStd.spacesInStartComment = Integer.parseInt(this.spacesInStartComment.getComboValue());
        formatStd.formatterStyle = this.getComboFormatterStyle();
        formatStd.autopep8Parameters = this.autopep8Parameters.getStringValue();
        formatStd.blackParameters = this.blackParameters.getStringValue();
        formatStd.ruffParameters = this.ruffParameters.getStringValue();
        formatStd.searchBlackInInterpreter = !"LOCATION_SPECIFY".equals(this.blackFormatterLocation.getRadioValue());
        formatStd.searchRuffInInterpreter = !"LOCATION_SPECIFY".equals(this.ruffFormatterLocation.getRadioValue());
        formatStd.blackExecutableLocation = this.blackFileField.getStringValue();
        formatStd.ruffExecutableLocation = this.ruffFileField.getStringValue();
        formatStd.updateFormatterStyle();
        return formatStd;
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        this.disposed = true;
        super.dispose();
        if (this.formatAndStyleRangeHelper != null) {
            this.formatAndStyleRangeHelper.dispose();
        }
    }
}

