/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.ast.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.utils.TableComboFieldEditor;

public class PyTitlePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String TITLE_EDITOR_NAMES_UNIQUE = "TITLE_EDITOR_NAMES_UNIQUE";
    public static final boolean DEFAULT_TITLE_EDITOR_NAMES_UNIQUE = true;
    public static final String TITLE_EDITOR_SHOW_EXTENSION = "TITLE_EDITOR_SHOW_EXTENSION";
    public static final boolean DEFAULT_TITLE_EDITOR_SHOW_EXTENSION = false;
    public static final String TITLE_EDITOR_CUSTOM_INIT_ICON = "TITLE_EDITOR_CUSTOM_INIT_ICON";
    public static final boolean DEFAULT_TITLE_EDITOR_CUSTOM_INIT_ICON = true;
    public static final String TITLE_EDITOR_INIT_HANDLING = "TITLE_EDITOR_INIT_HANDLING";
    public static final String TITLE_EDITOR_INIT_HANDLING_IN_TITLE = "TITLE_EDITOR_INIT_HANDLING_IN_TITLE";
    public static final String TITLE_EDITOR_INIT_HANDLING_PARENT_IN_TITLE = "TITLE_EDITOR_INIT_HANDLING_PARENT_IN_TITLE";
    public static final String DEFAULT_TITLE_EDITOR_INIT_HANDLING = "TITLE_EDITOR_INIT_HANDLING_PARENT_IN_TITLE";
    public static final String TITLE_EDITOR_DJANGO_MODULES_HANDLING = "TITLE_EDITOR_DJANGO_MODULES_HANDLING";
    public static final String TITLE_EDITOR_DJANGO_MODULES_DEFAULT_ICON = "TITLE_EDITOR_DJANGO_MODULES_DEFAULT_ICON";
    public static final String TITLE_EDITOR_DJANGO_MODULES_DECORATE = "TITLE_EDITOR_DJANGO_MODULES_DECORATE";
    public static final String TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE = "TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE";
    public static final String DEFAULT_TITLE_EDITOR_DJANGO_MODULES_HANDLING = "TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE";
    private BooleanFieldEditor editorNamesUnique;
    private BooleanFieldEditor changeInitIcon;
    private TableComboFieldEditor initHandlingFieldEditor;
    private BooleanFieldEditor titleShowExtension;
    private TableComboFieldEditor djangoHandling;

    public static boolean isTitlePreferencesProperty(String property) {
        return TITLE_EDITOR_INIT_HANDLING.equals(property) || TITLE_EDITOR_NAMES_UNIQUE.equals(property) || TITLE_EDITOR_SHOW_EXTENSION.equals(property) || TITLE_EDITOR_CUSTOM_INIT_ICON.equals(property) || TITLE_EDITOR_DJANGO_MODULES_HANDLING.equals(property);
    }

    public static boolean isTitlePreferencesIconRelatedProperty(String property) {
        return TITLE_EDITOR_CUSTOM_INIT_ICON.equals(property) || TITLE_EDITOR_DJANGO_MODULES_HANDLING.equals(property);
    }

    public PyTitlePreferencesPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.editorNamesUnique = new BooleanFieldEditor(TITLE_EDITOR_NAMES_UNIQUE, "Editor name (considering icon) must be unique?", 1, p);
        this.addField((FieldEditor)this.editorNamesUnique);
        this.titleShowExtension = new BooleanFieldEditor(TITLE_EDITOR_SHOW_EXTENSION, "Show file extension on tab?", 1, p);
        this.addField((FieldEditor)this.titleShowExtension);
        this.changeInitIcon = new BooleanFieldEditor(TITLE_EDITOR_CUSTOM_INIT_ICON, "Use custom init icon?", 1, p);
        this.addField((FieldEditor)this.changeInitIcon);
        Object[][] objectArray = new Object[2][];
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "__init__.py should appear in title";
        objectArray2[1] = TITLE_EDITOR_INIT_HANDLING_IN_TITLE;
        objectArray[0] = objectArray2;
        Object[] objectArray3 = new Object[3];
        objectArray3[0] = "Show parent name in title";
        objectArray3[1] = "TITLE_EDITOR_INIT_HANDLING_PARENT_IN_TITLE";
        objectArray[1] = objectArray3;
        Object[][] EDITOR__INIT__HANDLING_VALUES = objectArray;
        this.initHandlingFieldEditor = new TableComboFieldEditor(TITLE_EDITOR_INIT_HANDLING, "__init__.py handling:", EDITOR__INIT__HANDLING_VALUES, p);
        this.addField(this.initHandlingFieldEditor);
        new LabelFieldEditor("UNUSED", "Django related configurations", p);
        new LabelFieldEditor("UNUSED", "", p);
        Object[][] objectArray4 = new Object[3][];
        Object[] objectArray5 = new Object[3];
        objectArray5[0] = "Show as regular module";
        objectArray5[1] = TITLE_EDITOR_DJANGO_MODULES_DEFAULT_ICON;
        objectArray4[0] = objectArray5;
        Object[] objectArray6 = new Object[3];
        objectArray6[0] = "Show as regular module but using icon with module initial";
        objectArray6[1] = TITLE_EDITOR_DJANGO_MODULES_DECORATE;
        objectArray4[1] = objectArray6;
        Object[] objectArray7 = new Object[3];
        objectArray7[0] = "Show parent name in title and icon with module initial";
        objectArray7[1] = "TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE";
        objectArray4[2] = objectArray7;
        Object[][] EDITOR_DJANGO_MODULES_HANDLING_VALUES = objectArray4;
        this.djangoHandling = new TableComboFieldEditor(TITLE_EDITOR_DJANGO_MODULES_HANDLING, "Django modules handling:\n(models.py, views.py, tests.py)", EDITOR_DJANGO_MODULES_HANDLING_VALUES, p);
        this.addField(this.djangoHandling);
    }

    public void dispose() {
        super.dispose();
    }

    public static boolean getEditorNamesUnique() {
        return PydevPrefs.getEclipsePreferences().getBoolean(TITLE_EDITOR_NAMES_UNIQUE, true);
    }

    public static String getInitHandling() {
        String initHandling = PydevPrefs.getEclipsePreferences().get(TITLE_EDITOR_INIT_HANDLING, "TITLE_EDITOR_INIT_HANDLING_PARENT_IN_TITLE");
        if (TITLE_EDITOR_INIT_HANDLING_IN_TITLE.equals(initHandling)) {
            return TITLE_EDITOR_INIT_HANDLING_IN_TITLE;
        }
        return "TITLE_EDITOR_INIT_HANDLING_PARENT_IN_TITLE";
    }

    public static String getDjangoModulesHandling() {
        String djangoHandling = PydevPrefs.getEclipsePreferences().get(TITLE_EDITOR_DJANGO_MODULES_HANDLING, "TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE");
        if (TITLE_EDITOR_DJANGO_MODULES_DEFAULT_ICON.equals(djangoHandling)) {
            return TITLE_EDITOR_DJANGO_MODULES_DEFAULT_ICON;
        }
        if (TITLE_EDITOR_DJANGO_MODULES_DECORATE.equals(djangoHandling)) {
            return TITLE_EDITOR_DJANGO_MODULES_DECORATE;
        }
        return "TITLE_EDITOR_DJANGO_MODULES_SHOW_PARENT_AND_DECORATE";
    }

    public static boolean useCustomInitIcon() {
        return PydevPrefs.getEclipsePreferences().getBoolean(TITLE_EDITOR_CUSTOM_INIT_ICON, true);
    }

    public static boolean getTitleShowExtension() {
        return PydevPrefs.getEclipsePreferences().getBoolean(TITLE_EDITOR_SHOW_EXTENSION, false);
    }

    public static IImageHandle getInitIcon() {
        IImageCache imageCache = SharedUiPlugin.getImageCache();
        if (PyTitlePreferencesPage.useCustomInitIcon()) {
            return imageCache.get("icons/custom_init.png");
        }
        return imageCache.get("icons/python_file.gif");
    }

    public static boolean isDjangoModuleToDecorate(String name) {
        return (name.startsWith("models.") || name.startsWith("tests.") || name.startsWith("views.")) && PythonPathHelper.isValidSourceFile((String)name);
    }

    public static IImageHandle getDjangoModuleIcon(String lastSegment) {
        return SharedUiPlugin.getImageCache().getStringDecorated("icons/custom_python_file.png", "" + lastSegment.charAt(0));
    }
}

