/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class EmulatedNativeCheckBoxLabelProvider
extends ColumnLabelProvider {
    private static final String CHECKED_KEY = "CHECKED";
    private static final String UNCHECK_KEY = "UNCHECKED";
    private Shell shell = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 262152);

    public EmulatedNativeCheckBoxLabelProvider(ColumnViewer viewer) {
        if (JFaceResources.getImageRegistry().getDescriptor(CHECKED_KEY) == null) {
            this.workaround(viewer.getControl().getDisplay());
            JFaceResources.getImageRegistry().put(CHECKED_KEY, this.makeShot(viewer.getControl(), true));
            JFaceResources.getImageRegistry().put(UNCHECK_KEY, this.makeShot(viewer.getControl(), false));
        }
    }

    private Image makeShot(Control control, boolean type) {
        Color greenScreen = new Color((Device)control.getDisplay(), 222, 223, 224);
        this.shell = new Shell(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 262152);
        this.shell.setBackground(greenScreen);
        Button button = new Button((Composite)this.shell, 262176);
        button.setBackground(greenScreen);
        button.setSelection(type);
        button.setLocation(1, 1);
        Point bsize = button.computeSize(-1, -1);
        bsize.x = Math.max(bsize.x - 1, bsize.y - 1);
        bsize.y = Math.max(bsize.x - 1, bsize.y - 1);
        button.setSize(bsize);
        GC gc = new GC((Drawable)this.shell);
        Point shellSize = new Point(32, 32);
        this.shell.setSize(shellSize);
        this.shell.open();
        Image image = new Image((Device)control.getDisplay(), bsize.x, bsize.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        this.shell.close();
        ImageData imageData = image.getImageData();
        imageData.transparentPixel = imageData.palette.getPixel(greenScreen.getRGB());
        Image img = new Image((Device)control.getDisplay(), imageData);
        image.dispose();
        return img;
    }

    private void workaround(Display display) {
        this.shell.setSize(0, 0);
        this.shell.open();
        this.shell.close();
    }

    public Image getImage(Object element) {
        if (this.isChecked(element)) {
            return JFaceResources.getImageRegistry().get(CHECKED_KEY);
        }
        return JFaceResources.getImageRegistry().get(UNCHECK_KEY);
    }

    protected abstract boolean isChecked(Object var1);
}

