/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.python.pydev.ast.interpreter_managers.IInterpreterProviderFactory;
import org.python.pydev.ast.interpreter_managers.InterpreterManagersAPI;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PipenvHelper;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.callbacks.CallbackWithListeners;
import org.python.pydev.shared_core.callbacks.ICallback0;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.dialogs.SelectNDialog;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterPreferencesPage;
import org.python.pydev.ui.pythonpathconf.AutoConfigMaker;
import org.python.pydev.ui.pythonpathconf.InterpreterConfigHelpers;
import org.python.pydev.ui.pythonpathconf.ObtainInterpreterInfoOperation;

public class PyProjectPythonDetails
extends PropertyPage {
    private static final String ADDITIONAL_SYNTAX_PREFIX = "Additional syntax validation: ";
    private static final String ADDITIONAL_SYNTAX_NO_SELECTED = "Additional syntax validation: <no additional grammars selected>.";
    public IAdaptable element;
    public ProjectInterpreterAndGrammarConfig projectConfig = new ProjectInterpreterAndGrammarConfig((ICallback0<String>)((ICallback0)() -> this.getProject().getLocation().toOSString()));

    static String numberFromUi(String s) {
        if ("Same as interpreter".equals(s)) {
            return "interpreter";
        }
        if ("3.0 - 3.5".equals(s)) {
            s = "3.0";
        }
        return s;
    }

    static String numberToUi(String s) {
        if ("interpreter".equals(s)) {
            return "Same as interpreter";
        }
        if ("3.0".equals(s)) {
            s = "3.0 - 3.5";
        }
        return s;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = element;
    }

    public IProject getProject() {
        return (IProject)this.getElement().getAdapter(IProject.class);
    }

    public Control createContents(Composite p) {
        Control contents = this.projectConfig.doCreateContents(p);
        this.setSelected();
        return contents;
    }

    private void setSelected() {
        PythonNature pythonNature = PythonNature.getPythonNature((IProject)this.getProject());
        try {
            Set grammarVersions;
            String version = pythonNature.getVersion(false);
            if (version.startsWith("python")) {
                this.projectConfig.radioPy.setSelection(true);
            } else if (version.startsWith("jython")) {
                this.projectConfig.radioJy.setSelection(true);
            } else if (version.startsWith("ironpython")) {
                this.projectConfig.radioIron.setSelection(true);
            } else {
                Log.log((String)("Could not recognize version: " + version + " for project: " + String.valueOf(this.getProject())));
            }
            String v = (String)StringUtils.split((String)version, (char)' ').get(1);
            this.projectConfig.comboGrammarVersion.setText(PyProjectPythonDetails.numberToUi(v));
            this.projectConfig.selectionListener.widgetSelected(null);
            String configuredInterpreter = pythonNature.getProjectInterpreterName();
            if (configuredInterpreter != null) {
                this.projectConfig.interpretersChoice.setText(configuredInterpreter);
            }
            IGrammarVersionProvider.AdditionalGrammarVersionsToCheck additionalGrammarVersions = null;
            try {
                additionalGrammarVersions = pythonNature.getAdditionalGrammarVersions();
            }
            catch (MisconfigurationException misconfigurationException) {
                // empty catch block
            }
            FastStringBuffer buf = new FastStringBuffer();
            if (additionalGrammarVersions != null && (grammarVersions = additionalGrammarVersions.getGrammarVersions()) != null) {
                for (Integer grammarV : new TreeSet(grammarVersions)) {
                    String rep = (String)IGrammarVersionProvider.grammarVersionToRep.get(grammarV);
                    if (rep == null) continue;
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    buf.append(rep);
                }
            }
            if (buf.length() == 0) {
                this.projectConfig.labelAdditionalGrammarsSelected.setText(ADDITIONAL_SYNTAX_NO_SELECTED);
            } else {
                this.projectConfig.labelAdditionalGrammarsSelected.setText(ADDITIONAL_SYNTAX_PREFIX + buf.toString());
            }
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
    }

    protected void performApply() {
        this.doIt();
    }

    public boolean performOk() {
        return this.doIt();
    }

    public boolean performCancel() {
        PyDialogHelpers.enableAskInterpreterStep(true);
        return super.performCancel();
    }

    private boolean doIt() {
        IProject project = this.getProject();
        if (project != null) {
            String projectInterpreter;
            PythonNature pythonNature;
            block4: {
                pythonNature = PythonNature.getPythonNature((IProject)project);
                projectInterpreter = this.projectConfig.getProjectInterpreter();
                if (projectInterpreter != null) break block4;
                return false;
            }
            try {
                pythonNature.setVersion(this.projectConfig.getSelectedPythonOrJythonAndGrammarVersion(), projectInterpreter);
                pythonNature.setAdditionalGrammarValidation(this.projectConfig.getAdditionalGrammarValidation());
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
        }
        PyDialogHelpers.enableAskInterpreterStep(true);
        return true;
    }

    public static class ProjectInterpreterAndGrammarConfig {
        private static final String DEFAULT_PREFIX = "Default  --  currently: ";
        private static final String INTERPRETER_NOT_CONFIGURED_MSG = "<a>Please configure an interpreter before proceeding.</a>";
        public Button radioPy;
        public Button radioJy;
        public Button radioIron;
        public Combo comboGrammarVersion;
        public Label versionLabel;
        public Combo interpretersChoice;
        private Link interpreterNoteText;
        private SelectionListener selectionListener;
        private ICallback0<Object> onSelectionChanged;
        private Label interpreterLabel;
        private Label labelAdditionalGrammarsSelected;
        private ICallback0<String> getProjectLocation;

        public ProjectInterpreterAndGrammarConfig(ICallback0<String> getProjectLocation) {
            PyDialogHelpers.enableAskInterpreterStep(false);
            this.getProjectLocation = getProjectLocation;
        }

        public ProjectInterpreterAndGrammarConfig(ICallback0<Object> onSelectionChanged, ICallback0<String> getProjectLocation, CallbackWithListeners<Event> onLocationChanged) {
            this.onSelectionChanged = onSelectionChanged;
            this.getProjectLocation = getProjectLocation;
            onLocationChanged.registerListener(event -> {
                this.updateInterpretersAndDefaultInCombo();
                return null;
            });
        }

        public Control doCreateContents(Composite p) {
            Composite topComp = new Composite(p, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 1;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            topComp.setLayout((Layout)innerLayout);
            GridData gd = new GridData(1808);
            topComp.setLayoutData((Object)gd);
            Group group = new Group(topComp, 0);
            group.setText("Choose the project type");
            GridLayout layout = new GridLayout();
            layout.horizontalSpacing = 8;
            layout.numColumns = 3;
            group.setLayout((Layout)layout);
            gd = new GridData(768);
            group.setLayoutData((Object)gd);
            this.radioPy = new Button((Composite)group, 16400);
            this.radioPy.setText("Python");
            this.radioJy = new Button((Composite)group, 16400);
            this.radioJy.setText("Jython");
            this.radioIron = new Button((Composite)group, 16400);
            this.radioIron.setText("IronPython");
            this.versionLabel = new Label(topComp, 0);
            this.versionLabel.setText("Grammar Version");
            gd = new GridData(768);
            this.versionLabel.setLayoutData((Object)gd);
            this.comboGrammarVersion = new Combo(topComp, 8);
            for (String s : IPythonNature.Versions.VERSION_NUMBERS) {
                s = PyProjectPythonDetails.numberToUi(s);
                this.comboGrammarVersion.add(s);
            }
            gd = new GridData(768);
            this.comboGrammarVersion.setLayoutData((Object)gd);
            this.interpreterLabel = new Label(topComp, 0);
            this.interpreterLabel.setText("Interpreter");
            gd = new GridData(768);
            this.interpreterLabel.setLayoutData((Object)gd);
            final String[] idToConfig = new String[]{"org.python.pydev.ui.pythonpathconf.interpreterPreferencesPagePython"};
            this.interpretersChoice = new Combo(topComp, 8);
            this.selectionListener = new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String configPageId;
                    Button source;
                    if (e != null && !(source = (Button)e.getSource()).getSelection()) {
                        return;
                    }
                    IInterpreterManager interpreterManager = this.getInterpreterManager();
                    int interpreterType = interpreterManager.getInterpreterType();
                    IInterpreterInfo[] interpretersInfo = interpreterManager.getInterpreterInfos();
                    if (interpretersInfo.length > 0) {
                        File projectlocation;
                        IInterpreterInfo pipenvInterpreterInfoForProjectLocation;
                        String defaultEntry = ProjectInterpreterAndGrammarConfig.DEFAULT_PREFIX + interpretersInfo[0].getName();
                        if (interpreterType == 0 && (pipenvInterpreterInfoForProjectLocation = PipenvHelper.getPipenvInterpreterInfoForProjectLocation((IInterpreterInfo[])interpretersInfo, (File)(projectlocation = new File((String)getProjectLocation.call())), (IInterpreterManager)interpreterManager)) != null) {
                            defaultEntry = ProjectInterpreterAndGrammarConfig.DEFAULT_PREFIX + pipenvInterpreterInfoForProjectLocation.getName();
                        }
                        ArrayList<Object> interpretersWithDefault = new ArrayList<Object>();
                        interpretersWithDefault.add(defaultEntry);
                        IInterpreterInfo[] iInterpreterInfoArray = interpretersInfo;
                        int n = interpretersInfo.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IInterpreterInfo info = iInterpreterInfoArray[n2];
                            interpretersWithDefault.add(info.getName());
                            ++n2;
                        }
                        interpretersChoice.setItems(interpretersWithDefault.toArray(new String[0]));
                        interpretersChoice.setVisible(true);
                        interpreterNoteText.setText("<a>Click here to configure an interpreter not listed.</a>");
                        interpretersChoice.setText(defaultEntry);
                    } else {
                        interpretersChoice.setVisible(false);
                        interpreterNoteText.setText(ProjectInterpreterAndGrammarConfig.INTERPRETER_NOT_CONFIGURED_MSG);
                    }
                    idToConfig[0] = configPageId = InterpreterConfigHelpers.getConfigPageIdFromInterpreterType(interpreterType);
                    this.triggerCallback();
                }
            };
            gd = new GridData(768);
            this.interpretersChoice.setLayoutData((Object)gd);
            this.radioPy.addSelectionListener(this.selectionListener);
            this.radioJy.addSelectionListener(this.selectionListener);
            this.radioIron.addSelectionListener(this.selectionListener);
            this.interpreterNoteText = new Link(topComp, 16448);
            gd = new GridData(768);
            this.interpreterNoteText.setLayoutData((Object)gd);
            this.interpreterNoteText.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String interpreterName = this.getProjectInterpreter();
                    if (interpreterName != null) {
                        IInterpreterManager interpreterManager = this.getInterpreterManager();
                        int interpreterType = interpreterManager.getInterpreterType();
                        if (interpreterType == 0) {
                            String projectLocation = (String)getProjectLocation.call();
                            int USE_PIPENV = 1;
                            int openQuestionWithChoices = PyDialogHelpers.openQuestionWithChoices("How to config interpreter?", "How would you like to add a new interpreter?", "Open interpreter preferences page", "Create using pipenv");
                            if (openQuestionWithChoices == -1) {
                                return;
                            }
                            if (openQuestionWithChoices == USE_PIPENV) {
                                String s;
                                IInterpreterInfo[] interpreterInfos = interpreterManager.getInterpreterInfos();
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                PrintWriter logger = new PrintWriter(out);
                                HashMap<String, IInterpreterInfo> nameToInfo = new HashMap<String, IInterpreterInfo>();
                                IInterpreterInfo[] iInterpreterInfoArray = interpreterInfos;
                                int n = interpreterInfos.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    IInterpreterInfo info = iInterpreterInfoArray[n2];
                                    nameToInfo.put(info.getName(), info);
                                    ++n2;
                                }
                                try {
                                    ObtainInterpreterInfoOperation operation = InterpreterConfigHelpers.createPipenvInterpreter(interpreterInfos, interpreterNoteText.getShell(), logger, nameToInfo, projectLocation, interpreterManager);
                                    if (operation != null) {
                                        interpreterNoteText.setText("Configuration in progress...");
                                        AutoConfigMaker.applyOperation(this.createOnJobComplete(), operation, interpreterManager, null, false);
                                    }
                                }
                                catch (Exception e1) {
                                    Log.log((Throwable)e1);
                                }
                                if (!(s = out.toString()).isEmpty()) {
                                    Log.logInfo((String)s);
                                }
                                return;
                            }
                        }
                        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)idToConfig[0], null, null);
                        AbstractInterpreterPreferencesPage selectedPage = (AbstractInterpreterPreferencesPage)((Object)dialog.getSelectedPage());
                        selectedPage.setDefaultProjectLocation((String)getProjectLocation.call());
                        dialog.open();
                        this.updateInterpretersAndDefaultInCombo();
                    } else {
                        MessageDialog mdialog = new MessageDialog(null, "Configure interpreter", null, "How would you like to configure the interpreter?", 3, InterpreterConfigHelpers.CONFIG_NAMES_FOR_FIRST_INTERPRETER, 0);
                        int open = mdialog.open();
                        if (open == 0) {
                            PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn(null, (String)idToConfig[0], null, null);
                            dialog.open();
                            this.updateInterpretersAndDefaultInCombo();
                        } else if (open != -1) {
                            interpreterNoteText.setText("Configuration in progress...");
                            IInterpreterProviderFactory.InterpreterType interpreterType = this.getInterpreterType();
                            boolean advanced = open == 2;
                            AutoConfigMaker a = new AutoConfigMaker(interpreterType, advanced, null, null);
                            if (a.autoConfigSingleApply(this.createOnJobComplete())) {
                                this.triggerCallback();
                            } else {
                                this.updateInterpretersAndDefaultInCombo();
                            }
                        }
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            Composite composite = new Composite(topComp, 0);
            composite.setLayout((Layout)new GridLayout(2, false));
            this.labelAdditionalGrammarsSelected = new Label(composite, 0);
            this.labelAdditionalGrammarsSelected.setText(PyProjectPythonDetails.ADDITIONAL_SYNTAX_NO_SELECTED);
            gd = new GridData(768);
            this.labelAdditionalGrammarsSelected.setLayoutData((Object)gd);
            Button button = new Button(composite, 8);
            button.setText("...");
            gd = new GridData();
            button.setLayoutData((Object)gd);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ArrayList<String> grammarversionsrep = new ArrayList<String>(IGrammarVersionProvider.grammarVersionsRep);
                    String NO_VALIDATION = "No additional syntax validation";
                    grammarversionsrep.add("No additional syntax validation");
                    Object[] selected = SelectNDialog.selectMulti(grammarversionsrep, new LabelProvider(), "Select additional grammars for syntax validation");
                    if (ArrayUtils.contains((Object[])selected, (Object)"No additional syntax validation")) {
                        selected = null;
                    }
                    if (selected == null || selected.length == 0) {
                        labelAdditionalGrammarsSelected.setText(PyProjectPythonDetails.ADDITIONAL_SYNTAX_NO_SELECTED);
                    } else {
                        labelAdditionalGrammarsSelected.setText(PyProjectPythonDetails.ADDITIONAL_SYNTAX_PREFIX + StringUtils.join((String)", ", (String[])selected));
                    }
                }
            });
            gd = new GridData(768);
            composite.setLayoutData((Object)gd);
            return topComp;
        }

        private void triggerCallback() {
            if (this.onSelectionChanged != null) {
                try {
                    this.onSelectionChanged.call();
                }
                catch (Exception e1) {
                    Log.log((Throwable)e1);
                }
            }
        }

        public String getSelectedPythonOrJythonAndGrammarVersion() {
            if (this.radioPy.getSelection()) {
                return "python " + this.getGrammarVersionSelectedFromCombo();
            }
            if (this.radioJy.getSelection()) {
                return "jython " + this.getGrammarVersionSelectedFromCombo();
            }
            if (this.radioIron.getSelection()) {
                return "ironpython " + this.getGrammarVersionSelectedFromCombo();
            }
            throw new RuntimeException("Some radio must be selected");
        }

        private String getGrammarVersionSelectedFromCombo() {
            String ret = this.comboGrammarVersion.getText();
            ret = PyProjectPythonDetails.numberFromUi(ret);
            return ret;
        }

        public String getProjectInterpreter() {
            if (INTERPRETER_NOT_CONFIGURED_MSG.equals(this.interpreterNoteText.getText())) {
                return null;
            }
            String ret = this.interpretersChoice.getText();
            if (ret.startsWith(DEFAULT_PREFIX)) {
                return "Default";
            }
            return ret;
        }

        public void setDefaultSelection() {
            this.radioPy.setSelection(true);
            this.comboGrammarVersion.setText(PyProjectPythonDetails.numberToUi("interpreter"));
            this.selectionListener.widgetSelected(null);
        }

        public String getAdditionalGrammarValidation() {
            String text = this.labelAdditionalGrammarsSelected.getText();
            if (text.equals(PyProjectPythonDetails.ADDITIONAL_SYNTAX_NO_SELECTED)) {
                return null;
            }
            return text.substring(PyProjectPythonDetails.ADDITIONAL_SYNTAX_PREFIX.length());
        }

        private IInterpreterManager getInterpreterManager() {
            IInterpreterManager interpreterManager = this.radioJy.getSelection() ? InterpreterManagersAPI.getJythonInterpreterManager() : (this.radioIron.getSelection() ? InterpreterManagersAPI.getIronpythonInterpreterManager() : InterpreterManagersAPI.getPythonInterpreterManager());
            return interpreterManager;
        }

        private IInterpreterProviderFactory.InterpreterType getInterpreterType() {
            IInterpreterProviderFactory.InterpreterType interpreterType = this.radioJy.getSelection() ? IInterpreterProviderFactory.InterpreterType.JYTHON : (this.radioIron.getSelection() ? IInterpreterProviderFactory.InterpreterType.IRONPYTHON : IInterpreterProviderFactory.InterpreterType.PYTHON);
            return interpreterType;
        }

        private void updateInterpretersAndDefaultInCombo() {
            this.selectionListener.widgetSelected(null);
        }

        private JobChangeAdapter createOnJobComplete() {
            JobChangeAdapter onJobComplete = new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!interpreterNoteText.isDisposed()) {
                                this.updateInterpretersAndDefaultInCombo();
                            }
                        }
                    });
                }
            };
            return onJobComplete;
        }
    }
}

