/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.ui.ViewPartWithOrientation;

public class SetOrientationAction
extends Action {
    private WeakReference<ViewPartWithOrientation> view;

    public SetOrientationAction(ViewPartWithOrientation view) {
        this.view = new WeakReference<ViewPartWithOrientation>(view);
        this.setMenuCreator(new SetOrientationMenuCreator());
        this.setText("Orientation");
        this.setToolTipText("Update orientation");
    }

    public static interface IActionsMenu {
        public void add(IAction var1);
    }

    public class SetOrientationActionImpl
    extends Action {
        private ViewPartWithOrientation viewPartWithOrientation;
        private int setsValue;

        public SetOrientationActionImpl(ViewPartWithOrientation viewPartWithOrientation, String text, int setsValue) {
            this.setText(text);
            this.viewPartWithOrientation = viewPartWithOrientation;
            this.setsValue = setsValue;
            this.updateCheck();
        }

        public void updateCheck() {
            boolean check = this.setsValue == this.viewPartWithOrientation.getOrientationPreferenceValue();
            this.setChecked(check);
        }

        public void run() {
            PyDevUiPrefs.getPreferenceStore().setValue(this.viewPartWithOrientation.getOrientationPreferencesKey(), this.setsValue);
        }
    }

    public class SetOrientationMenuCreator
    implements IMenuCreator {
        private Menu fMenu;
        private List<ActionContributionItem> fActions;

        public void dispose() {
            if (this.fMenu != null) {
                this.fMenu.dispose();
                this.fMenu = null;
            }
        }

        public Menu getMenu(Control parent) {
            return null;
        }

        public Menu getMenu(Menu parent) {
            this.dispose();
            this.fMenu = new Menu(parent);
            this.fMenu.addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    List<ActionContributionItem> lst = SetOrientationMenuCreator.this.fActions;
                    int len = lst.size();
                    int i = 0;
                    while (i < len) {
                        ActionContributionItem actionContributionItem = lst.get(i);
                        SetOrientationActionImpl action = (SetOrientationActionImpl)actionContributionItem.getAction();
                        action.updateCheck();
                        ++i;
                    }
                }

                public void menuHidden(MenuEvent e) {
                }
            });
            if (SetOrientationAction.this.view == null) {
                return this.fMenu;
            }
            ViewPartWithOrientation viewPartWithOrientation = (ViewPartWithOrientation)((Object)SetOrientationAction.this.view.get());
            if (viewPartWithOrientation == null) {
                return this.fMenu;
            }
            ArrayList<ActionContributionItem> lst = new ArrayList<ActionContributionItem>();
            ActionContributionItem item = new ActionContributionItem((IAction)new SetOrientationActionImpl(viewPartWithOrientation, "Automatic", 0));
            lst.add(item);
            item = new ActionContributionItem((IAction)new SetOrientationActionImpl(viewPartWithOrientation, "Horizontal", 1));
            lst.add(item);
            item = new ActionContributionItem((IAction)new SetOrientationActionImpl(viewPartWithOrientation, "Vertical", 2));
            lst.add(item);
            this.fActions = lst;
            int len = lst.size();
            int i = 0;
            while (i < len) {
                lst.get(i).fill(this.fMenu, i);
                ++i;
            }
            return this.fMenu;
        }
    }
}

