/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import java.io.File;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FullRepIterable;
import org.python.pydev.shared_core.structure.Tuple;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.ui.dialogs.AbstractKeyValueDialog;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;
import org.python.pydev.ui.pythonpathconf.InterpreterConfigHelpers;

public class InterpreterInputDialog
extends AbstractKeyValueDialog {
    private AbstractInterpreterEditor editor;
    private boolean autoPressBrowse;

    public InterpreterInputDialog(Shell shell, String dialogTitle, String dialogMessage, AbstractInterpreterEditor editor) {
        super(shell, dialogTitle, dialogMessage);
        this.editor = editor;
    }

    public void setAutoPressBrowse(boolean autoPressBrowse) {
        this.autoPressBrowse = autoPressBrowse;
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        if (this.autoPressBrowse) {
            RunInUiThread.async(() -> this.browserButton.notifyListeners(13, new Event()), (boolean)false);
        }
    }

    @Override
    protected String getInitialMessage() {
        return "Please supply a name and executable for your interpreter";
    }

    @Override
    protected String getValueLabelText() {
        return "Interpreter Executable: ";
    }

    @Override
    protected String getKeyLabelText() {
        return "Interpreter Name: ";
    }

    @Override
    protected Listener createChangesValidator() {
        return new Listener(){

            public void handleEvent(Event event) {
                File file;
                String errorMessage = null;
                String interpreterName = InterpreterInputDialog.this.keyField.getText().trim();
                if (interpreterName.equals("")) {
                    errorMessage = "The interpreter name must be specified";
                }
                String executableOrJar = InterpreterInputDialog.this.valueField.getText().trim();
                if (errorMessage == null && executableOrJar.equals("")) {
                    errorMessage = "The interpreter location must be specified";
                }
                if (errorMessage == null && !FileUtils.enhancedIsFile((File)(file = new File(executableOrJar)))) {
                    errorMessage = "Invalid interpreter";
                }
                if (errorMessage == null) {
                    errorMessage = InterpreterConfigHelpers.getDuplicatedMessageError(interpreterName, executableOrJar, InterpreterInputDialog.this.editor.getNameToInfo());
                }
                InterpreterInputDialog.this.setErrorMessage(errorMessage);
            }
        };
    }

    @Override
    public Tuple<String, String> getKeyAndValueEntered() {
        Tuple<String, String> keyAndValueEntered = super.getKeyAndValueEntered();
        if (keyAndValueEntered != null) {
            keyAndValueEntered.o2 = FileUtils.getFileAbsolutePathNotFollowingLinks((File)new File(this.finalValueValue));
        }
        return keyAndValueEntered;
    }

    @Override
    protected String handleBrowseButton() {
        FileDialog dialog = new FileDialog(this.getShell(), 4096);
        String[] filterExtensions = this.editor.getInterpreterFilterExtensions();
        if (filterExtensions != null) {
            dialog.setFilterExtensions(filterExtensions);
        }
        String file = dialog.open();
        return file;
    }

    @Override
    protected void setValueField(String file) {
        if (this.keyField.getText().trim().equals("")) {
            this.keyField.setText(FullRepIterable.getWithoutLastPart((String)new File(file).getName()));
        }
        super.setValueField(file);
    }
}

