/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.dialogs.Package;
import org.python.pydev.ui.dialogs.SourceFolder;

class PackageContentProvider
implements ITreeContentProvider {
    private IWorkspaceRoot workspaceRoot;
    private boolean selectOnlySourceFolders;

    public PackageContentProvider(boolean selectOnlySourceFolders) {
        this.selectOnlySourceFolders = selectOnlySourceFolders;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IWorkspaceRoot) {
            IProject[] projects;
            this.workspaceRoot = (IWorkspaceRoot)parentElement;
            ArrayList<IProject> ret = new ArrayList<IProject>();
            IProject[] iProjectArray = projects = this.workspaceRoot.getProjects();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                PythonNature nature = PythonNature.getPythonNature((IProject)project);
                if (nature != null) {
                    ret.add(project);
                }
                ++n2;
            }
            return ret.toArray(new IProject[0]);
        }
        if (parentElement instanceof IProject) {
            ArrayList<SourceFolder> ret = new ArrayList<SourceFolder>();
            IProject project = (IProject)parentElement;
            IPythonPathNature nature = PythonNature.getPythonPathNature((IProject)project);
            if (nature != null) {
                try {
                    String[] srcPaths;
                    String[] stringArray = srcPaths = PythonNature.getStrAsStrItems((String)nature.getProjectSourcePath(true));
                    int n = srcPaths.length;
                    int n3 = 0;
                    while (n3 < n) {
                        IFolder folder;
                        String str = stringArray[n3];
                        IResource resource = this.workspaceRoot.findMember((IPath)new Path(str));
                        if (resource instanceof IFolder && (folder = (IFolder)resource).exists() && folder != null) {
                            ret.add(new SourceFolder((IContainer)folder));
                        }
                        if (resource instanceof IProject && (folder = (IProject)resource).exists() && folder != null) {
                            ret.add(new SourceFolder((IContainer)folder));
                        }
                        ++n3;
                    }
                    return ret.toArray();
                }
                catch (CoreException e) {
                    Log.log((Throwable)e);
                }
            }
        }
        SourceFolder sourceFolder = null;
        if (parentElement instanceof SourceFolder) {
            sourceFolder = (SourceFolder)parentElement;
            parentElement = ((SourceFolder)parentElement).folder;
        }
        if (parentElement instanceof Package) {
            sourceFolder = ((Package)parentElement).sourceFolder;
            parentElement = ((Package)parentElement).folder;
        }
        if (parentElement instanceof IFolder) {
            IFolder f = (IFolder)parentElement;
            ArrayList<Package> ret = new ArrayList<Package>();
            try {
                IResource[] resources;
                IResource[] iResourceArray = resources = f.members();
                int n = resources.length;
                int n4 = 0;
                while (n4 < n) {
                    IResource resource = iResourceArray[n4];
                    if (resource instanceof IFolder) {
                        ret.add(new Package((IFolder)resource, sourceFolder));
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
            }
            return ret.toArray();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof Package) {
            return ((Package)element).sourceFolder;
        }
        if (element instanceof IResource) {
            return ((IResource)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (this.selectOnlySourceFolders && element instanceof SourceFolder) {
            return false;
        }
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

