/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.DrillDownComposite;

public class ProjectFolderSelectionGroup
extends Composite {
    private Listener listener;
    private boolean allowNewContainerName = true;
    private boolean showClosedProjects = true;
    private IContainer selectedContainer;
    private Text containerNameField;
    TreeViewer treeViewer;
    private static final int SIZING_SELECTION_PANE_WIDTH = 320;
    private static final int SIZING_SELECTION_PANE_HEIGHT = 300;
    private IProject project;

    public ProjectFolderSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects, IProject project) {
        this(parent, listener, allowNewContainerName, message, showClosedProjects, 300, project);
    }

    private ProjectFolderSelectionGroup(Composite parent, Listener listener, boolean allowNewContainerName, String message, boolean showClosedProjects, int heightHint, IProject project) {
        super(parent, 0);
        this.project = project;
        this.listener = listener;
        this.allowNewContainerName = allowNewContainerName;
        this.showClosedProjects = showClosedProjects;
        this.createContents(message, heightHint);
    }

    public void containerSelectionChanged(IContainer container) {
        this.selectedContainer = container;
        if (this.allowNewContainerName) {
            if (container == null) {
                this.containerNameField.setText("");
            } else {
                this.containerNameField.setText(container.getFullPath().makeRelative().toString());
            }
        }
        if (this.listener != null) {
            Event changeEvent = new Event();
            changeEvent.type = 13;
            changeEvent.widget = this;
            this.listener.handleEvent(changeEvent);
        }
    }

    public void createContents(String message) {
        this.createContents(message, 300);
    }

    public void createContents(String message, int heightHint) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(1808));
        Label label = new Label((Composite)this, 64);
        label.setText(message);
        label.setFont(this.getFont());
        if (this.allowNewContainerName) {
            this.containerNameField = new Text((Composite)this, 2052);
            this.containerNameField.setLayoutData((Object)new GridData(768));
            this.containerNameField.addListener(24, this.listener);
            this.containerNameField.setFont(this.getFont());
        } else {
            new Label((Composite)this, 0);
        }
        this.createTreeViewer(heightHint);
        Dialog.applyDialogFont((Control)this);
    }

    protected void createTreeViewer(int heightHint) {
        DrillDownComposite drillDown = new DrillDownComposite((Composite)this, 2048);
        GridData spec = new GridData(1808);
        spec.widthHint = 320;
        spec.heightHint = heightHint;
        drillDown.setLayoutData((Object)spec);
        this.treeViewer = new TreeViewer((Composite)drillDown, 0);
        drillDown.setChildTree(this.treeViewer);
        CopiedContainerContentProvider cp = new CopiedContainerContentProvider(){

            @Override
            public Object[] getChildren(Object element) {
                IContainer container;
                if (element instanceof IWorkspace) {
                    return new Object[]{ProjectFolderSelectionGroup.this.project};
                }
                if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
                    try {
                        ArrayList<IResource> children = new ArrayList<IResource>();
                        IResource[] members = container.members();
                        int i = 0;
                        while (i < members.length) {
                            if (members[i].getType() != 1) {
                                children.add(members[i]);
                            }
                            ++i;
                        }
                        return children.toArray();
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                return new Object[0];
            }
        };
        cp.showClosedProjects(this.showClosedProjects);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        this.treeViewer.setSorter(new ViewerSorter());
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                ProjectFolderSelectionGroup.this.containerSelectionChanged((IContainer)selection.getFirstElement());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object item = ((IStructuredSelection)selection).getFirstElement();
                    if (ProjectFolderSelectionGroup.this.treeViewer.getExpandedState(item)) {
                        ProjectFolderSelectionGroup.this.treeViewer.collapseToLevel(item, 1);
                    } else {
                        ProjectFolderSelectionGroup.this.treeViewer.expandToLevel(item, 1);
                    }
                }
            }
        });
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
    }

    public IPath getContainerFullPath() {
        if (this.allowNewContainerName) {
            String pathName = this.containerNameField.getText();
            if (pathName == null || pathName.length() < 1) {
                return null;
            }
            return new Path(pathName).makeAbsolute();
        }
        if (this.selectedContainer == null) {
            return null;
        }
        return this.selectedContainer.getFullPath();
    }

    public void setInitialFocus() {
        if (this.allowNewContainerName) {
            this.containerNameField.setFocus();
        } else {
            this.treeViewer.getTree().setFocus();
        }
    }

    public void setSelectedContainer(IContainer container) {
        this.selectedContainer = container;
        ArrayList<IContainer> itemsToExpand = new ArrayList<IContainer>();
        IContainer parent = container.getParent();
        while (parent != null) {
            itemsToExpand.add(0, parent);
            parent = parent.getParent();
        }
        this.treeViewer.setExpandedElements(itemsToExpand.toArray());
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)container), true);
    }

    public static class CopiedContainerContentProvider
    implements ITreeContentProvider {
        private boolean showClosedProjects = true;

        public void dispose() {
        }

        public Object[] getChildren(Object element) {
            IContainer container;
            if (element instanceof IWorkspace) {
                Object[] allProjects = ((IWorkspace)element).getRoot().getProjects();
                if (this.showClosedProjects) {
                    return allProjects;
                }
                ArrayList<Object> accessibleProjects = new ArrayList<Object>();
                int i = 0;
                while (i < allProjects.length) {
                    if (allProjects[i].isOpen()) {
                        accessibleProjects.add(allProjects[i]);
                    }
                    ++i;
                }
                return accessibleProjects.toArray();
            }
            if (element instanceof IContainer && (container = (IContainer)element).isAccessible()) {
                try {
                    ArrayList<IResource> children = new ArrayList<IResource>();
                    IResource[] members = container.members();
                    int i = 0;
                    while (i < members.length) {
                        if (members[i].getType() != 1) {
                            children.add(members[i]);
                        }
                        ++i;
                    }
                    return children.toArray();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object element) {
            return this.getChildren(element);
        }

        public Object getParent(Object element) {
            if (element instanceof IResource) {
                return ((IResource)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void showClosedProjects(boolean show) {
            this.showClosedProjects = show;
        }
    }
}

