/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ListDialog;
import org.python.pydev.ast.interpreter_managers.AbstractInterpreterManager;
import org.python.pydev.ast.interpreter_managers.PyDevCondaPreferences;
import org.python.pydev.ast.package_managers.CondaCore;
import org.python.pydev.ast.package_managers.NameAndExecutable;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.utils.ArrayUtils;
import org.python.pydev.shared_ui.EditorUtils;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.shared_ui.dialogs.DialogHelpers;
import org.python.pydev.shared_ui.utils.RunInUiThread;
import org.python.pydev.shared_ui.utils.UIUtils;
import org.python.pydev.ui.dialogs.ListContentProvider;
import org.python.pydev.ui.pythonpathconf.InterpreterConfigHelpers;
import org.python.pydev.ui.pythonpathconf.conda.CondaConfigDialog;
import org.python.pydev.ui.pythonpathconf.package_manager.CondaPackageManager;

public class PyDialogHelpers {
    public static final int INTERPRETER_CANCEL_CONFIG = -1;
    private static MessageDialog dialog = null;
    private static int enableAskInterpreter = 0;

    public static void openWarning(String title, String message) {
        DialogHelpers.openWarning((String)title, (String)message);
    }

    public static void openCritical(String title, String message) {
        DialogHelpers.openCritical((String)title, (String)message);
    }

    public static boolean openQuestion(String title, String message) {
        return DialogHelpers.openQuestion((String)title, (String)message);
    }

    public static Integer openAskInt(String title, String message, int initial) {
        return DialogHelpers.openAskInt((String)title, (String)message, (int)initial);
    }

    public static int openWarningWithIgnoreToggle(String title, String message, String key) {
        Shell shell = EditorUtils.getShell();
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String val = store.getString(key);
        if (val.trim().length() == 0) {
            val = "prompt";
        }
        if (!val.equals("always")) {
            MessageDialogWithToggle.openWarning((Shell)shell, (String)title, (String)message, (String)"Don't show this message again", (boolean)false, (IPreferenceStore)store, (String)key);
        }
        return 0;
    }

    public static boolean openQuestionWithIgnoreToggle(String title, String message, String key) {
        MessageDialogWithToggle dialog;
        Shell shell = EditorUtils.getShell();
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String val = store.getString(key);
        if (val.trim().length() == 0) {
            val = "prompt";
        }
        return val.equals("always") || (dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)title, (String)message, (String)"Don't show this message again", (boolean)false, (IPreferenceStore)store, (String)key)).getReturnCode() == 2;
    }

    public static int openCriticalWithChoices(String title, String message, String[] choices) {
        Shell shell = EditorUtils.getShell();
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 1, choices, 0);
        return dialog.open();
    }

    public static int openQuestionWithChoices(String title, String message, String ... choices) {
        Shell shell = EditorUtils.getShell();
        MessageDialog dialog = new MessageDialog(shell, title, null, message, 6, choices, 0);
        return dialog.open();
    }

    public static void enableAskInterpreterStep(boolean enable) {
        if ((enableAskInterpreter = Math.min(enableAskInterpreter + (enable ? 1 : -1), 0)) < 0 && dialog != null) {
            dialog.close();
            dialog = null;
        }
    }

    public static int openQuestionConfigureInterpreter(AbstractInterpreterManager m) {
        String key;
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        boolean val = store.getBoolean(key = "NOTIFY_NO_INTERPRETER_" + m.getInterpreterType());
        if (val) {
            String title = m.getInterpreterUIName() + " not configured";
            String message = "It seems that the " + m.getInterpreterUIName() + " interpreter is not currently configured.\n\nHow do you want to proceed?";
            Shell shell = EditorUtils.getShell();
            String[] dialogButtonLabels = (String[])ArrayUtils.concatArrays((Object[][])new String[][]{InterpreterConfigHelpers.CONFIG_NAMES_FOR_FIRST_INTERPRETER, {"Don't ask again"}});
            dialog = new MessageDialog(shell, title, null, message, 3, dialogButtonLabels, 0);
            int open = dialog.open();
            if (dialog != null) {
                dialog = null;
                if (open == dialogButtonLabels.length - 1) {
                    store.setValue(key, false);
                    return -1;
                }
                return open;
            }
        }
        return -1;
    }

    public static NameAndExecutable openCondaInterpreterSelection(Shell parentShell) {
        List<File> envs;
        List nameAndExecutableList;
        File condaExe = PyDevCondaPreferences.getExecutable();
        if (condaExe == null) {
            condaExe = CondaCore.findCondaExecutableInSystem();
        }
        if (condaExe == null) {
            new CondaConfigDialog(parentShell).open();
            condaExe = PyDevCondaPreferences.getExecutable();
            if (condaExe == null) {
                return null;
            }
        }
        if ((nameAndExecutableList = CondaCore.getCondaEnvsAsNameAndExecutable(envs = CondaPackageManager.listCondaEnvironments(condaExe))).size() == 0) {
            PyDialogHelpers.openWarning("Error", "Could not find any Conda environment to choose from.");
            return null;
        }
        Collections.sort(nameAndExecutableList, new Comparator<NameAndExecutable>(){

            @Override
            public int compare(NameAndExecutable o1, NameAndExecutable o2) {
                return o1.name.compareToIgnoreCase(o2.name);
            }
        });
        String title = "Conda interpreter selection";
        String message = "Select an intepreter from the list.";
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/python_16x16.png"));
            }

            public String getText(Object element) {
                if (element != null && element instanceof NameAndExecutable) {
                    NameAndExecutable nameAndExecutable = (NameAndExecutable)element;
                    String name = nameAndExecutable.name;
                    name = StringUtils.truncateIfNeeded((String)name, (int)30);
                    return name + StringUtils.createSpaceString((int)(35 - name.length())) + nameAndExecutable.executable;
                }
                return super.getText(element);
            }
        };
        Font font = null;
        try {
            font = new Font((Device)parentShell.getDisplay(), "Courier New", 10, 0);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        final Font f = font;
        ListDialog d = new ListDialog(parentShell){

            protected Control createDialogArea(Composite container) {
                if (f != null) {
                    container.setFont(f);
                }
                return super.createDialogArea(container);
            }
        };
        IDialogSettings dialogSettings = SharedUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection("org.python.pydev.ui.dialogs.PyDialogHelpers.openCondaInterpreterSelection");
        if (section == null) {
            section = dialogSettings.addNewSection("org.python.pydev.ui.dialogs.PyDialogHelpers.openCondaInterpreterSelection");
        }
        d.setDialogBoundsSettings(section, 3);
        try {
            Object[] result;
            d.setInput((Object)nameAndExecutableList);
            d.setContentProvider((IStructuredContentProvider)new ListContentProvider());
            d.setLabelProvider((ILabelProvider)labelProvider);
            d.setMessage(message);
            d.setTitle(title);
            d.open();
            if (d != null && (result = d.getResult()) != null && result.length == 1 && result[0] instanceof NameAndExecutable) {
                NameAndExecutable nameAndExecutable = (NameAndExecutable)result[0];
                return nameAndExecutable;
            }
        }
        finally {
            if (font != null && !font.isDisposed()) {
                font.dispose();
            }
        }
        return null;
    }

    public static boolean getAskAgainInterpreter(AbstractInterpreterManager m) {
        if (enableAskInterpreter < 0) {
            return false;
        }
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("NOTIFY_NO_INTERPRETER_" + m.getInterpreterType());
    }

    public static void openException(String title, IInterpreterInfo.UnableToFindExecutableException e) {
        ErrorDialog.openError((Shell)UIUtils.getActiveShell(), (String)title, (String)e.getMessage(), (IStatus)new Status(4, PydevPlugin.getPluginID(), e.getMessage(), (Throwable)e));
    }

    public static void showString(String string) {
        RunInUiThread.async(() -> {
            Display disp = Display.getCurrent();
            Shell shell = disp.getActiveShell();
            if (shell == null) {
                shell = new Shell(disp);
            }
            ShowTextDialog showTextDialog = new ShowTextDialog(shell, string);
            showTextDialog.open();
        });
    }

    private static final class ShowTextDialog
    extends Dialog {
        private String message;

        public ShowTextDialog(Shell shell, String message) {
            super(shell);
            this.message = message;
            this.setShellStyle(0xC70 | ShowTextDialog.getDefaultOrientation());
            this.setBlockOnOpen(true);
        }

        protected boolean isResizable() {
            return true;
        }

        protected Point getInitialSize() {
            return new Point(800, 600);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            GridLayout layout = (GridLayout)composite.getLayout();
            layout.numColumns = 1;
            this.createText(composite, this.message, 1);
            return composite;
        }

        private Text createText(Composite composite, String labelMsg, int colSpan) {
            Text text = new Text(composite, 2826);
            GridData gridData = new GridData(1808);
            gridData.horizontalSpan = colSpan;
            text.setLayoutData((Object)gridData);
            text.setText(labelMsg);
            return text;
        }
    }
}

