/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.python.copiedfromeclipsesrc.CopiedWorkbenchLabelProvider;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.ui.dialogs.Package;
import org.python.pydev.ui.dialogs.PackageContentProvider;
import org.python.pydev.ui.dialogs.SourceFolder;

public class PythonPackageSelectionDialog
extends ElementTreeSelectionDialog {
    public boolean selectOnlySourceFolders;

    public PythonPackageSelectionDialog(Shell parent, final boolean selectOnlySourceFolders) {
        super(parent, (ILabelProvider)new CopiedWorkbenchLabelProvider(){

            @Override
            public String getText(Object element) {
                if (element instanceof Package) {
                    element = ((Package)element).folder;
                }
                if (element instanceof SourceFolder) {
                    SourceFolder f = (SourceFolder)element;
                    return f.folder.getProjectRelativePath().toString();
                }
                return super.getText(element);
            }

            @Override
            public Image getImage(Object element) {
                if (element instanceof Package) {
                    element = ((Package)element).folder;
                }
                if (element instanceof SourceFolder) {
                    return ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/packagefolder_obj.gif"));
                }
                return super.getImage(element);
            }
        }, (ITreeContentProvider)new PackageContentProvider(selectOnlySourceFolders));
        this.setAllowMultiple(false);
        this.selectOnlySourceFolders = selectOnlySourceFolders;
        this.setValidator(new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    if (selection[0] instanceof SourceFolder) {
                        SourceFolder folder = (SourceFolder)selection[0];
                        return new Status(0, PydevPlugin.getPluginID(), 0, "Source Folder: " + folder.folder.getProjectRelativePath().toString() + " selected", null);
                    }
                    if (!selectOnlySourceFolders && selection[0] instanceof Package) {
                        Package folder = (Package)selection[0];
                        return new Status(0, PydevPlugin.getPluginID(), 0, "Package: " + folder.folder.getName() + " selected", null);
                    }
                }
                return new Status(4, PydevPlugin.getPluginID(), 4, "No package selected", null);
            }
        });
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
    }
}

