/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.importsconf;

import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.python.pydev.plugin.PyDevUiPrefs;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.shared_core.string.WrapAndCaseUtils;
import org.python.pydev.shared_ui.field_editors.BooleanFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.ComboFieldEditor;
import org.python.pydev.shared_ui.field_editors.CustomStringFieldEditor;
import org.python.pydev.shared_ui.field_editors.FileFieldEditorCustom;
import org.python.pydev.shared_ui.field_editors.LabelFieldEditor;
import org.python.pydev.shared_ui.field_editors.LinkFieldEditor;
import org.python.pydev.shared_ui.field_editors.RadioGroupFieldEditor;
import org.python.pydev.shared_ui.field_editors.ScopedFieldEditorPreferencePage;
import org.python.pydev.shared_ui.field_editors.ScopedPreferencesFieldEditor;

public class ImportsPreferencesPage
extends ScopedFieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditorCustom fromImportsFirstBooleanEditor;
    private ComboFieldEditor importEngineFieldEditor;
    private BooleanFieldEditorCustom deleteUnusedImportsField;
    private BooleanFieldEditorCustom groupImportsField;
    private BooleanFieldEditorCustom multilineImportsField;
    private BooleanFieldEditorCustom sortIndiviualOnGroupedField;
    private RadioGroupFieldEditor breakImportsInMultilineMode;
    private RadioGroupFieldEditor isortFormatterLocation;
    private FileFieldEditorCustom isortFileField;
    private CustomStringFieldEditor isortParameters;
    public static final String[][] SEARCH_FORMATTER_LOCATION_OPTIONS = new String[][]{{"Search in interpreter", "LOCATION_SEARCH"}, {"Specify Location", "LOCATION_SPECIFY"}};

    public ImportsPreferencesPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Imports Preferences");
    }

    protected void createFieldEditors() {
        final Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new LabelFieldEditor("Label_Info_File_Preferences1", WrapAndCaseUtils.wrap((String)"These setting are used whenever imports are managed in the application\n\n", (int)80), p));
        this.importEngineFieldEditor = new ComboFieldEditor("IMPORT_ENGINE", "Select import sort engine to be used", (String[][])new String[][]{{"Pep 8", "IMPORT_ENGINE_PEP_8"}, {"Regular sort", "IMPORT_ENGINE_REGULAR_SORT"}, {"isort", "IMPORT_ENGINE_ISORT"}}, p);
        this.addFieldWithToolTip(this.importEngineFieldEditor, p, "Select which import engine should be used to sort the imports when such an operation is requested.");
        this.isortFormatterLocation = new RadioGroupFieldEditor("ISORT_LOCATION_OPTION", "isort executable", 2, SEARCH_FORMATTER_LOCATION_OPTIONS, p);
        Button[] buttonArray = this.isortFormatterLocation.getRadioButtons();
        int n = buttonArray.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            b.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ImportsPreferencesPage.this.updateEnablement(p, ImportsPreferencesPage.this.importEngineFieldEditor.getComboValue());
                }
            });
            ++n2;
        }
        this.addField((FieldEditor)this.isortFormatterLocation);
        this.isortFileField = new FileFieldEditorCustom("ISORT_FILE_LOCATION", "Location of the isort executable:", p, 1);
        this.addField((FieldEditor)this.isortFileField);
        this.isortParameters = new CustomStringFieldEditor("ISORT_PARAMETERS", "Parameters for isort", p);
        this.addField((FieldEditor)this.isortParameters);
        this.deleteUnusedImportsField = new BooleanFieldEditorCustom("DELETE_UNUSED_IMPORTS", WrapAndCaseUtils.wrap((String)"Delete unused imports?", (int)80), p);
        this.addFieldWithToolTip(this.deleteUnusedImportsField, p, "Simple unused imports as reported by the code analysis are deleted. This can be configured to ignore certain files, and individual warnings can be surpressed.");
        this.groupImportsField = new BooleanFieldEditorCustom("GROUP_IMPORTS", "Combine 'from' imports when possible?", p);
        this.addField((FieldEditor)this.groupImportsField);
        this.fromImportsFirstBooleanEditor = new BooleanFieldEditorCustom("FROM_IMPORTS_FIRST", "Sort 'from' imports before 'import' imports?", p);
        this.addField((FieldEditor)this.fromImportsFirstBooleanEditor);
        this.multilineImportsField = new BooleanFieldEditorCustom("MULTILINE_IMPORTS", WrapAndCaseUtils.wrap((String)"Allow multiline imports when the import size would exceed the print margin?", (int)80), p);
        this.addField((FieldEditor)this.multilineImportsField);
        this.sortIndiviualOnGroupedField = new BooleanFieldEditorCustom("SORT_NAMES_GROUPED", WrapAndCaseUtils.wrap((String)"Sort individual names on grouped imports?", (int)80), p);
        this.addField((FieldEditor)this.sortIndiviualOnGroupedField);
        this.breakImportsInMultilineMode = new RadioGroupFieldEditor("BREAK_IMPORTS_MODE", "How to break imports in multiline?", 1, (String[][])new String[][]{{"Use escape char", "ESCAPE"}, {"Use parenthesis", "PARENTHESIS"}}, p);
        this.addField((FieldEditor)this.breakImportsInMultilineMode);
        this.updateEnablement(p, PyDevUiPrefs.getPreferenceStore().getString("IMPORT_ENGINE"));
        Combo importEngineCombo = this.importEngineFieldEditor.getCombo();
        importEngineCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ImportsPreferencesPage.this.updateEnablement(p, ImportsPreferencesPage.this.importEngineFieldEditor.getComboValue());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addField((FieldEditor)new LinkFieldEditor("link_saveactions", "\nNote: view <a>save actions</a> to automatically sort imports on save.", p, new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "org.python.pydev.editor.saveactions.PydevSaveActionsPrefPage";
                IWorkbenchPreferenceContainer workbenchPreferenceContainer = (IWorkbenchPreferenceContainer)ImportsPreferencesPage.this.getContainer();
                workbenchPreferenceContainer.openPage(id, null);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        }));
        this.addField((FieldEditor)new ScopedPreferencesFieldEditor(p, "org.python.pydev", (ScopedFieldEditorPreferencePage)this));
    }

    private void updateEnablement(Composite p, String importEngine) {
        boolean isIsort = importEngine.equals("IMPORT_ENGINE_ISORT");
        this.isortParameters.setVisible(isIsort, p);
        this.isortFileField.setVisible(isIsort);
        this.isortFormatterLocation.setVisible(isIsort, p);
        switch (importEngine) {
            case "IMPORT_ENGINE_PEP_8": {
                this.fromImportsFirstBooleanEditor.setVisible(true, p);
                this.deleteUnusedImportsField.setVisible(true, p);
                this.groupImportsField.setVisible(true, p);
                this.multilineImportsField.setVisible(true, p);
                this.sortIndiviualOnGroupedField.setVisible(true, p);
                this.breakImportsInMultilineMode.setVisible(true, p);
                break;
            }
            case "IMPORT_ENGINE_REGULAR_SORT": {
                this.fromImportsFirstBooleanEditor.setVisible(false, p);
                this.deleteUnusedImportsField.setVisible(true, p);
                this.groupImportsField.setVisible(true, p);
                this.multilineImportsField.setVisible(true, p);
                this.sortIndiviualOnGroupedField.setVisible(true, p);
                this.breakImportsInMultilineMode.setVisible(true, p);
                break;
            }
            case "IMPORT_ENGINE_ISORT": {
                this.fromImportsFirstBooleanEditor.setVisible(false, p);
                this.deleteUnusedImportsField.setVisible(false, p);
                this.groupImportsField.setVisible(false, p);
                this.multilineImportsField.setVisible(false, p);
                this.sortIndiviualOnGroupedField.setVisible(false, p);
                this.breakImportsInMultilineMode.setVisible(false, p);
            }
        }
        p.getParent().layout(true);
    }

    private void addFieldWithToolTip(BooleanFieldEditorCustom editor, Composite p, String tip) {
        this.addField((FieldEditor)editor);
        editor.getDescriptionControl(p).setToolTipText(tip);
    }

    private void addFieldWithToolTip(ComboFieldEditor editor, Composite p, String tip) {
        this.addField((FieldEditor)editor);
        editor.getLabelControl(p).setToolTipText(tip);
    }

    public void init(IWorkbench workbench) {
    }
}

