/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.pydev.ast.package_managers.NameAndExecutable;
import org.python.pydev.ast.runners.SimpleJythonRunner;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.plugin.nature.PipenvHelper;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.shared_core.SharedCorePlugin;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_ui.utils.AsynchronousProgressMonitorDialog;
import org.python.pydev.ui.dialogs.PyDialogHelpers;
import org.python.pydev.ui.pythonpathconf.ObtainInterpreterInfoOperation;
import org.python.pydev.ui.pythonpathconf.PipenvDialog;
import org.python.pydev.ui.pythonpathconf.package_manager.PipenvPackageManager;

public class InterpreterConfigHelpers {
    public static final int CONFIG_MANUAL = 0;
    public static final int CONFIG_AUTO = 1;
    public static final int CONFIG_ADV_AUTO = 2;
    public static final int CONFIG_PIPENV = 3;
    public static final int CONFIG_CONDA = 4;
    public static final String CONFIG_MANUAL_CONFIG = "Manual &config";
    public static final String CONFIG_AUTO_NAME = "Config &first in PATH";
    public static final String CONFIG_ADV_AUTO_NAME = "Choose from &list";
    public static final String CONFIG_PIPENV_NAME = "&New with Pipenv";
    public static final String CONFIG_CONDA_NAME = "Choose from &Conda";
    public static final String[] CONFIG_NAMES_FOR_FIRST_INTERPRETER = new String[]{"Manual &config", "Config &first in PATH", "Choose from &list"};
    public static final String ERMSG_NOLIBS = "The interpreter's standard libraries (typically in a Lib/ folder) are missing: ";

    static ObtainInterpreterInfoOperation tryInterpreter(NameAndExecutable interpreterNameAndExecutable, IInterpreterManager interpreterManager, boolean autoSelectFolders, boolean displayErrors, PrintWriter logger, Shell shell) throws Exception {
        String executableOrJar = interpreterNameAndExecutable.getExecutableOrJar();
        File file = new File(executableOrJar);
        boolean isConda = false;
        try {
            isConda = new File(file.getParentFile(), "conda-meta").exists();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return InterpreterConfigHelpers.tryInterpreter(interpreterNameAndExecutable, interpreterManager, autoSelectFolders, displayErrors, logger, shell, isConda);
    }

    static ObtainInterpreterInfoOperation tryInterpreter(NameAndExecutable interpreterNameAndExecutable, IInterpreterManager interpreterManager, boolean autoSelectFolders, boolean displayErrors, PrintWriter logger, Shell shell, boolean isConda) throws Exception {
        ObtainInterpreterInfoOperation operation;
        block28: {
            String executable;
            block29: {
                int choice;
                executable = interpreterNameAndExecutable.executable;
                logger.println("- Ok, file is non-null. Getting info on:" + executable);
                AsynchronousProgressMonitorDialog monitorDialog = new AsynchronousProgressMonitorDialog(shell);
                monitorDialog.setBlockOnOpen(false);
                do {
                    operation = new ObtainInterpreterInfoOperation(interpreterNameAndExecutable.executable, logger, interpreterManager, autoSelectFolders, isConda);
                    monitorDialog.run(true, false, (IRunnableWithProgress)operation);
                    if (operation.e != null) {
                        logger.println("- Some error happened while getting info on the interpreter:");
                        operation.e.printStackTrace(logger);
                        String errorTitle = "Unable to get info on the interpreter: " + executable;
                        if (operation.e instanceof SimpleJythonRunner.JavaNotConfiguredException) {
                            SimpleJythonRunner.JavaNotConfiguredException javaNotConfiguredException = (SimpleJythonRunner.JavaNotConfiguredException)operation.e;
                            if (displayErrors) {
                                ErrorDialog.openError((Shell)shell, (String)errorTitle, (String)javaNotConfiguredException.getMessage(), (IStatus)SharedCorePlugin.makeStatus((int)4, (String)"Java vm not configured.\n", (Throwable)javaNotConfiguredException));
                            }
                            throw new Exception((Throwable)javaNotConfiguredException);
                        }
                        if (operation.e instanceof JDTNotAvailableException) {
                            JDTNotAvailableException noJdtException = (JDTNotAvailableException)operation.e;
                            if (displayErrors) {
                                ErrorDialog.openError((Shell)shell, (String)errorTitle, (String)noJdtException.getMessage(), (IStatus)SharedCorePlugin.makeStatus((int)4, (String)"JDT not available.\n", (Throwable)noJdtException));
                            }
                            throw new Exception((Throwable)noJdtException);
                        }
                        if (displayErrors) {
                            String errorMsg = "Unable to get info on the interpreter: " + executable + "\n\nCommon reasons include:\n\n- Using an unsupported version\n  (Python and Jython require at least version 2.1 and IronPython 2.6).\n\n- Specifying an invalid interpreter\n  (usually a link to the actual interpreter on Mac or Linux)";
                            ErrorDialog.openError((Shell)shell, (String)errorTitle, (String)errorMsg, (IStatus)SharedCorePlugin.makeStatus((int)4, (String)"See error log for details.", (Throwable)operation.e));
                        }
                        throw new Exception(operation.e);
                    }
                    if (operation.result == null) {
                        return null;
                    }
                    HashSet<String> hashSet = new HashSet<String>();
                    hashSet.add("threading");
                    hashSet.add("traceback");
                    String[] validSourceFiles = FileTypesPreferences.getValidSourceFiles();
                    HashSet<String> extensions = new HashSet<String>(Arrays.asList(validSourceFiles));
                    for (String s : operation.result.libs) {
                        File file = new File(s);
                        if (file.isDirectory()) {
                            String[] directoryFiles = file.list();
                            if (directoryFiles != null) {
                                String[] stringArray = directoryFiles;
                                int n = directoryFiles.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String found = stringArray[n2];
                                    List split = StringUtils.split((String)found, (char)'.');
                                    if (split.size() == 2 && extensions.contains(split.get(1))) {
                                        hashSet.remove(split.get(0));
                                    }
                                    ++n2;
                                }
                                continue;
                            }
                            logger.append("Warning: unable to get contents of directory: " + String.valueOf(file) + " (permission not available, it's not a dir or dir does not exist).");
                            continue;
                        }
                        if (!file.isFile()) continue;
                        try {
                            Throwable throwable = null;
                            Object var17_20 = null;
                            try (ZipFile zipFile = new ZipFile(file);){
                                String[] stringArray = validSourceFiles;
                                int n = validSourceFiles.length;
                                int n3 = 0;
                                while (n3 < n) {
                                    String extension = stringArray[n3];
                                    if (zipFile.getEntry("threading." + extension) != null) {
                                        hashSet.remove("threading");
                                    }
                                    if (zipFile.getEntry("traceback." + extension) != null) {
                                        hashSet.remove("traceback");
                                    }
                                    ++n3;
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (hashSet.size() <= 0) break block28;
                    if (!displayErrors) break block29;
                } while ((choice = PyDialogHelpers.openCriticalWithChoices("Error: Python stdlib source files not found.", "Error: Python stdlib not found or stdlib found without .py files.\n\nIt seems that the Python /Lib folder (which contains the standard library) was not found/selected during the install process or the stdlib does not contain the required .py files (i.e.: only has .pyc files).\n\nThis folder (which contains files such as threading.py and traceback.py) is required for PyDev to function properly, and it must contain the actual source files, not only .pyc files. if you don't have the .py files in your install, please use an install from python.org or grab the standard library for your install from there.\n\nIf this is a virtualenv install, the /Lib folder from the base install needs to be selected (unlike the site-packages which is optional).\n\nWhat do you want to do?\n\nNote: if you choose to proceed, the /Lib with the standard library .py source files must be added later on, otherwise PyDev may not function properly.", new String[]{"Re-select folders", "Cancel", "Proceed anyways"})) == 0);
                if (choice == 1) {
                    return null;
                }
                break block28;
            }
            logger.println("- Could not find /Lib folder, exiting with error.");
            throw new Exception(ERMSG_NOLIBS + executable);
        }
        operation.result.setName(interpreterNameAndExecutable.name);
        logger.println("- Success getting the info. Result:" + String.valueOf(operation.result));
        return operation;
    }

    static boolean checkInterpreterNameAndExecutable(NameAndExecutable interpreterNameAndExecutable, PrintWriter logger, String errorMsg, Map<String, IInterpreterInfo> nameToInfo, Shell shell) {
        String error;
        boolean foundError = false;
        if (interpreterNameAndExecutable == null) {
            logger.println("- When trimmed, the chosen file was null (returning null).");
            if (shell != null) {
                ErrorDialog.openError((Shell)shell, (String)errorMsg, (String)"interpreterNameAndExecutable == null", (IStatus)SharedCorePlugin.makeStatus((int)4, (String)"interpreterNameAndExecutable == null", (Throwable)new RuntimeException()));
            }
            foundError = true;
        }
        if (!foundError && interpreterNameAndExecutable.executable.trim().length() == 0) {
            logger.println("- When trimmed, the chosen file was empty (returning null).");
            if (shell != null) {
                ErrorDialog.openError((Shell)shell, (String)errorMsg, (String)"interpreterNameAndExecutable size == empty", (IStatus)SharedCorePlugin.makeStatus((int)4, (String)"interpreterNameAndExecutable size == empty", (Throwable)new RuntimeException()));
            }
            foundError = true;
        }
        if (!foundError && nameToInfo != null && (error = InterpreterConfigHelpers.getDuplicatedMessageError(interpreterNameAndExecutable.name, interpreterNameAndExecutable.executable, nameToInfo)) != null) {
            logger.println("- Duplicated interpreter found.");
            if (shell != null) {
                ErrorDialog.openError((Shell)shell, (String)errorMsg, (String)error, (IStatus)SharedCorePlugin.makeStatus((int)4, (String)"Duplicated interpreter information", (Throwable)new RuntimeException()));
            }
            foundError = true;
        }
        return foundError;
    }

    public static String getUniqueInterpreterName(String expectedName, Map<String, IInterpreterInfo> nameToInfo) {
        if (nameToInfo == null) {
            return expectedName;
        }
        String additional = "";
        int i = 0;
        while (InterpreterConfigHelpers.getDuplicatedMessageError(expectedName + additional, null, nameToInfo) != null) {
            additional = String.valueOf(++i);
        }
        return expectedName + additional;
    }

    public static String getDuplicatedMessageError(String interpreterName, String executableOrJar, Map<String, IInterpreterInfo> nameToInfo) {
        if (nameToInfo == null) {
            return null;
        }
        String error = null;
        if (interpreterName != null && nameToInfo.containsKey(interpreterName = interpreterName.trim())) {
            error = "An interpreter is already configured with the name: " + interpreterName;
        }
        if (executableOrJar != null) {
            executableOrJar = executableOrJar.trim();
            for (IInterpreterInfo info : nameToInfo.values()) {
                if (!info.getExecutableOrJar().trim().equals(executableOrJar)) continue;
                error = "An interpreter is already configured with the path: " + executableOrJar;
            }
        }
        return error;
    }

    public static boolean canAddNameAndExecutable(PrintWriter logger, NameAndExecutable interpreterNameAndExecutable, Map<String, IInterpreterInfo> nameToInfo, Shell shell) {
        interpreterNameAndExecutable.name = InterpreterConfigHelpers.getUniqueInterpreterName(interpreterNameAndExecutable.name, nameToInfo);
        boolean foundError = InterpreterConfigHelpers.checkInterpreterNameAndExecutable(interpreterNameAndExecutable, logger, "Error getting info on interpreter", nameToInfo, shell);
        return foundError;
    }

    public static ObtainInterpreterInfoOperation createPipenvInterpreter(IInterpreterInfo[] interpreterInfos, Shell shell, PrintWriter logger, Map<String, IInterpreterInfo> nameToInfo, String defaultProjectLocation, IInterpreterManager interpreterManager) throws Exception {
        if (logger == null) {
            logger = new PrintWriter(new ByteArrayOutputStream());
        }
        if (interpreterInfos == null || interpreterInfos.length == 0) {
            PyDialogHelpers.openCritical("Unable to configure with pipenv", "Cannot configure with pipenv without a base interpreter configured. Please configure the base interpreter first.");
            return null;
        }
        PipenvDialog pipenvDialog = new PipenvDialog(shell, interpreterInfos, null, defaultProjectLocation, interpreterManager, "New Pipenv interpreter", true);
        if (pipenvDialog.open() == 0) {
            IInterpreterInfo baseInterpreter = pipenvDialog.getBaseInterpreter();
            String executableOrJar = baseInterpreter.getExecutableOrJar();
            String pipenvLocation = pipenvDialog.getPipenvLocation();
            String projectLocation = pipenvDialog.getProjectLocation();
            SystemPythonNature nature = new SystemPythonNature(interpreterManager, baseInterpreter);
            File pythonVenvFromLocation = PipenvHelper.getPythonExecutableFromProjectLocationWithPipenv((String)pipenvLocation, (File)new File(projectLocation));
            if (pythonVenvFromLocation == null) {
                PipenvPackageManager.create(executableOrJar, pipenvLocation, projectLocation, nature);
                pythonVenvFromLocation = PipenvHelper.getPythonExecutableFromProjectLocationWithPipenv((String)pipenvLocation, (File)new File(projectLocation));
            }
            if (pythonVenvFromLocation != null) {
                NameAndExecutable interpreterNameAndExecutable = new NameAndExecutable(new File(projectLocation).getName() + " (pipenv)", pythonVenvFromLocation.getAbsolutePath());
                boolean foundError = InterpreterConfigHelpers.canAddNameAndExecutable(logger, interpreterNameAndExecutable, nameToInfo, shell);
                if (foundError) {
                    return null;
                }
                logger.println("- Chosen interpreter (name and file):'" + String.valueOf(interpreterNameAndExecutable));
                if (interpreterNameAndExecutable != null && interpreterNameAndExecutable.executable != null) {
                    ObtainInterpreterInfoOperation ret = InterpreterConfigHelpers.tryInterpreter(interpreterNameAndExecutable, interpreterManager, false, true, logger, shell);
                    if (ret != null && ret.result != null) {
                        ret.result.setPipenvTargetDir(projectLocation);
                    }
                    return ret;
                }
            }
        }
        return null;
    }

    public static String getConfigPageIdFromInterpreterType(int interpreterType) {
        return switch (interpreterType) {
            case 0 -> "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPagePython";
            case 1 -> "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPageJython";
            case 2 -> "org.python.pydev.ui.pythonpathconf.interpreterPreferencesPageIronpython";
            default -> throw new RuntimeException("Cannot recognize type: " + interpreterType);
        };
    }
}

