/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import at.jta.Key;
import at.jta.Regor;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.python.pydev.ast.interpreter_managers.IInterpreterProvider;
import org.python.pydev.ast.interpreter_managers.IInterpreterProviderFactory;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.utils.PlatformUtils;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterProviderFactory;
import org.python.pydev.ui.pythonpathconf.AlreadyInstalledInterpreterProvider;

public class PythonInterpreterProviderFactory
extends AbstractInterpreterProviderFactory {
    public IInterpreterProvider[] getInterpreterProviders(IInterpreterProviderFactory.InterpreterType type) {
        if (type != IInterpreterProviderFactory.InterpreterType.PYTHON) {
            return null;
        }
        ArrayList<String> foundVersions = new ArrayList<String>();
        Set pathsToSearch = PythonNature.getPathsToSearch();
        List<String> searchPatterns = PlatformUtils.isWindowsPlatform() ? Arrays.asList("python.exe", "pypy.exe") : Arrays.asList("python", "python\\d(\\.\\d)*|pypy");
        String[] ret = this.searchPaths(pathsToSearch, searchPatterns, false);
        foundVersions.addAll(Arrays.asList(ret));
        if (PlatformUtils.isWindowsPlatform()) {
            try {
                Regor regor = new Regor();
                Key[] keyArray = new Key[]{Regor.HKEY_LOCAL_MACHINE, Regor.HKEY_CURRENT_USER};
                int n = keyArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Key root = keyArray[n2];
                    Key key = regor.openKey(root, "Software\\Python\\PythonCore", 131097);
                    if (key != null) {
                        try {
                            List l = regor.listKeys(key);
                            if (l != null) {
                                for (Object o : l) {
                                    Key openKey = regor.openKey(key, (String)o + "\\InstallPath", 131097);
                                    if (openKey == null) continue;
                                    try {
                                        String parseValue;
                                        File file;
                                        byte[] buf = regor.readValue(openKey, "");
                                        if (buf == null || !(file = new File(parseValue = Regor.parseValue((byte[])buf), "python.exe")).isFile()) continue;
                                        foundVersions.add(file.toString());
                                    }
                                    finally {
                                        regor.closeKey(openKey);
                                    }
                                }
                            }
                        }
                        finally {
                            regor.closeKey(key);
                        }
                    }
                    ++n2;
                }
            }
            catch (Throwable e) {
                Log.log((Throwable)e);
            }
        }
        if (foundVersions.size() > 0) {
            foundVersions = new ArrayList(new LinkedHashSet(foundVersions));
            return AlreadyInstalledInterpreterProvider.create("python", foundVersions.toArray(new String[foundVersions.size()]));
        }
        return AlreadyInstalledInterpreterProvider.create("python", "python");
    }
}

