/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.log.Log;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_ui.ImageCache;
import org.python.pydev.shared_ui.SharedUiPlugin;
import org.python.pydev.ui.dialogs.Package;
import org.python.pydev.ui.dialogs.PythonPackageSelectionDialog;
import org.python.pydev.ui.dialogs.SourceFolder;
import org.python.pydev.ui.wizards.files.PythonExistingSourceGroup;

public abstract class AbstractPythonWizardPage
extends WizardPage
implements KeyListener {
    private IStructuredSelection selection;
    private Text textSourceFolder;
    private Button btBrowseSourceFolder;
    protected Text textPackage;
    private Button btBrowsePackage;
    protected Text textName;
    private String initialTextName = "";
    private PythonExistingSourceGroup existingSourceGroup;
    private IPath sourceToLink;
    private IContainer validatedSourceFolder;
    private IContainer validatedPackage;
    private String packageText;
    private IProject validatedProject;
    private String validatedName;
    private Text textProject;
    private Button btBrowseProject;
    private Text lastWithFocus;
    protected String lastWithFocusStr;
    private Label labelWarningWillCreate;
    private Label labelWarningImageWillCreate;

    public IContainer getValidatedSourceFolder() {
        return this.validatedSourceFolder;
    }

    public IContainer getValidatedPackage() {
        return this.validatedPackage;
    }

    public String getPackageText() {
        return this.packageText;
    }

    public String getValidatedName() {
        return this.validatedName;
    }

    public IProject getValidatedProject() {
        return this.validatedProject;
    }

    public IPath getSourceToLink() {
        return this.sourceToLink;
    }

    protected AbstractPythonWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setPageComplete(false);
        this.selection = selection;
    }

    private void setFocusOn(Text txt, String string) {
        if (txt != null) {
            txt.setFocus();
            this.lastWithFocus = txt;
            this.lastWithFocusStr = string;
        }
    }

    public void resetFocusOnLast() {
        if (this.lastWithFocus != null) {
            this.lastWithFocus.setFocus();
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.resetFocusOnLast();
        }
    }

    public void createControl(Composite parent) {
        Composite topLevel = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        topLevel.setLayout((Layout)gridLayout);
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        boolean previousFilled = true;
        previousFilled = this.shouldCreateSourceFolderSelect() ? this.createSourceFolderSelect(topLevel) : this.createProjectSelect(topLevel);
        boolean createPackageSelectFilled = this.createPackageSelect(topLevel, previousFilled);
        if (this.shouldCreatePackageSelect()) {
            previousFilled = createPackageSelectFilled;
        }
        this.createNameSelect(topLevel, previousFilled);
        if (this.shouldCreateExistingSourceFolderSelect()) {
            Label label = new Label(topLevel, 0);
            this.createSourceListGroup(topLevel);
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    protected boolean shouldCreateSourceFolderSelect() {
        return true;
    }

    protected boolean shouldCreateExistingSourceFolderSelect() {
        return false;
    }

    protected abstract boolean shouldCreatePackageSelect();

    protected void createNameSelect(Composite topLevel, boolean setFocus) {
        this.createNameLabel(topLevel);
        this.textName = new Text(topLevel, 2048);
        this.textName.addKeyListener((KeyListener)this);
        this.setLayout(null, (Control)this.textName, null);
        if (this.initialTextName != null) {
            this.textName.setText(this.initialTextName);
        }
        if (setFocus) {
            this.setFocusOn(this.textName, "name");
            this.textName.setSelection(this.textName.getText().length());
        }
        Label label = new Label(topLevel, 0);
        label.setText("");
    }

    protected Label createNameLabel(Composite topLevel) {
        Label label = new Label(topLevel, 0);
        label.setText("Name");
        GridData data = new GridData();
        data.grabExcessHorizontalSpace = false;
        label.setLayoutData((Object)data);
        return label;
    }

    private boolean createProjectSelect(Composite topLevel) {
        Label label = new Label(topLevel, 0);
        label.setText("Project");
        this.textProject = new Text(topLevel, 2048);
        this.textProject.addKeyListener((KeyListener)this);
        this.btBrowseProject = new Button(topLevel, 0);
        this.setLayout(label, (Control)this.textProject, (Control)this.btBrowseProject);
        this.setFocusOn(this.textProject, "project");
        this.btBrowseProject.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(AbstractPythonWizardPage.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider());
                dialog.setTitle("Project selection");
                dialog.setMessage("Select a project.");
                dialog.setElements((Object[])ResourcesPlugin.getWorkspace().getRoot().getProjects());
                dialog.open();
                Object[] result = dialog.getResult();
                if (result != null && result.length > 0) {
                    AbstractPythonWizardPage.this.textProject.setText(((IProject)result[0]).getName());
                    AbstractPythonWizardPage.this.validatePage();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Object element = this.selection.getFirstElement();
        if (element instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)element;
            element = adaptable.getAdapter(IResource.class);
        }
        if (element instanceof IResource) {
            IResource f = (IResource)element;
            element = f.getProject();
        }
        if (element instanceof IProject) {
            this.textProject.setText(((IProject)element).getName());
            this.validatePage();
            return true;
        }
        return false;
    }

    private boolean createPackageSelect(Composite topLevel, boolean setFocus) {
        block12: {
            String srcPath;
            IFile f;
            block13: {
                IAdaptable adaptable;
                if (this.shouldCreatePackageSelect()) {
                    Label label = new Label(topLevel, 0);
                    label.setText("Package");
                    this.textPackage = new Text(topLevel, 2048);
                    this.textPackage.addKeyListener((KeyListener)this);
                    this.btBrowsePackage = new Button(topLevel, 0);
                    this.setLayout(label, (Control)this.textPackage, (Control)this.btBrowsePackage);
                    this.labelWarningImageWillCreate = new Label(topLevel, 0);
                    this.labelWarningImageWillCreate.setVisible(false);
                    this.labelWarningImageWillCreate.setImage(ImageCache.asImage((IImageHandle)SharedUiPlugin.getImageCache().get("icons/warning.png")));
                    this.labelWarningWillCreate = new Label(topLevel, 0);
                    this.labelWarningWillCreate.setText("Note: package not found (will be created).");
                    this.labelWarningWillCreate.setVisible(false);
                    this.setLayout(this.labelWarningImageWillCreate, (Control)this.labelWarningWillCreate, null);
                    new Label(topLevel, 0);
                    if (setFocus) {
                        this.setFocusOn(this.textPackage, "package");
                    }
                    this.btBrowsePackage.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            try {
                                Object f;
                                PythonPackageSelectionDialog dialog = new PythonPackageSelectionDialog(AbstractPythonWizardPage.this.getShell(), false);
                                dialog.setTitle("Package selection");
                                dialog.setMessage("Select a package (or a source folder). You may also enter the\nname of a new package in the text bar on the previous page.");
                                dialog.open();
                                Object firstResult = dialog.getFirstResult();
                                if (firstResult instanceof SourceFolder) {
                                    f = (SourceFolder)firstResult;
                                    AbstractPythonWizardPage.this.textPackage.setText("");
                                    AbstractPythonWizardPage.this.textSourceFolder.setText(((SourceFolder)f).folder.getFullPath().toString());
                                }
                                if (firstResult instanceof Package) {
                                    f = (Package)firstResult;
                                    AbstractPythonWizardPage.this.textPackage.setText(((Package)f).getPackageName());
                                    AbstractPythonWizardPage.this.textSourceFolder.setText(((Package)f).sourceFolder.folder.getFullPath().toString());
                                }
                            }
                            catch (Exception e1) {
                                Log.log((Throwable)e1);
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                }
                Object element = this.selection.getFirstElement();
                if (element instanceof IAdaptable && (element = (adaptable = (IAdaptable)element).getAdapter(IFile.class)) == null) {
                    element = adaptable.getAdapter(IFolder.class);
                }
                if (element instanceof IFile) {
                    f = (IFile)element;
                    element = f.getParent();
                }
                if (!(element instanceof IFolder)) break block12;
                f = (IFolder)element;
                srcPath = this.getSrcFolderFromFolder((IFolder)f);
                if (srcPath != null) break block13;
                return false;
            }
            try {
                String complete = f.getFullPath().toString();
                if (complete.startsWith(srcPath)) {
                    if ((complete = complete.substring(srcPath.length()).replace('/', '.')).startsWith(".")) {
                        complete = complete.substring(1);
                    }
                    if (this.shouldCreatePackageSelect()) {
                        this.textPackage.setText(complete);
                    } else {
                        this.initialTextName = complete;
                    }
                }
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        if (this.shouldCreatePackageSelect()) {
            return this.textPackage.getText().length() > 0;
        }
        return false;
    }

    private boolean createSourceFolderSelect(Composite topLevel) {
        block9: {
            String srcPath;
            block10: {
                IFile f;
                Object element;
                block8: {
                    String[] srcPaths;
                    IPythonPathNature nature;
                    Label label = new Label(topLevel, 0);
                    label.setText("Source Folder");
                    this.textSourceFolder = new Text(topLevel, 2048);
                    this.textSourceFolder.addKeyListener((KeyListener)this);
                    this.btBrowseSourceFolder = new Button(topLevel, 0);
                    this.setLayout(label, (Control)this.textSourceFolder, (Control)this.btBrowseSourceFolder);
                    this.btBrowseSourceFolder.addSelectionListener(new SelectionListener(){

                        public void widgetSelected(SelectionEvent e) {
                            try {
                                PythonPackageSelectionDialog dialog = new PythonPackageSelectionDialog(AbstractPythonWizardPage.this.getShell(), true);
                                dialog.setTitle("Source folder selection");
                                dialog.setMessage("Select a source folder.");
                                dialog.open();
                                Object firstResult = dialog.getFirstResult();
                                if (firstResult instanceof SourceFolder) {
                                    SourceFolder f = (SourceFolder)firstResult;
                                    AbstractPythonWizardPage.this.textSourceFolder.setText(f.folder.getFullPath().toString());
                                }
                            }
                            catch (Exception e1) {
                                Log.log((Throwable)e1);
                            }
                        }

                        public void widgetDefaultSelected(SelectionEvent e) {
                        }
                    });
                    element = this.selection.getFirstElement();
                    if (element instanceof IAdaptable) {
                        IAdaptable adaptable = (IAdaptable)element;
                        if ((element = adaptable.getAdapter(IFile.class)) == null) {
                            element = adaptable.getAdapter(IProject.class);
                        }
                        if (element == null) {
                            element = adaptable.getAdapter(IFolder.class);
                        }
                    }
                    if (element instanceof IFile) {
                        f = (IFile)element;
                        element = f.getParent();
                    }
                    if (!(element instanceof IProject) || (nature = PythonNature.getPythonPathNature((IProject)((IProject)element))) == null || (srcPaths = PythonNature.getStrAsStrItems((String)nature.getProjectSourcePath(true))).length <= 0) break block8;
                    this.textSourceFolder.setText(srcPaths[0]);
                    return true;
                }
                if (!(element instanceof IFolder)) break block9;
                f = (IFolder)element;
                srcPath = this.getSrcFolderFromFolder((IFolder)f);
                if (srcPath != null) break block10;
                return true;
            }
            try {
                this.textSourceFolder.setText(srcPath);
                return true;
            }
            catch (Exception e) {
                Log.log((Throwable)e);
            }
        }
        return false;
    }

    private void createSourceListGroup(Composite parent) {
        this.existingSourceGroup = new PythonExistingSourceGroup(parent, this.getValidatedProject(), new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AbstractPythonWizardPage.this.sourceToLink = AbstractPythonWizardPage.this.existingSourceGroup.getLinkTarget();
                if (AbstractPythonWizardPage.this.sourceToLink != null) {
                    AbstractPythonWizardPage.this.textName.setText(AbstractPythonWizardPage.this.sourceToLink.lastSegment());
                }
                AbstractPythonWizardPage.this.validatePage();
            }
        });
    }

    public String getSrcFolderFromFolder(IFolder f) throws CoreException {
        IPythonPathNature nature = PythonNature.getPythonPathNature((IProject)f.getProject());
        if (nature != null) {
            String[] srcPaths = PythonNature.getStrAsStrItems((String)nature.getProjectSourcePath(true));
            String relFolder = f.getFullPath().toString() + "/";
            String[] stringArray = srcPaths;
            int n = srcPaths.length;
            int n2 = 0;
            while (n2 < n) {
                String src = stringArray[n2];
                if (relFolder.startsWith(src + "/")) {
                    return src;
                }
                ++n2;
            }
        }
        return null;
    }

    private void setLayout(Label label, Control text, Control bt) {
        GridData data;
        if (label != null) {
            data = new GridData();
            data.grabExcessHorizontalSpace = false;
            label.setLayoutData((Object)data);
        }
        if (text != null) {
            data = new GridData(768);
            data.grabExcessHorizontalSpace = true;
            text.setLayoutData((Object)data);
        }
        if (bt != null) {
            data = new GridData();
            bt.setLayoutData((Object)data);
            if (bt instanceof Button) {
                ((Button)bt).setText("Browse...");
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        this.validatePage();
    }

    protected void validatePage() {
        try {
            if (this.textProject != null && this.checkError(this.checkValidProject(this.textProject.getText()))) {
                return;
            }
            if (this.textSourceFolder != null && this.checkError(this.checkValidSourceFolder(this.textSourceFolder.getText()))) {
                return;
            }
            if (this.textPackage != null && this.checkError(this.checkValidPackage(this.textPackage.getText()))) {
                return;
            }
            if (this.textName != null && this.checkError(this.checkValidName(this.textName.getText()))) {
                return;
            }
            if (this.existingSourceGroup != null && this.checkError(this.checkValidExistingSourceFolder())) {
                return;
            }
            if (this.checkAdditionalErrors()) {
                return;
            }
            this.setErrorMessage(null);
            if (this.getMessage() == null) {
                this.setMessage(this.getDescription());
            }
            this.setPageComplete(true);
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            this.setErrorMessage("Error while validating page:" + e.getMessage());
            this.setPageComplete(false);
        }
    }

    protected boolean checkAdditionalErrors() {
        return false;
    }

    private String checkValidProject(String text) {
        this.validatedProject = null;
        if (text == null || text.trim().length() == 0) {
            return "The project name must be filled.";
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(text);
        if (!project.exists()) {
            return "The project selected does not exist in the workspace.";
        }
        this.validatedProject = project;
        if (this.existingSourceGroup != null) {
            this.existingSourceGroup.setActiveProject(project);
        }
        return null;
    }

    protected boolean checkError(String error) {
        if (error != null) {
            this.setErrorMessage(error);
            this.setPageComplete(false);
            return true;
        }
        return false;
    }

    private String checkValidName(String text) {
        this.validatedName = null;
        String error = this.checkNameText(text);
        if (error != null) {
            return error;
        }
        this.validatedName = text;
        return null;
    }

    protected String checkNameText(String text) {
        char[] invalid;
        if (text == null || text.trim().length() == 0) {
            return "The name must be filled.";
        }
        if (this.shouldCreateSourceFolderSelect()) {
            if (this.validatedSourceFolder == null) {
                return "The source folder was not correctly validated.";
            }
        } else if (this.validatedProject == null) {
            return "The project was not correctly validated.";
        }
        if (this.shouldCreatePackageSelect() && this.validatedPackage == null && this.packageText == null) {
            return "The package was not correctly validated.";
        }
        if (text.indexOf(32) != -1) {
            return "The name may not contain spaces";
        }
        if (this.shouldCreatePackageSelect() && text.indexOf(46) != -1) {
            return "The name may not contain dots";
        }
        char[] cArray = invalid = new char[]{'/', '\\', ',', '*', '(', ')', '{', '}', '[', ']'};
        int n = invalid.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (text.indexOf(c) != -1) {
                return "The name must not contain '" + c + "'.";
            }
            ++n2;
        }
        if (text.endsWith(".")) {
            return "The name may not end with a dot";
        }
        return null;
    }

    protected String checkValidPackage(String text) {
        this.validatedPackage = null;
        this.packageText = null;
        String initialText = text;
        if (text.indexOf(47) != -1) {
            this.labelWarningImageWillCreate.setVisible(false);
            this.labelWarningWillCreate.setVisible(false);
            this.labelWarningWillCreate.getParent().layout();
            return "The package name must not contain '/'.";
        }
        if (text.indexOf(92) != -1) {
            this.labelWarningImageWillCreate.setVisible(false);
            this.labelWarningWillCreate.setVisible(false);
            this.labelWarningWillCreate.getParent().layout();
            return "The package name must not contain '\\'.";
        }
        if (text.endsWith(".")) {
            this.labelWarningImageWillCreate.setVisible(false);
            this.labelWarningWillCreate.setVisible(false);
            this.labelWarningWillCreate.getParent().layout();
            return "The package may not end with a dot";
        }
        text = text.replace('.', '/');
        if (this.validatedSourceFolder == null) {
            this.labelWarningImageWillCreate.setVisible(false);
            this.labelWarningWillCreate.setVisible(false);
            this.labelWarningWillCreate.getParent().layout();
            return "The source folder was not correctly validated.";
        }
        IPath path = this.validatedSourceFolder.getFullPath().append(text);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember(path);
        if (resource == null) {
            this.packageText = initialText;
            this.labelWarningImageWillCreate.setVisible(true);
            this.labelWarningWillCreate.setVisible(true);
            this.labelWarningWillCreate.getParent().layout();
            return null;
        }
        this.labelWarningImageWillCreate.setVisible(false);
        this.labelWarningWillCreate.setVisible(false);
        this.labelWarningWillCreate.getParent().layout();
        if (!(resource instanceof IContainer)) {
            return "The resource found for the package is not a valid container.";
        }
        if (!resource.exists()) {
            return "The package selected does not exist in the filesystem.";
        }
        this.validatedPackage = (IContainer)resource;
        return null;
    }

    private String checkValidSourceFolder(String text) throws CoreException {
        String[] srcPaths;
        this.validatedSourceFolder = null;
        if (text == null || text.trim().length() == 0) {
            return "The source folder must be filled.";
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(text));
        if (resource == null) {
            return "The source folder was not found in the workspace.";
        }
        if (!(resource instanceof IContainer)) {
            return "The source folder was found in the workspace but is not a container.";
        }
        IProject project = resource.getProject();
        if (project == null) {
            return "Unable to find the project related to the source folder.";
        }
        IPythonPathNature nature = PythonNature.getPythonPathNature((IProject)project);
        if (nature == null) {
            return "The pydev nature is not configured on the project: " + project.getName();
        }
        String full = resource.getFullPath().toString();
        String[] stringArray = srcPaths = PythonNature.getStrAsStrItems((String)nature.getProjectSourcePath(true));
        int n = srcPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            if (str.equals(full)) {
                this.validatedSourceFolder = (IContainer)resource;
                return null;
            }
            ++n2;
        }
        return "The selected source folder is not recognized as a valid source folder.";
    }

    private String checkValidExistingSourceFolder() {
        if (this.existingSourceGroup.getErrorMessage() != null) {
            return this.existingSourceGroup.getErrorMessage();
        }
        if (this.sourceToLink == null) {
            return "Must enter an existing resource to link to.";
        }
        this.setMessage(this.existingSourceGroup.getWarningMessage(), 2);
        return null;
    }
}

