/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.files;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.python.pydev.core.preferences.FileTypesPreferences;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.ui.wizards.files.AbstractPythonWizard;
import org.python.pydev.ui.wizards.files.AbstractPythonWizardPage;

public class PythonPackageWizard
extends AbstractPythonWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.files.PythonPackageWizard";

    public PythonPackageWizard() {
        super("Create a new Python package");
    }

    @Override
    protected AbstractPythonWizardPage createPathPage() {
        return new AbstractPythonWizardPage(this.description, this.selection){

            @Override
            protected boolean shouldCreatePackageSelect() {
                return false;
            }

            @Override
            protected String checkNameText(String text) {
                String result = super.checkNameText(text);
                if (result != null) {
                    return result;
                }
                if (this.getValidatedSourceFolder().findMember(text) != null) {
                    return "The package " + text + " already exists in the source folder " + this.getValidatedSourceFolder().getName() + ".";
                }
                return null;
            }
        };
    }

    @Override
    protected IFile doCreateNew(IProgressMonitor monitor) throws CoreException {
        return PythonPackageWizard.createPackage(monitor, this.filePage.getValidatedSourceFolder(), this.filePage.getValidatedName());
    }

    public static IFile createPackage(IProgressMonitor monitor, IContainer validatedSourceFolder, String packageName) throws CoreException {
        IFile lastFile = null;
        if (validatedSourceFolder == null) {
            return null;
        }
        IContainer parent = validatedSourceFolder;
        for (String packagePart : StringUtils.dotSplit((String)packageName)) {
            IFile file;
            IFolder folder = parent.getFolder((IPath)new Path(packagePart));
            if (!folder.exists()) {
                folder.create(true, true, monitor);
            }
            if (!(file = (parent = folder).getFile((IPath)new Path("__init__" + FileTypesPreferences.getDefaultDottedPythonExtension()))).exists()) {
                file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, monitor);
            }
            lastFile = file;
        }
        return lastFile;
    }
}

