/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.util.HashMap;
import java.util.Map;

public class CheckAnalysisErrors {
    private static final Map<String, String> flake8MessageIdToCodeAnalysisError = new HashMap<String, String>();
    private static final Map<String, String> codeAnalysisErrorToFlake8MessageId = new HashMap<String, String>();
    private static final Map<Integer, String> codeAnalysisTypeFlake8MessageId = new HashMap<Integer, String>();
    private static final Map<String, String> pyLintMessageIdToCodeAnalysisError = new HashMap<String, String>();
    private static final Map<String, String> codeAnalysisErrorToPyLintMessageId = new HashMap<String, String>();
    private static final Map<Integer, String> codeAnalysisTypePyLintMessageId = new HashMap<Integer, String>();

    static {
        pyLintMessageIdToCodeAnalysisError.put("unused-import", "@UnusedImport");
        flake8MessageIdToCodeAnalysisError.put("F401", "@UnusedImport");
        pyLintMessageIdToCodeAnalysisError.put("unused-variable", "@UnusedVariable");
        pyLintMessageIdToCodeAnalysisError.put("undefined-variable", "@UndefinedVariable");
        flake8MessageIdToCodeAnalysisError.put("F821", "@UndefinedVariable");
        pyLintMessageIdToCodeAnalysisError.put("no-self-argument", "@NoSelf");
        pyLintMessageIdToCodeAnalysisError.put("redefined-builtin", "@ReservedAssignment");
        pyLintMessageIdToCodeAnalysisError.put("pointless-statement", "@NoEffect");
        pyLintMessageIdToCodeAnalysisError.put("function-redefined", "@DuplicatedSignature");
        pyLintMessageIdToCodeAnalysisError.put("unused-wildcard-import", "@UnusedWildImport");
        pyLintMessageIdToCodeAnalysisError.put("reimported", "@Reimport");
        pyLintMessageIdToCodeAnalysisError.put("no-name-in-module", "@UnresolvedImport");
        pyLintMessageIdToCodeAnalysisError.put("arguments-differ", "@ArgumentMismatch");
        pyLintMessageIdToCodeAnalysisError.put("bad-indentation", "@IndentOk");
        for (Map.Entry<String, String> entry : pyLintMessageIdToCodeAnalysisError.entrySet()) {
            codeAnalysisErrorToPyLintMessageId.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<String, String> entry : flake8MessageIdToCodeAnalysisError.entrySet()) {
            codeAnalysisErrorToFlake8MessageId.put(entry.getValue(), entry.getKey());
        }
        codeAnalysisTypePyLintMessageId.put(1, "unused-import");
        codeAnalysisTypeFlake8MessageId.put(1, "F401");
        codeAnalysisTypePyLintMessageId.put(2, "unused-variable");
        codeAnalysisTypePyLintMessageId.put(3, "undefined-variable");
        codeAnalysisTypeFlake8MessageId.put(3, "F821");
        codeAnalysisTypePyLintMessageId.put(7, "no-self-argument");
        codeAnalysisTypePyLintMessageId.put(14, "redefined-builtin");
        codeAnalysisTypePyLintMessageId.put(11, "pointless-statement");
        codeAnalysisTypePyLintMessageId.put(4, "function-redefined");
        codeAnalysisTypePyLintMessageId.put(8, "unused-wildcard-import");
        codeAnalysisTypePyLintMessageId.put(5, "reimported");
        codeAnalysisTypePyLintMessageId.put(6, "no-name-in-module");
        codeAnalysisTypePyLintMessageId.put(16, "arguments-differ");
        codeAnalysisTypePyLintMessageId.put(12, "bad-indentation");
    }

    public static boolean isPyLintErrorHandledAtLine(String line, String pyLintMessageId) {
        String codeAnalysisIgnoreMessage = pyLintMessageIdToCodeAnalysisError.get(pyLintMessageId);
        String flake8Code = null;
        if (codeAnalysisIgnoreMessage != null) {
            flake8Code = codeAnalysisErrorToFlake8MessageId.get(codeAnalysisIgnoreMessage);
        }
        return CheckAnalysisErrors.isErrorHandledAtLine(line, pyLintMessageId, codeAnalysisIgnoreMessage, flake8Code);
    }

    public static boolean isFlake8ErrorHandledAtLine(String line, String flake8Code) {
        String codeAnalysisIgnoreMessage = flake8MessageIdToCodeAnalysisError.get(flake8Code);
        String pyLintMessageId = null;
        if (codeAnalysisIgnoreMessage != null) {
            pyLintMessageId = codeAnalysisErrorToPyLintMessageId.get(codeAnalysisIgnoreMessage);
        }
        return CheckAnalysisErrors.isErrorHandledAtLine(line, pyLintMessageId, codeAnalysisIgnoreMessage, flake8Code);
    }

    public static boolean isRuffErrorHandledAtLine(String line, String ruffCode) {
        return CheckAnalysisErrors.isFlake8ErrorHandledAtLine(line, ruffCode);
    }

    private static boolean isErrorHandledAtLine(String line, String pyLintMessageId, String codeAnalysisIgnoreMessage, String flake8Code) {
        int i = line.indexOf(35);
        if (i == -1) {
            return false;
        }
        line = line.substring(i).toLowerCase();
        if (pyLintMessageId != null) {
            String lintW;
            pyLintMessageId = pyLintMessageId.toLowerCase();
            int pos = -1;
            pos = line.indexOf("ignore:");
            if (pos != -1 && (lintW = line.substring(pos + "ignore:".length())).startsWith(pyLintMessageId)) {
                return true;
            }
            if (line.contains(pyLintMessageId) && (line.contains("disable=") || line.contains("pylint:") || line.contains("noqa:"))) {
                return true;
            }
        }
        if (flake8Code != null && line.contains(flake8Code = flake8Code.toLowerCase()) && line.contains("noqa:")) {
            return true;
        }
        if (codeAnalysisIgnoreMessage != null && line.contains(codeAnalysisIgnoreMessage = codeAnalysisIgnoreMessage.toLowerCase())) {
            return true;
        }
        int noqaWithErr = line.indexOf("noqa:");
        return noqaWithErr == -1 && line.contains("noqa");
    }

    public static boolean isCodeAnalysisErrorHandled(String line, String messageToIgnore) {
        String pyLintMessageId = codeAnalysisErrorToPyLintMessageId.get(messageToIgnore);
        String flake8Code = codeAnalysisErrorToFlake8MessageId.get(messageToIgnore);
        return CheckAnalysisErrors.isErrorHandledAtLine(line, pyLintMessageId, messageToIgnore, flake8Code);
    }

    public static String getPyLintMessageIdForPyDevAnalysisType(int analysisType) {
        return codeAnalysisTypePyLintMessageId.get(analysisType);
    }
}

