/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.osgi.framework.BundleContext;
import org.python.pydev.core.CoreBundleInfo;
import org.python.pydev.core.ICoreBundleInfo;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.preferences.PyDevCorePreferencesInitializer;
import org.python.pydev.shared_core.io.FileUtils;

public class CorePlugin
extends Plugin {
    private static CorePlugin plugin;
    private ResourceBundle resourceBundle;
    public static ICoreBundleInfo info;
    public static File pydevStatelocation;
    public static final QualifiedName EDITOR_KEY;

    static {
        EDITOR_KEY = new QualifiedName("org.eclipse.ui.internal.registry.ResourceEditorRegistry", "EditorProperty");
    }

    public static ICoreBundleInfo getBundleInfo() {
        if (info == null) {
            info = new CoreBundleInfo(CorePlugin.getDefault().getBundle());
        }
        return info;
    }

    public static void setBundleInfo(ICoreBundleInfo b) {
        info = b;
    }

    public CorePlugin() {
        PyDevCorePreferencesInitializer.initializeDefaultPreferences();
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.python.pydev.core.CorePluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
    }

    public static String getPluginID() {
        return CorePlugin.getDefault().getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static CorePlugin getDefault() {
        return plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = CorePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static File getPep8Location() {
        return CorePlugin.getPepModuleLocation("pycodestyle.py");
    }

    public static File getPepModuleLocation(String moduleFilename) {
        File pep8Loc;
        block3: {
            try {
                String pep8Location = CorePlugin.getScriptWithinPySrc(new Path("third_party").append("pep8").append(moduleFilename).toString()).toString();
                pep8Loc = new File(pep8Location);
                if (pep8Loc.exists()) break block3;
                Log.log("Specified location for " + moduleFilename + " does not exist (" + pep8Location + ").");
                return null;
            }
            catch (CoreException e) {
                Log.log("Error getting " + moduleFilename + " location", e);
                return null;
            }
        }
        return pep8Loc;
    }

    public static File getPySrcPath() throws CoreException {
        Path relative = new Path("pysrc");
        return CorePlugin.getBundleInfo().getRelativePath((IPath)relative);
    }

    public static File getTypeshedPath() throws CoreException {
        Path relative = new Path("typeshed");
        return CorePlugin.getBundleInfo().getRelativePath((IPath)relative);
    }

    public static File getScriptWithinPySrc(String targetExec) throws CoreException {
        IPath relative = new Path("pysrc").addTrailingSeparator().append(targetExec);
        return CorePlugin.getBundleInfo().getRelativePath(relative);
    }

    public static File getWorkspaceMetadataFile(String fileName) {
        if (pydevStatelocation == null) {
            throw new RuntimeException("pydevStatelocation not set. If running in tests, call: setTestPlatformStateLocation");
        }
        return new File(pydevStatelocation, fileName);
    }

    public static boolean markAsPyDevFileIfDetected(IFile file) {
        block9: {
            String editorID;
            block7: {
                block8: {
                    String name = file.getName();
                    if (name == null || name.indexOf(46) != -1) {
                        return false;
                    }
                    editorID = file.getPersistentProperty(EDITOR_KEY);
                    if (editorID != null) break block7;
                    IFileStore store = EFS.getStore((URI)file.getLocationURI());
                    if (store == null || store.fetchInfo().getLength() > 0L) break block8;
                    return false;
                }
                InputStream contents = file.getContents(true);
                InputStreamReader inputStreamReader = new InputStreamReader(new BufferedInputStream(contents));
                if (!FileUtils.hasPythonShebang((Reader)inputStreamReader)) break block9;
                try {
                    file.setPersistentProperty(EDITOR_KEY, editorID);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                return true;
            }
            try {
                return "org.python.pydev.editor.PythonEditor".equals(editorID);
            }
            catch (Exception e) {
                if (!file.exists()) break block9;
                Log.log(e);
            }
        }
        return false;
    }
}

