/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.python.pydev.core.IDeltaProcessor;
import org.python.pydev.core.log.Log;
import org.python.pydev.shared_core.callbacks.ICallback;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.FullRepIterable;

public class DeltaSaver<X> {
    private File dirToSaveDeltas;
    private String suffix;
    private final List<DeltaCommand> commands;
    private final Object commandsLock = new Object();
    private int nCommands;
    private ICallback<X, String> readFromFileMethod;
    private ICallback<String, X> toFileMethod;

    public DeltaSaver(File dirToSaveDeltas, String extension, ICallback<X, String> readFromFileMethod, ICallback<String, X> toFileMethod) {
        this.dirToSaveDeltas = dirToSaveDeltas;
        this.suffix = "." + extension;
        this.commands = new ArrayList<DeltaCommand>();
        this.readFromFileMethod = readFromFileMethod;
        this.toFileMethod = toFileMethod;
        this.validateDir();
        this.loadDeltas();
    }

    private void validateDir() {
        if (!this.dirToSaveDeltas.exists()) {
            throw new RuntimeException("The path passed to save / restore deltas does not exist (" + String.valueOf(this.dirToSaveDeltas) + ")");
        }
        if (!this.dirToSaveDeltas.isDirectory()) {
            throw new RuntimeException("The path passed to save / restore deltas is not actually a directory (" + String.valueOf(this.dirToSaveDeltas) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadDeltas() {
        Object object = this.commandsLock;
        synchronized (object) {
            ArrayList<File> deltasFound = this.findDeltas();
            for (File file : deltasFound) {
                try {
                    DeltaCommand cmd = this.readFromFile(file, this.readFromFileMethod);
                    if (cmd == null || cmd.data == null) continue;
                    this.addRestoredCommand(cmd);
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
        }
    }

    private ArrayList<File> findDeltas() {
        ArrayList<File> deltasFound = new ArrayList<File>();
        File[] files = this.dirToSaveDeltas.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().endsWith(this.suffix)) {
                    deltasFound.add(file);
                }
                ++n2;
            }
        }
        Collections.sort(deltasFound, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String i = FullRepIterable.headAndTail((String)o1.getName())[0];
                String j = FullRepIterable.headAndTail((String)o2.getName())[0];
                return Integer.compare(Integer.parseInt(i), Integer.parseInt(j));
            }
        });
        return deltasFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRestoredCommand(DeltaCommand command) {
        Object object = this.commandsLock;
        synchronized (object) {
            this.commands.add(command);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCommand(DeltaCommand command) {
        Object object = this.commandsLock;
        synchronized (object) {
            File file = new File(this.dirToSaveDeltas, this.nCommands + this.suffix);
            ++this.nCommands;
            String write = (String)this.toFileMethod.call(command.data);
            if (write == null) {
                Log.log("Null returned to write from data: " + String.valueOf(command.data));
            } else {
                FastStringBuffer buf = new FastStringBuffer(command.getCommandFileDesc(), write.length());
                buf.append(write);
                FileUtils.writeStrToFile((String)buf.toString(), (File)file);
                this.commands.add(command);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int availableDeltas() {
        Object object = this.commandsLock;
        synchronized (object) {
            return this.commands.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this.commandsLock;
        synchronized (object) {
            ArrayList<File> deltas = this.findDeltas();
            for (File file : deltas) {
                try {
                    file.delete();
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
            this.commands.clear();
            this.nCommands = 0;
        }
    }

    public void addInsertCommand(X o) {
        this.addCommand(new DeltaInsertCommand(o));
    }

    public void addDeleteCommand(X o) {
        this.addCommand(new DeltaDeleteCommand(o));
    }

    public void addUpdateCommand(X o) {
        this.addCommand(new DeltaUpdateCommand(o));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void processDeltas(IDeltaProcessor<X> deltaProcessor) {
        Object object = this.commandsLock;
        synchronized (object) {
            ArrayList<DeltaCommand> commandsToProcess = new ArrayList<DeltaCommand>(this.commands);
            boolean processed = false;
            for (DeltaCommand cmd : commandsToProcess) {
                try {
                    cmd.processWith(deltaProcessor);
                    processed = true;
                }
                catch (Exception e) {
                    Log.log(e);
                }
            }
            if (processed) {
                deltaProcessor.endProcessing();
            }
            this.clearAll();
        }
    }

    public DeltaCommand readFromFile(File astOutputFile, ICallback<X, String> readFromFileMethod) {
        boolean deletFile;
        block11: {
            try {
                deletFile = false;
                if (astOutputFile.exists()) break block11;
                return null;
            }
            catch (Exception e) {
                Log.log(e);
                return null;
            }
        }
        String fileContents = FileUtils.getFileContents((File)astOutputFile);
        DeltaCommand o = null;
        try {
            if (fileContents.startsWith("UPD")) {
                o = new DeltaUpdateCommand(readFromFileMethod.call((Object)fileContents.substring(3)));
            } else if (fileContents.startsWith("DEL")) {
                o = new DeltaDeleteCommand(readFromFileMethod.call((Object)fileContents.substring(3)));
            } else if (fileContents.startsWith("INS")) {
                o = new DeltaInsertCommand(readFromFileMethod.call((Object)fileContents.substring(3)));
            }
        }
        catch (Exception e) {
            deletFile = true;
            o = null;
        }
        if (deletFile && astOutputFile.exists()) {
            astOutputFile.delete();
        }
        return o;
    }

    public abstract class DeltaCommand {
        public final X data;

        public DeltaCommand(X o) {
            this.data = o;
        }

        public abstract void processWith(IDeltaProcessor<X> var1);

        public abstract String getCommandFileDesc();
    }

    public class DeltaDeleteCommand
    extends DeltaCommand {
        public DeltaDeleteCommand(X o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor<X> deltaProcessor) {
            deltaProcessor.processDelete(this.data);
        }

        @Override
        public String getCommandFileDesc() {
            return "DEL";
        }
    }

    public class DeltaInsertCommand
    extends DeltaCommand {
        public DeltaInsertCommand(X o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor<X> deltaProcessor) {
            deltaProcessor.processInsert(this.data);
        }

        @Override
        public String getCommandFileDesc() {
            return "INS";
        }
    }

    public class DeltaUpdateCommand
    extends DeltaCommand {
        public DeltaUpdateCommand(X o) {
            super(o);
        }

        @Override
        public void processWith(IDeltaProcessor<X> deltaProcessor) {
            deltaProcessor.processUpdate(this.data);
        }

        @Override
        public String getCommandFileDesc() {
            return "UPD";
        }
    }
}

