/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.python.pydev.core.ModulesKeyForFolder;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class ModulesKey
implements Comparable<ModulesKey>,
Serializable {
    private static final long serialVersionUID = 2L;
    public String name;
    public File file;

    public ModulesKey(String name, File f) {
        this.name = name;
        this.file = f;
    }

    @Override
    public int compareTo(ModulesKey o) {
        return this.name.compareTo(o.name);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ModulesKey)) {
            return false;
        }
        ModulesKey m = (ModulesKey)o;
        return this.name.equals(m.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        FastStringBuffer ret = new FastStringBuffer(this.getClass().getSimpleName(), 40 + this.name.length());
        ret.append('[');
        ret.append(this.name);
        if (this.file != null) {
            ret.append(" - ");
            ret.appendObject((Object)this.file);
        }
        ret.append(']');
        return ret.toString();
    }

    public boolean hasPartStartingWith(String startingWithLowerCase) {
        ProcessCheckIfStartingWithPart onSplit = new ProcessCheckIfStartingWithPart(startingWithLowerCase);
        return !StringUtils.split((String)this.name.toLowerCase(), (char)'.', (StringUtils.ICallbackOnSplit)onSplit);
    }

    public static ModulesKey fromIO(String string) {
        List split = StringUtils.split((String)string, (char)'|');
        int size = split.size();
        if (size == 2) {
            String f = (String)split.get(1);
            return new ModulesKey((String)split.get(0), f.equals("null") ? null : new File(f));
        }
        if (size == 3) {
            String f = (String)split.get(1);
            if (((String)split.get(2)).equals("^")) {
                return new ModulesKeyForFolder((String)split.get(0), f.equals("null") ? null : new File(f));
            }
            return new ModulesKeyForZip((String)split.get(0), f.equals("null") ? null : new File(f), "", ((String)split.get(2)).equals("1"));
        }
        if (size == 4) {
            String f = (String)split.get(1);
            return new ModulesKeyForZip((String)split.get(0), f.equals("null") ? null : new File(f), (String)split.get(2), ((String)split.get(3)).equals("1"));
        }
        throw new RuntimeException("Unable to restore key from: " + string);
    }

    public void toIO(FastStringBuffer buf) {
        buf.append(this.name).append('|').append(this.file == null ? "null" : this.file.toString());
    }

    private static final class ProcessCheckIfStartingWithPart
    implements StringUtils.ICallbackOnSplit {
        private final String startingWithLowerCase;

        private ProcessCheckIfStartingWithPart(String startingWithLowerCase) {
            this.startingWithLowerCase = startingWithLowerCase;
        }

        public boolean call(String mod) {
            if (mod.length() == 0) {
                return true;
            }
            return !mod.startsWith(this.startingWithLowerCase);
        }
    }
}

