/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.python.pydev.core.ChainIterator;
import org.python.pydev.core.IObjectsList;
import org.python.pydev.core.IterEntry;
import org.python.pydev.core.TokensList;
import org.python.pydev.core.TokensListMixedLookingFor;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.structure.LowMemoryArrayList;

public class TokensOrProposalsList
implements IObjectsList,
Iterable<IterEntry> {
    private final Object[] proposals;
    private int size;
    private final List<TokensOrProposalsList> appended = new LowMemoryArrayList();
    private final List<TokensList> appendedTokens = new LowMemoryArrayList();
    private final List<TokensListMixedLookingFor> appendedMixed = new LowMemoryArrayList();
    private boolean freeze;

    public TokensOrProposalsList(Collection<ICompletionProposalHandle> proposals) {
        this(proposals.toArray(new ICompletionProposalHandle[0]));
    }

    public TokensOrProposalsList() {
        this.proposals = null;
    }

    public TokensOrProposalsList(ICompletionProposalHandle[] proposals) {
        this.proposals = proposals;
        if (proposals != null) {
            this.size = proposals.length;
        }
    }

    public TokensOrProposalsList(Object[] array) {
        this.proposals = array;
        if (this.proposals != null) {
            this.size = array.length;
        }
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<IterEntry> iterator() {
        ChainIterator<IterEntry> chainIterator = new ChainIterator<IterEntry>();
        this.addToIterator(chainIterator);
        chainIterator.build();
        return chainIterator;
    }

    private void addToIterator(ChainIterator<IterEntry> chainIterator) {
        if (this.proposals != null && this.proposals.length > 0) {
            chainIterator.add(this);
        }
        for (TokensOrProposalsList tokensOrProposalsList : this.appended) {
            tokensOrProposalsList.addToIterator(chainIterator);
        }
        for (TokensList tokensList : this.appendedTokens) {
            tokensList.addToIterator(chainIterator);
        }
        for (TokensListMixedLookingFor tokensListMixedLookingFor : this.appendedMixed) {
            tokensListMixedLookingFor.addToIterator(chainIterator);
        }
    }

    public void addAll(TokensOrProposalsList lst) {
        Assert.isTrue((!this.freeze ? 1 : 0) != 0);
        Assert.isTrue((lst != this ? 1 : 0) != 0);
        if (lst == null || lst.size == 0) {
            return;
        }
        lst.freeze();
        this.appended.add(lst);
        this.size += lst.size;
    }

    private void freeze() {
        this.freeze = true;
    }

    public void addAll(TokensList lst) {
        Assert.isTrue((!this.freeze ? 1 : 0) != 0);
        if (lst == null || lst.size() == 0) {
            return;
        }
        lst.freeze();
        this.appendedTokens.add(lst);
        this.size += lst.size();
    }

    public void addAll(TokensListMixedLookingFor tokensListMixedLookingFor) {
        Assert.isTrue((!this.freeze ? 1 : 0) != 0);
        if (tokensListMixedLookingFor == null || tokensListMixedLookingFor.size() == 0) {
            return;
        }
        tokensListMixedLookingFor.freeze();
        this.appendedMixed.add(tokensListMixedLookingFor);
        this.size += tokensListMixedLookingFor.size();
    }

    public String toString() {
        Iterator<IterEntry> it = this.iterator();
        if (!it.hasNext()) {
            return "TokensOrProposalsList[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("TokensOrProposalsList[");
        while (true) {
            sb.append(it.next().object);
            if (!it.hasNext()) {
                return sb.append(']').toString();
            }
            sb.append(',').append(' ');
        }
    }

    @Override
    public Iterator<IterEntry> buildIterator() {
        return new Iterator<IterEntry>(){
            IterEntry iterEntry = new IterEntry();
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < TokensOrProposalsList.this.proposals.length;
            }

            @Override
            public IterEntry next() {
                Object object = TokensOrProposalsList.this.proposals[this.i];
                ++this.i;
                this.iterEntry.object = object;
                return this.iterEntry;
            }
        };
    }
}

