/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.assist_fstring;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.python.pydev.core.IAssistProps;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.SyntaxErrorException;
import org.python.pydev.core.partition.PyPartitionScanner;
import org.python.pydev.core.proposals.CompletionProposalFactory;
import org.python.pydev.shared_core.code_completion.ICompletionProposalHandle;
import org.python.pydev.shared_core.image.IImageCache;
import org.python.pydev.shared_core.image.IImageHandle;
import org.python.pydev.shared_core.partitioner.FastPartitioner;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public class AssistFString
implements IAssistProps {
    @Override
    public List<ICompletionProposalHandle> getProps(PySelection ps, IImageCache imageCache, File f, IPythonNature nature, IPyEdit edit, int offset) throws BadLocationException, MisconfigurationException {
        int partitionEndOffset;
        int i;
        ArrayList<ICompletionProposalHandle> lst = new ArrayList<ICompletionProposalHandle>();
        IDocument doc = ps.getDoc();
        ITypedRegion partition = ((FastPartitioner)PyPartitionScanner.checkPartitionScanner(doc)).getPartition(offset);
        if (!ParsingUtils.isStringContentType(partition.getType())) {
            return lst;
        }
        int partitionOffset = partition.getOffset();
        char firstPrefix = doc.getChar(partitionOffset);
        int penultPrefix = 32;
        if (firstPrefix != '\'' && firstPrefix == '\"') {
            penultPrefix = doc.getChar(partitionOffset + 1);
        }
        if (firstPrefix == 'b' || penultPrefix == 98 || firstPrefix == 'f' || penultPrefix == 102) {
            return lst;
        }
        String stringPartitionContents = doc.get(partitionOffset, partition.getLength());
        int formatCount = 0;
        formatCount += StringUtils.count((String)stringPartitionContents, (String)"%s");
        formatCount += StringUtils.count((String)stringPartitionContents, (String)"%r");
        ParsingUtils parsingUtils = ParsingUtils.create(doc);
        boolean validStmt = false;
        for (i = partitionEndOffset = partitionOffset + partition.getLength(); i < parsingUtils.len(); ++i) {
            char c = parsingUtils.charAt(i);
            if (Character.isWhitespace(c)) {
                continue;
            }
            if (c != '%') break;
            if (formatCount == 0) {
                return lst;
            }
            validStmt = true;
            ++i;
            break;
        }
        if (validStmt) {
            try {
                int formatVariablesLen = -1;
                boolean acceptMultiLines = false;
                ArrayList<Object> variables = new ArrayList<Object>();
                while (i < parsingUtils.len()) {
                    Object lastVarContent;
                    int n;
                    char c = parsingUtils.charAt(i);
                    if (Character.isWhitespace(c)) {
                        ++i;
                        continue;
                    }
                    if (c == '{' || c == '%') {
                        return lst;
                    }
                    if (c == '[' || c == '(') {
                        formatVariablesLen = parsingUtils.eatPar(i, null, c) - partitionEndOffset + 1;
                        if (partitionEndOffset + formatVariablesLen > parsingUtils.len()) {
                            return lst;
                        }
                        c = parsingUtils.charAt(++i);
                        acceptMultiLines = true;
                    }
                    int n2 = i;
                    while (i < parsingUtils.len()) {
                        c = parsingUtils.charAt(i);
                        if (Character.isJavaIdentifierPart(c) || c == ' ' || c == '.' || acceptMultiLines && Character.isWhitespace(c)) {
                            ++i;
                            continue;
                        }
                        if (c == '{' || c == '[' || c == '(' || c == '\"' || c == '\'') {
                            if ((i = parsingUtils.eatPar(i, null, c)) < parsingUtils.len()) {
                                ++i;
                                continue;
                            }
                            return lst;
                        }
                        if (c != ',') break;
                        variables.add(doc.get(n, i - n).trim());
                        n = ++i;
                    }
                    if (formatVariablesLen == -1) {
                        formatVariablesLen = i - partitionEndOffset;
                    }
                    if (n == i || ((String)(lastVarContent = doc.get(n, i - n).trim())).length() <= 0) break;
                    variables.add(lastVarContent);
                    break;
                }
                FastStringBuffer strBuf = new FastStringBuffer(1 + partition.getLength() + formatVariablesLen);
                strBuf.append('f').append(stringPartitionContents);
                if (formatCount == variables.size()) {
                    for (String string : variables) {
                        String rep = this.getReplace(strBuf);
                        String with = null;
                        with = "%r".equals(rep) ? "{" + string + "!r}" : "{" + string + "}";
                        strBuf.replaceFirst(rep, with);
                    }
                } else if (variables.size() == 1) {
                    String string = (String)variables.get(0);
                    i = 0;
                    while (i < formatCount) {
                        String rep = this.getReplace(strBuf);
                        String with = null;
                        with = "%r".equals(rep) ? "{" + string + "[" + i + "]!r}" : "{" + string + "[" + i + "]}";
                        strBuf.replaceFirst(rep, with);
                        ++i;
                    }
                } else {
                    return lst;
                }
                lst.add(CompletionProposalFactory.get().createPyCompletionProposal(strBuf.toString(), partitionOffset, partition.getLength() + formatVariablesLen, 0, this.getImage(imageCache, "icons/template.gif"), "Convert to f-string", null, null, 10, null));
                return lst;
            }
            catch (SyntaxErrorException formatVariablesLen) {
                // empty catch block
            }
        }
        FastStringBuffer buf = new FastStringBuffer(stringPartitionContents.length() + 1);
        buf.append('f').append(stringPartitionContents);
        lst.add(CompletionProposalFactory.get().createPyCompletionProposal(buf.toString(), partitionOffset, partition.getLength(), 0, this.getImage(imageCache, "icons/template.gif"), "Convert to f-string", null, null, 10, null));
        return lst;
    }

    private String getReplace(FastStringBuffer strBuf) {
        String rep = "%s";
        int oS = strBuf.indexOf("%s");
        int oR = strBuf.indexOf("%r");
        if (oS == -1 || oR != -1 && oR < oS) {
            rep = "%r";
        }
        return rep;
    }

    private IImageHandle getImage(IImageCache imageCache, String c) {
        if (imageCache != null) {
            return imageCache.get(c);
        }
        return null;
    }

    @Override
    public boolean isValid(PySelection ps, String sel, IPyEdit edit, int offset) {
        if (edit != null) {
            try {
                IPythonNature pythonNature = edit.getPythonNature();
                if (pythonNature != null && pythonNature.getGrammarVersion() < 100) {
                    return false;
                }
            }
            catch (MisconfigurationException misconfigurationException) {
                // empty catch block
            }
        }
        return true;
    }
}

