/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.cache;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.python.pydev.core.FastBufferedReader;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.core.ModulesKeyForFolder;
import org.python.pydev.core.ModulesKeyForZip;
import org.python.pydev.core.ObjectsInternPool;
import org.python.pydev.core.cache.CompleteIndexKey;
import org.python.pydev.shared_core.io.FileUtils;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;

public final class DiskCache {
    private static final boolean DEBUG = false;
    public static final int VERSION = 3;
    private final Object lock = new Object();
    private String folderToPersist;
    private Map<CompleteIndexKey, CompleteIndexKey> keys = new HashMap<CompleteIndexKey, CompleteIndexKey>();

    public void writeTo(FastStringBuffer tempBuf) {
        tempBuf.append("-- START DISKCACHE_3\n");
        tempBuf.append(this.folderToPersist);
        tempBuf.append('\n');
        for (CompleteIndexKey key : this.keys.values()) {
            ModulesKey modKey = key.key;
            tempBuf.append(modKey.name);
            tempBuf.append('|');
            tempBuf.append(key.lastModified);
            tempBuf.append('|');
            if (modKey.file != null) {
                tempBuf.append(modKey.file.toString());
            }
            if (modKey instanceof ModulesKeyForZip) {
                ModulesKeyForZip modulesKeyForZip = (ModulesKeyForZip)modKey;
                tempBuf.append('|');
                tempBuf.append(modulesKeyForZip.zipModulePath);
                tempBuf.append('|');
                tempBuf.append(modulesKeyForZip.isFile ? (char)'0' : '1');
            } else if (modKey instanceof ModulesKeyForFolder) {
                tempBuf.append('|');
                tempBuf.append('^');
            }
            tempBuf.append('\n');
        }
        tempBuf.append("-- END DISKCACHE\n");
    }

    public static DiskCache loadFrom(FastBufferedReader reader, ObjectsInternPool.ObjectsPoolMap objectsPoolMap) throws IOException {
        DiskCache diskCache = new DiskCache();
        FastStringBuffer line = reader.readLine();
        if (line.startsWith("-- ")) {
            throw new RuntimeException("Unexpected line: " + String.valueOf(line));
        }
        diskCache.folderToPersist = line.toString();
        FastStringBuffer buf = new FastStringBuffer();
        CompleteIndexKey key = null;
        char[] internalCharsArray = line.getInternalCharsArray();
        while (true) {
            line = reader.readLine();
            key = null;
            if (line == null || line.startsWith("-- ")) {
                if (line != null && line.startsWith("-- END DISKCACHE")) {
                    return diskCache;
                }
                throw new RuntimeException("Unexpected line: " + String.valueOf(line));
            }
            int length = line.length();
            int part = 0;
            int i = 0;
            while (i < length) {
                char c = internalCharsArray[i];
                if (c == '|') {
                    switch (part) {
                        case 0: {
                            key = new CompleteIndexKey(ObjectsInternPool.internLocal(objectsPoolMap, buf.toString()));
                            diskCache.add(key);
                            break;
                        }
                        case 1: {
                            key.lastModified = StringUtils.parsePositiveLong((FastStringBuffer)buf);
                            break;
                        }
                        case 2: {
                            if (buf.length() <= 0) break;
                            key.key.file = new File(ObjectsInternPool.internLocal(objectsPoolMap, buf.toString()));
                            break;
                        }
                        case 3: {
                            if (buf.endsWith("|^")) {
                                key.key = new ModulesKeyForFolder(key.key.name, key.key.file);
                                break;
                            }
                            key.key = new ModulesKeyForZip(key.key.name, key.key.file, ObjectsInternPool.internLocal(objectsPoolMap, buf.toString()), true);
                            break;
                        }
                        case 4: {
                            if (!buf.toString().equals("0")) break;
                            ((ModulesKeyForZip)key.key).isFile = true;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unexpected part in line: " + String.valueOf(line));
                        }
                    }
                    ++part;
                    buf.clear();
                } else {
                    buf.append(c);
                }
                ++i;
            }
            if (buf.length() <= 0) continue;
            switch (part) {
                case 1: {
                    key.lastModified = StringUtils.parsePositiveLong((FastStringBuffer)buf);
                    break;
                }
                case 2: {
                    key.key.file = new File(ObjectsInternPool.internLocal(objectsPoolMap, buf.toString()));
                    break;
                }
                case 3: {
                    key.key = new ModulesKeyForZip(key.key.name, key.key.file, ObjectsInternPool.internLocal(objectsPoolMap, buf.toString()), true);
                    break;
                }
                case 4: {
                    if (!buf.toString().equals("0")) break;
                    ((ModulesKeyForZip)key.key).isFile = true;
                }
            }
            buf.clear();
        }
    }

    private DiskCache() {
    }

    public DiskCache(File folderToPersist, String suffix) {
        this();
        this.folderToPersist = FileUtils.getFileAbsolutePath((File)folderToPersist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(CompleteIndexKey key) {
        Object object = this.lock;
        synchronized (object) {
            this.keys.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(CompleteIndexKey key) {
        Object object = this.lock;
        synchronized (object) {
            this.keys.put(key, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.keys.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<CompleteIndexKey, CompleteIndexKey> keys() {
        Object object = this.lock;
        synchronized (object) {
            return new HashMap<CompleteIndexKey, CompleteIndexKey>(this.keys);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFolderToPersist(String folderToPersist) {
        Object object = this.lock;
        synchronized (object) {
            File file = new File(folderToPersist);
            if (!file.exists()) {
                file.mkdirs();
            }
            this.folderToPersist = folderToPersist;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFolderToPersist() {
        Object object = this.lock;
        synchronized (object) {
            return this.folderToPersist;
        }
    }
}

