/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docstrings;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.python.pydev.core.preferences.PydevPrefs;
import org.python.pydev.shared_core.SharedCorePlugin;

public class DocstringPreferences {
    public static final String DOCSTRING_CHARACTER = "DOCSTRING CHARACTER";
    public static final String DEFAULT_DOCSTRING_CHARACTER = "'";
    public static final String DOCSTRING_STYLE = "DOCSTRING STYLE";
    public static final String DOCSTRING_STYLE_SPHINX = ":";
    public static final String DOCSTRING_STYLE_EPYDOC = "@";
    public static final String DOCSTRING_STYLE_GOOGLE = "G";
    public static final String DEFAULT_DOCSTRING_STYLE = ":";
    public static final String TYPETAG_GENERATION_NEVER = "Never";
    public static final String TYPETAG_GENERATION_ALWAYS = "Always";
    public static final String TYPETAG_GENERATION_CUSTOM = "Custom";
    public static final String TYPETAG_GENERATION = "TYPETAGGENERATION";
    public static final String DEFAULT_TYPETAG_GENERATION = "Never";
    public static final String DONT_GENERATE_TYPETAGS = "DONT_GENERATE_TYPETAGS_PREFIXES";
    public static final String DEFAULT_DONT_GENERATE_TYPETAGS = "sz,n,f";
    public static final String TYPETAG_SEPARATORS = ",; \n";
    public static final Map<String, String> strToMarker = new HashMap<String, String>();
    public static boolean GENERATE_TYPE_DOCSTRING_ON_TESTS;

    static {
        strToMarker.put(DEFAULT_DOCSTRING_CHARACTER, "'''");
        strToMarker.put("\"", "\"\"\"");
        GENERATE_TYPE_DOCSTRING_ON_TESTS = true;
    }

    public static String getPreferredDocstringCharacter() {
        if (SharedCorePlugin.inTestMode()) {
            return DEFAULT_DOCSTRING_CHARACTER;
        }
        return PydevPrefs.getEclipsePreferences().get(DOCSTRING_CHARACTER, DEFAULT_DOCSTRING_CHARACTER);
    }

    public static String getPreferredDocstringStyle() {
        if (SharedCorePlugin.inTestMode()) {
            return ":";
        }
        return PydevPrefs.getEclipsePreferences().get(DOCSTRING_STYLE, ":");
    }

    public static String getDocstringMarker() {
        String docstringChar = DocstringPreferences.getPreferredDocstringCharacter();
        Object ret = strToMarker.get(docstringChar);
        if (ret == null) {
            ret = docstringChar + docstringChar + docstringChar;
            strToMarker.put(docstringChar, (String)ret);
        }
        return ret;
    }

    public static boolean getTypeTagShouldBeGenerated(String parameterName) {
        if (SharedCorePlugin.inTestMode()) {
            return GENERATE_TYPE_DOCSTRING_ON_TESTS;
        }
        IEclipsePreferences preferences = PydevPrefs.getEclipsePreferences();
        String preference = preferences.get(TYPETAG_GENERATION, "Never").toLowerCase().strip();
        if (DOCSTRING_STYLE_GOOGLE.equals(DocstringPreferences.getPreferredDocstringStyle())) {
            return false;
        }
        if (preference.equals("Never".toLowerCase())) {
            return false;
        }
        if (preference.equals(TYPETAG_GENERATION_ALWAYS.toLowerCase())) {
            return true;
        }
        String prefixesString = preferences.get(DONT_GENERATE_TYPETAGS, DEFAULT_DONT_GENERATE_TYPETAGS);
        StringTokenizer st = new StringTokenizer(prefixesString, TYPETAG_SEPARATORS);
        while (st.hasMoreTokens()) {
            if (!parameterName.startsWith(st.nextToken())) continue;
            return false;
        }
        return true;
    }
}

