/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PyImportsHandling;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.shared_core.string.DocIterator;
import org.python.pydev.shared_core.string.FastStringBuffer;
import org.python.pydev.shared_core.string.StringUtils;
import org.python.pydev.shared_core.string.TextSelectionUtils;

public class ImportsSelection {
    private static final Pattern FromPattern = Pattern.compile("(\\bfrom\\s*)");
    private static final Pattern ImportPattern = Pattern.compile("(\\bimport\\b\\s*)");

    public static ICodeCompletionASTManager.ImportInfo getImportsTipperStr(String leftTrimmedLine, boolean returnEvenEmpty) {
        int dots;
        FastStringBuffer buf;
        if (!leftTrimmedLine.startsWith("from") && !leftTrimmedLine.startsWith("import")) {
            return new ICodeCompletionASTManager.ImportInfo("", false, false);
        }
        FastStringBuffer docContents = new FastStringBuffer(leftTrimmedLine, 0);
        Matcher matcher = FromPattern.matcher(leftTrimmedLine);
        int fromIndexEnd = -1;
        if (matcher.find()) {
            fromIndexEnd = matcher.end();
        }
        matcher = ImportPattern.matcher(leftTrimmedLine);
        int importIndexEnd = -1;
        if (matcher.find()) {
            importIndexEnd = matcher.end();
        }
        matcher = null;
        if (importIndexEnd == -1 && fromIndexEnd == -1) {
            return new ICodeCompletionASTManager.ImportInfo("", false, false);
        }
        ImportsSelection.fixDocContents(fromIndexEnd, importIndexEnd, docContents);
        Document doc = new Document(docContents.toString());
        PyImportsHandling pyImportsHandling = new PyImportsHandling((IDocument)doc, false, true);
        Iterator<ImportHandle> it = pyImportsHandling.iterator();
        if (!it.hasNext()) {
            return new ICodeCompletionASTManager.ImportInfo("", importIndexEnd != -1, fromIndexEnd != -1);
        }
        ImportHandle next = it.next();
        List<ImportHandle.ImportHandleInfo> importInfo = next.getImportInfo();
        if (importInfo.size() == 0) {
            return new ICodeCompletionASTManager.ImportInfo(" ", importIndexEnd != -1, fromIndexEnd != -1);
        }
        ImportHandle.ImportHandleInfo importHandleInfo = importInfo.get(importInfo.size() - 1);
        String fromImportStr = importHandleInfo.getFromImportStr();
        int leadingDots = 0;
        if (fromImportStr != null) {
            FastStringBuffer bufLeadingChars = new FastStringBuffer(fromImportStr, 0);
            int i = 0;
            while (i < bufLeadingChars.length()) {
                if (bufLeadingChars.charAt(i) != '.') break;
                ++leadingDots;
                ++i;
            }
            if (leadingDots > 0) {
                bufLeadingChars.deleteFirstChars(leadingDots);
                fromImportStr = bufLeadingChars.toString();
            }
        }
        List<String> importedStr = importHandleInfo.getImportedStr();
        Iterator<String> importedStrIterator = importedStr.iterator();
        boolean hasFrom = importHandleInfo.getFoundFrom();
        boolean hasImport = importHandleInfo.getFoundImport();
        boolean addedFromPart = fromImportStr != null;
        boolean addedImportPart = importedStrIterator.hasNext();
        if (fromImportStr == null) {
            buf = new FastStringBuffer(40);
        } else {
            buf = new FastStringBuffer(fromImportStr, 20);
            if (importedStrIterator.hasNext()) {
                buf.append('.');
            }
        }
        while (importedStrIterator.hasNext()) {
            buf.append(importedStrIterator.next());
        }
        buf.trim();
        if (hasFrom && hasImport && addedFromPart && !addedImportPart) {
            return ImportsSelection.buildImportInfo(buf, hasFrom, hasImport, leadingDots);
        }
        if ((hasFrom && !hasImport || !hasFrom && hasImport) && (dots = StringUtils.countChars((char)'.', (FastStringBuffer)buf)) == buf.length()) {
            return ImportsSelection.buildImportInfo(buf, hasFrom, hasImport, leadingDots);
        }
        if (buf.endsWith('.')) {
            buf.deleteLast();
            return ImportsSelection.buildImportInfo(buf, hasFrom, hasImport, leadingDots);
        }
        int lastIndexOf = buf.lastIndexOf('.');
        if (lastIndexOf >= 0) {
            buf.keepCharsUpTo(lastIndexOf);
            return ImportsSelection.buildImportInfo(buf, hasFrom, hasImport, leadingDots);
        }
        if (leadingDots > 0) {
            return new ICodeCompletionASTManager.ImportInfo(new FastStringBuffer("", leadingDots).appendN('.', leadingDots).toString(), hasImport, hasFrom);
        }
        return new ICodeCompletionASTManager.ImportInfo(" ", hasImport, hasFrom);
    }

    private static ICodeCompletionASTManager.ImportInfo buildImportInfo(FastStringBuffer buf, boolean hasFrom, boolean hasImport, int leadingDots) {
        if (leadingDots > 0) {
            buf.insertN(0, '.', leadingDots);
        } else if (buf.length() == 0) {
            buf.append(' ');
        }
        return new ICodeCompletionASTManager.ImportInfo(buf.toString(), hasImport, hasFrom);
    }

    private static void fixDocContents(int fromIndexEnd, int importIndexEnd, FastStringBuffer docContents) {
        int commaIndex = docContents.lastIndexOf(',');
        if (commaIndex == -1) {
            return;
        }
        if (importIndexEnd != -1) {
            docContents.delete(importIndexEnd, commaIndex + 1);
        } else {
            docContents.delete(fromIndexEnd, commaIndex + 1);
        }
    }

    public static ICodeCompletionASTManager.ImportInfo getImportsTipperStr(IDocument doc, int documentOffset) {
        DocIterator iterator = new DocIterator(false, (TextSelectionUtils)new PySelection(doc, documentOffset));
        StringBuffer buffer = new StringBuffer();
        boolean expectContinue = false;
        boolean allEndingWithSlash = true;
        boolean found = false;
        while (iterator.hasNext()) {
            String line = ParsingUtils.removeComments(iterator.next());
            String leftTrimmedLine = line.stripLeading();
            String trimmedLine = line.strip();
            if (PySelection.isImportLine(trimmedLine)) {
                if (expectContinue) {
                    boolean correct = false;
                    if (trimmedLine.indexOf(40) != -1) {
                        correct = true;
                    }
                    if (leftTrimmedLine.endsWith("\\") && allEndingWithSlash) {
                        correct = true;
                    }
                    if (!correct) break;
                }
                found = true;
                buffer.insert(0, leftTrimmedLine);
                break;
            }
            if (expectContinue) {
                if (trimmedLine.indexOf(41) != -1) break;
                if (allEndingWithSlash && trimmedLine.length() > 0) {
                    char c = trimmedLine.charAt(trimmedLine.length() - 1);
                    if (c != '\\' && c != ',' && c != '(') break;
                    if (c != '\\') {
                        allEndingWithSlash = false;
                    }
                } else if (trimmedLine.length() == 0) break;
            }
            expectContinue = true;
            buffer.insert(0, line);
        }
        if (!found) {
            return new ICodeCompletionASTManager.ImportInfo("", false, false);
        }
        return ImportsSelection.getImportsTipperStr(buffer.toString(), true);
    }
}

