/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.ImportNotRecognizedException;
import org.python.pydev.core.docutils.PyDocIterator;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.shared_core.string.StringUtils;

public class PyImportsIterator
implements Iterator<ImportHandle> {
    private final PyDocIterator docIterator;
    private boolean hasNext = true;
    private ImportHandle nextImport;
    private final String delimiter;
    private final IDocument doc;
    private final boolean addOnlyGlobalImports;
    private final boolean allowBadInput;

    public PyImportsIterator(IDocument doc) {
        this(doc, true);
    }

    public PyImportsIterator(IDocument doc, boolean addOnlyGlobalImports, boolean allowBadInput) {
        this(doc, addOnlyGlobalImports, allowBadInput, 0);
    }

    public PyImportsIterator(IDocument doc, boolean addOnlyGlobalImports, boolean allowBadInput, int startOffset) {
        this.doc = doc;
        this.addOnlyGlobalImports = addOnlyGlobalImports;
        this.allowBadInput = allowBadInput;
        this.delimiter = PySelection.getDelimiter((IDocument)doc);
        this.docIterator = new PyDocIterator(doc, false, false, false, true);
        this.docIterator.setStartingOffset(startOffset);
        this.calcNext();
    }

    public PyImportsIterator(IDocument doc, boolean addOnlyGlobalImports) {
        this(doc, addOnlyGlobalImports, false);
    }

    private void calcNext() {
        if (!this.hasNext) {
            return;
        }
        int startFoundLine = -1;
        this.hasNext = false;
        this.nextImport = null;
        while (this.docIterator.hasNext()) {
            boolean match;
            Object str = this.docIterator.next();
            if (this.addOnlyGlobalImports) {
                match = ((String)str).startsWith("import ") || ((String)str).startsWith("from ") || ((String)str).trim().equals("import");
            } else {
                boolean bl = match = ((String)(str = StringUtils.leftTrim((String)str))).startsWith("import ") || ((String)str).startsWith("from ") || ((String)str).trim().equals("import");
            }
            if (!match) continue;
            startFoundLine = this.docIterator.getLastReturnedLine();
            if (((String)str).indexOf(40) != -1) {
                while (this.docIterator.hasNext() && ((String)str).indexOf(41) == -1) {
                    str = (String)str + this.delimiter + this.docIterator.next();
                }
            }
            if (StringUtils.endsWith((String)str, (char)'\\')) {
                while (this.docIterator.hasNext() && StringUtils.endsWith((String)str, (char)'\\')) {
                    str = (String)str + this.delimiter + this.docIterator.next();
                }
            }
            try {
                this.nextImport = new ImportHandle(this.doc, (String)str, startFoundLine, -1, this.allowBadInput);
            }
            catch (ImportNotRecognizedException e) {
                continue;
            }
            this.hasNext = true;
            this.nextImport.endFoundLine = this.docIterator.getLastReturnedLine();
            break;
        }
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public ImportHandle next() {
        ImportHandle ret = this.nextImport;
        this.calcNext();
        return ret;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }
}

