/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.IPyDocIterator;
import org.python.pydev.core.partition.PyPartitionScanner;
import org.python.pydev.shared_core.partitioner.FastPartitioner;
import org.python.pydev.shared_core.string.FastStringBuffer;

public class ReversePyDocIterator
implements IPyDocIterator {
    private int offset;
    private IDocument doc;
    private int lastReturned = -1;
    private FastPartitioner fastPartitioner;
    private final FastStringBuffer buf = new FastStringBuffer();

    public ReversePyDocIterator(IDocument doc) throws BadLocationException {
        this(doc, doc.getLineOfOffset(doc.getLength() - 1));
    }

    public ReversePyDocIterator(IDocument doc, int startingLine) throws BadLocationException {
        this.doc = doc;
        this.offset = doc.getLineOffset(startingLine) + doc.getLineLength(startingLine) - 1;
        this.fastPartitioner = (FastPartitioner)PyPartitionScanner.checkPartitionScanner(doc);
    }

    @Override
    public boolean hasNext() {
        return this.offset >= 0;
    }

    @Override
    public int getLastReturnedLine() {
        if (this.offset < this.doc.getLength() - 1) {
            try {
                this.lastReturned = this.doc.getLineOfOffset(this.offset + 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return this.lastReturned;
    }

    @Override
    public String next() {
        this.buf.clear();
        try {
            char ch = this.doc.getChar(this.offset);
            if (ch == '\n' || ch == '\r') {
                --this.offset;
                if (this.offset >= 0 && ch == '\n' && this.doc.getChar(this.offset) == '\r') {
                    --this.offset;
                }
            }
            while (this.offset >= 0) {
                ch = this.doc.getChar(this.offset);
                if (ch == '\n' || ch == '\r') break;
                if (this.fastPartitioner.getContentType(this.offset) != "__dftl_partition_content_type") {
                    this.buf.append(' ');
                } else {
                    this.buf.append(ch);
                }
                --this.offset;
            }
            return this.buf.reverse().toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not Impl.");
    }
}

