/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.editor;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.shared_core.callbacks.ICallback;

public class OpenEditors {
    private static final Set<IPyEdit> currentlyOpenedEditors = new HashSet<IPyEdit>();
    private static final Object currentlyOpenedEditorsLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEditorOpenForResource(IResource r) {
        HashSet<IPyEdit> hashSet;
        Object object = currentlyOpenedEditorsLock;
        synchronized (object) {
            hashSet = new HashSet<IPyEdit>(currentlyOpenedEditors);
        }
        for (IPyEdit edit : hashSet) {
            Object adapter;
            IAdaptable input = edit.getEditorInput();
            if (input == null || (adapter = input.getAdapter(IResource.class)) == null || !r.equals(adapter)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeOpenedEditor(IPyEdit pyEdit) {
        Object object = currentlyOpenedEditorsLock;
        synchronized (object) {
            currentlyOpenedEditors.remove(pyEdit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object iterOpenEditorsUntilFirstReturn(ICallback<Object, IPyEdit> callback) {
        HashSet<IPyEdit> hashSet;
        Object object = currentlyOpenedEditorsLock;
        synchronized (object) {
            hashSet = new HashSet<IPyEdit>(currentlyOpenedEditors);
        }
        for (IPyEdit edit : hashSet) {
            Object ret = callback.call((Object)edit);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addOpenedEditor(IPyEdit pyEdit) {
        Object object = currentlyOpenedEditorsLock;
        synchronized (object) {
            currentlyOpenedEditors.add(pyEdit);
        }
    }
}

