/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.partition;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.IPythonPartitions;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.partition.AbstractPyPartitionScanner;
import org.python.pydev.core.partition.PyPartitioner;

public class PyPartitionScanner
extends AbstractPyPartitionScanner {
    public static String[] getTypes() {
        return IPythonPartitions.types;
    }

    public static IDocumentPartitioner checkPartitionScanner(IDocument document) {
        return PyPartitionScanner.checkPartitionScanner(document, null);
    }

    public static IDocumentPartitioner checkPartitionScanner(IDocument document, IGrammarVersionProvider grammarVersionProvider) {
        if (document == null) {
            return null;
        }
        IDocumentExtension3 docExtension = (IDocumentExtension3)document;
        IDocumentPartitioner partitioner = docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
        if (partitioner == null) {
            PyPartitionScanner.addPartitionScanner(document, grammarVersionProvider);
            partitioner = docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
        }
        if (!(partitioner instanceof PyPartitioner)) {
            Log.log("Partitioner should be subclass of PyPartitioner. It is " + String.valueOf(partitioner.getClass()));
        }
        return partitioner;
    }

    public static IDocumentPartitioner addPartitionScanner(IDocument document, IGrammarVersionProvider grammarVersionProvider) {
        if (document != null) {
            IDocumentExtension3 docExtension = (IDocumentExtension3)document;
            IDocumentPartitioner curr = docExtension.getDocumentPartitioner("__PYTHON_PARTITION_TYPE");
            if (curr == null) {
                PyPartitioner partitioner = PyPartitionScanner.createPyPartitioner();
                partitioner.connect(document);
                docExtension.setDocumentPartitioner("__PYTHON_PARTITION_TYPE", (IDocumentPartitioner)partitioner);
                return partitioner;
            }
            return curr;
        }
        return null;
    }

    public static PyPartitioner createPyPartitioner() {
        return new PyPartitioner(new PyPartitionScanner(), PyPartitionScanner.getTypes());
    }
}

