/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.json.eclipsesource;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.python.pydev.json.eclipsesource.JsonValue;
import org.python.pydev.json.eclipsesource.JsonWriter;

public class JsonObject
extends JsonValue {
    private final List<String> names;
    private final List<JsonValue> values;

    public JsonObject() {
        this.names = new ArrayList<String>();
        this.values = new ArrayList<JsonValue>();
    }

    public JsonObject(JsonObject object) {
        if (object == null) {
            throw new NullPointerException("object is null");
        }
        this.names = new ArrayList<String>(object.names);
        this.values = new ArrayList<JsonValue>(object.values);
    }

    private JsonObject(List<String> names, List<JsonValue> values) {
        this.names = names;
        this.values = values;
    }

    public static JsonObject readFrom(Reader reader) throws IOException {
        return JsonValue.readFrom(reader).asObject();
    }

    public static JsonObject readFrom(String string) {
        return JsonValue.readFrom(string).asObject();
    }

    public static JsonObject unmodifiableObject(JsonObject object) {
        return new JsonObject(Collections.unmodifiableList(object.names), Collections.unmodifiableList(object.values));
    }

    public JsonObject add(String name, long value) {
        this.add(name, JsonObject.valueOf(value));
        return this;
    }

    public JsonObject add(String name, float value) {
        this.add(name, JsonObject.valueOf(value));
        return this;
    }

    public JsonObject add(String name, double value) {
        this.add(name, JsonObject.valueOf(value));
        return this;
    }

    public JsonObject add(String name, boolean value) {
        this.add(name, JsonObject.valueOf(value));
        return this;
    }

    public JsonObject add(String name, String value) {
        this.add(name, JsonObject.valueOf(value));
        return this;
    }

    public JsonObject add(String name, JsonValue value) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (value == null) {
            throw new NullPointerException("value is null");
        }
        this.names.add(name);
        this.values.add(value);
        return this;
    }

    public JsonObject remove(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        int index = this.names.indexOf(name);
        if (index != -1) {
            this.names.remove(index);
            this.values.remove(index);
        }
        return this;
    }

    public JsonValue get(String name) {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        int index = this.names.indexOf(name);
        return index != -1 ? this.values.get(index) : null;
    }

    public int size() {
        return this.names.size();
    }

    public boolean isEmpty() {
        return this.names.isEmpty();
    }

    public List<String> names() {
        return Collections.unmodifiableList(this.names);
    }

    @Override
    protected void write(JsonWriter writer) throws IOException {
        writer.writeBeginObject();
        int length = this.names.size();
        int i = 0;
        while (i < length) {
            if (i != 0) {
                writer.writeObjectValueSeparator();
            }
            writer.writeString(this.names.get(i));
            writer.writeNameValueSeparator();
            this.values.get(i).write(writer);
            ++i;
        }
        writer.writeEndObject();
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JsonObject asObject() {
        return this;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.names.hashCode();
        result = 31 * result + this.values.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        return this.names.equals(other.names) && this.values.equals(other.values);
    }
}

