/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.shared_ui.search.replace;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.python.pydev.shared_core.SharedCorePlugin;

public class ChangedFilesChecker {
    public static void checkFiles(Collection<IFile> files, Object validationContext, RefactoringStatus refactoringStatus) throws CoreException {
        ArrayList<IFile> readOnly = new ArrayList<IFile>();
        for (IFile file : files) {
            if (!file.isReadOnly()) continue;
            readOnly.add(file);
        }
        if (ResourcesPlugin.getPlugin() == null || SharedCorePlugin.inTestMode()) {
            return;
        }
        if (!readOnly.isEmpty()) {
            IFile[] readOnlyFiles = readOnly.toArray(new IFile[readOnly.size()]);
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IStatus status = workspace.validateEdit(readOnlyFiles, validationContext);
            if (status.getSeverity() == 8) {
                throw new OperationCanceledException();
            }
            refactoringStatus.merge(RefactoringStatus.create((IStatus)status));
            if (refactoringStatus.hasFatalError()) {
                return;
            }
        }
        refactoringStatus.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])files.toArray(new IFile[files.size()]), null));
    }
}

