/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractlocal;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.ast.adapters.AbstractScopeNode;
import org.python.pydev.ast.refactoring.RefactoringInfo;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.refactoring.coderefactoring.extractlocal.ExtractLocalChangeProcessor;
import org.python.pydev.refactoring.coderefactoring.extractlocal.ExtractLocalRequestProcessor;
import org.python.pydev.refactoring.core.base.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.core.validator.NameValidator;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.utils.ListUtils;
import org.python.pydev.shared_core.string.ICoreTextSelection;

public class ExtractLocalRefactoring
extends AbstractPythonRefactoring {
    private ExtractLocalRequestProcessor requestProcessor;

    public ExtractLocalRefactoring(RefactoringInfo info) {
        super(info);
        this.requestProcessor = new ExtractLocalRequestProcessor(info);
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ExtractLocalChangeProcessor changeProcessor = new ExtractLocalChangeProcessor(this.getName(), this.info, this.requestProcessor);
        return ListUtils.wrap(changeProcessor);
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringInfo.SelectionComputer bestSelection = this.info.getSelectionComputer(RefactoringInfo.SelectionComputer.SelectionComputerKind.extractLocal);
        exprType expression = bestSelection.getSingleExpression();
        ICoreTextSelection selection = bestSelection.selection;
        if (expression == null) {
            this.status.addFatalError(Messages.extractLocalNoExpressionSelected);
            return this.status;
        }
        AbstractScopeNode scopeAdapter = this.info.getModuleAdapter().getScopeAdapter(selection);
        this.requestProcessor.setDuplicates(scopeAdapter.getDuplicates(selection, expression));
        this.requestProcessor.setSelection(selection);
        this.requestProcessor.setExpression(expression);
        return this.status;
    }

    public String getName() {
        return Messages.extractLocalLabel;
    }

    public ExtractLocalRequestProcessor getRequestProcessor() {
        return this.requestProcessor;
    }

    public RefactoringStatus checkVarName(String variableName) {
        RefactoringStatus status = new RefactoringStatus();
        NameValidator nameValidator = new NameValidator(status, this.info.getScopeAdapter());
        nameValidator.validateVariableName(variableName);
        nameValidator.validateUniqueVariable(variableName);
        return status;
    }
}

