/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.inlinelocal;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.ast.refactoring.RefactoringInfo;
import org.python.pydev.core.IGrammarVersionProvider;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.refactoring.coderefactoring.inlinelocal.InlineLocalRefactoring;
import org.python.pydev.shared_core.string.CoreTextSelection;
import org.python.pydev.shared_core.string.ICoreTextSelection;

public class InlineLocalTest
extends TestCase {
    private RefactoringInfo getInfo(IDocument document, ICoreTextSelection selection) {
        RefactoringInfo info = new RefactoringInfo(document, selection, new IGrammarVersionProvider(){

            public int getGrammarVersion() throws MisconfigurationException {
                return 99;
            }

            public IGrammarVersionProvider.AdditionalGrammarVersionsToCheck getAdditionalGrammarVersions() throws MisconfigurationException {
                return null;
            }
        });
        return info;
    }

    private void check(String contents, String expected) throws CoreException {
        Document document = new Document(contents);
        CoreTextSelection selection = new CoreTextSelection((IDocument)document, document.getLength() - 1, 0);
        RefactoringInfo info = this.getInfo((IDocument)document, (ICoreTextSelection)selection);
        InlineLocalRefactoring refactoring = new InlineLocalRefactoring(info);
        NullProgressMonitor monitor = new NullProgressMonitor();
        RefactoringStatus result = refactoring.checkAllConditions((IProgressMonitor)monitor);
        InlineLocalTest.assertTrue((String)("Refactoring is not ok: " + result.getMessageMatchingSeverity(2)), (boolean)result.isOK());
        Change change = refactoring.createChange((IProgressMonitor)monitor);
        change.perform((IProgressMonitor)monitor);
        InlineLocalTest.assertEquals((String)expected, (String)document.get());
    }

    public void testSemicolonOnString() throws OperationCanceledException, CoreException {
        String contents = "s = \"A;B\"\nprint(s)";
        String expected = "print(\"A;B\")";
        this.check(contents, expected);
    }

    public void testMultiLineCall1() throws OperationCanceledException, CoreException {
        String contents = "new_elem = styling(\nx\n)\nprint(new_elem)";
        String expected = "print(styling(\n    x\n))";
        this.check(contents, expected);
    }

    public void testMultiLineCall2() throws OperationCanceledException, CoreException {
        String contents = "new_elem = styling(\n    *self.convert_children(styling_in, dataset)\n)\nprint(new_elem)";
        String expected = "print(styling(\n    *self.convert_children(styling_in, dataset)\n))";
        this.check(contents, expected);
    }

    public void testMultiLineCall3() throws OperationCanceledException, CoreException {
        String contents = "new_elem = styling[\nx\n]\nprint(new_elem)";
        String expected = "print(styling[\n    x\n])";
        this.check(contents, expected);
    }

    public void testMultiLineCall4() throws OperationCanceledException, CoreException {
        String contents = "new_elem = {\nx\n}\nprint(new_elem)";
        String expected = "print({\n    x\n})";
        this.check(contents, expected);
    }
}

